/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1313;
import net.minecraft.class_1665;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class ToyBall
extends ToyBase {
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    private static final class_2940<Integer> COLOR_ID = class_2945.method_12791(ToyBall.class, (class_2941)class_2943.field_13327);

    public ToyBall(class_1299<ToyBall> type, class_1937 level) {
        super(type, level, 15, class_3417.field_14863);
    }

    protected void method_5693() {
        this.field_6011.method_12784(COLOR_ID, (Object)class_1767.field_7952.method_7789());
    }

    public void method_5697(class_1297 entity) {
        if (entity != null && !(entity instanceof ToyBase)) {
            this.pushBall(entity);
        }
    }

    private void pushBall(float yRot) {
        this.method_5710(yRot, this.method_36455());
        this.method_5762(-class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))) * 0.5f, 0.1, class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * 0.5f);
    }

    private void pushBall(class_1297 entity) {
        class_243 offset = Util.directionVecTo(entity, this);
        double yawDiff = class_3532.method_15349((double)offset.field_1350, (double)offset.field_1352) * 57.2957763671875;
        this.pushBall(Util.yawToYRot(yawDiff));
    }

    @Override
    public boolean method_30948() {
        return false;
    }

    public boolean method_5810() {
        return true;
    }

    protected void pushEntities() {
        List list = this.field_6002.method_8333((class_1297)this, this.method_5829(), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            int j;
            int i = this.field_6002.method_8450().method_8356(class_1928.field_19405);
            if (i > 0 && list.size() > i - 1 && this.field_5974.method_43048(4) == 0) {
                j = 0;
                for (class_1297 entity : list) {
                    if (entity.method_5765()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.method_5643(this.field_6002.method_48963().method_48823(), 6.0f);
                }
            }
            for (j = 0; j < list.size(); ++j) {
                class_1297 entity = (class_1297)list.get(j);
                this.doPush(entity);
            }
        }
    }

    protected void doPush(class_1297 entity) {
        entity.method_5697((class_1297)this);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (Math.abs(this.method_18798().field_1352) > 0.01 || Math.abs(this.method_18798().field_1350) > 0.01) {
            this.method_5710(this.method_36454(), this.method_36455() + 14.0f);
        }
        this.aiStep();
    }

    private void aiStep() {
        if (this.method_5787()) {
            this.lerpSteps = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.lerpSteps > 0) {
            double d = this.method_23317() + (this.lerpX - this.method_23317()) / (double)this.lerpSteps;
            double e = this.method_23318() + (this.lerpY - this.method_23318()) / (double)this.lerpSteps;
            double f = this.method_23321() + (this.lerpZ - this.method_23321()) / (double)this.lerpSteps;
            double g = class_3532.method_15338((double)(this.lerpYRot - (double)this.method_36454()));
            this.method_36456(this.method_36454() + (float)g / (float)this.lerpSteps);
            --this.lerpSteps;
            this.method_5814(d, e, f);
            this.method_5710(this.method_36454(), this.method_36455());
        } else if (this.field_6002.field_9236) {
            this.method_18799(this.method_18798().method_1021(0.98));
        }
        if (this.method_5777(class_3486.field_15517)) {
            this.method_5762(0.0, 0.1, 0.0);
        }
        if (this.field_5976) {
            this.pushBall(this.method_36454() + 180.0f);
        }
        class_243 vec3 = this.method_18798();
        double x = vec3.field_1352;
        double y = vec3.field_1351;
        double z = vec3.field_1350;
        if (Math.abs(vec3.field_1352) < 0.003) {
            x = 0.0;
        }
        if (Math.abs(vec3.field_1351) < 0.003) {
            y = 0.0;
        }
        if (Math.abs(vec3.field_1350) < 0.003) {
            z = 0.0;
        }
        this.method_18800(x, y, z);
        this.travel();
        this.pushEntities();
    }

    private void travel() {
        if (!this.field_6002.field_9236 || this.method_5787()) {
            boolean isFalling;
            double gravity = 0.08;
            boolean bl = isFalling = this.method_18798().field_1351 <= 0.0;
            if (this.method_5799()) {
                double e = this.method_23318();
                float friction = 0.8f;
                float g = 0.02f;
                this.method_5724(g, class_243.field_1353);
                this.method_5784(class_1313.field_6308, this.method_18798());
                class_243 vec3 = this.method_18798();
                this.method_18799(vec3.method_18805((double)friction, 0.8, (double)friction));
                double dy = isFalling && Math.abs(this.method_18798().field_1351 - 0.005) >= 0.003 && Math.abs(this.method_18798().field_1351 - gravity / 16.0) < 0.003 ? -0.003 : this.method_18798().field_1351 - gravity / 16.0;
                class_243 fallingAdjusted = new class_243(this.method_18798().field_1352, dy, this.method_18798().field_1350);
                this.method_18799(fallingAdjusted);
                if (this.field_5976 && this.method_5654(fallingAdjusted.field_1352, fallingAdjusted.field_1351 + 0.6 - this.method_23318() + e, fallingAdjusted.field_1350)) {
                    this.method_18800(fallingAdjusted.field_1352, 0.3, fallingAdjusted.field_1350);
                }
            } else {
                class_2338 blockPos = this.method_23314();
                float blockFriction = this.field_6002.method_8320(blockPos).method_26204().method_9499();
                float friction = this.field_5952 ? blockFriction * 0.91f : 0.91f;
                this.method_5724(0.0f, class_243.field_1353);
                this.method_5784(class_1313.field_6308, this.method_18798());
                class_243 vec36 = this.method_18798();
                double q = vec36.field_1351;
                if (this.field_6002.field_9236 && !this.field_6002.method_22340(blockPos)) {
                    q = this.method_23318() > (double)this.field_6002.method_31607() ? -0.1 : 0.0;
                } else if (!this.method_5740()) {
                    q -= gravity;
                }
                this.method_18800(vec36.field_1352 * (double)friction, q * 0.98, vec36.field_1350 * (double)friction);
            }
        }
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.method_36457(xRot < 0.0f ? 360.0f + xRot : xRot);
        this.lerpSteps = lerpSteps;
    }

    @Override
    protected boolean tickAI() {
        return true;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)class_12972;
            this.method_5697((class_1297)prehistoric);
            this.method_5848();
        } else {
            class_12972 = source.method_5526();
            if (class_12972 instanceof class_1665) {
                class_1665 javelin = (class_1665)class_12972;
                this.method_5783(this.attackNoise, 1.0f, this.getVoicePitch());
                this.method_5697((class_1297)javelin);
                return true;
            }
        }
        return super.method_5643(source, amount);
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)ModItems.TOY_BALLS.get(this.getColor()).get());
    }

    public class_1767 getColor() {
        return class_1767.method_7791((int)((Integer)this.field_6011.method_12789(COLOR_ID)));
    }

    public void setColor(class_1767 color) {
        this.field_6011.method_12778(COLOR_ID, (Object)color.method_7789());
    }

    public void method_5652(class_2487 compound) {
        compound.method_10569("color", this.getColor().method_7789());
    }

    public void method_5749(class_2487 compound) {
        this.setColor(class_1767.method_7791((int)compound.method_10550("color")));
    }
}

