/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CActivateAttackBoxesMessage;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class DelayedAttackGoal<T extends Prehistoric>
extends class_1352 {
    protected static final Predicate<class_1297> CAN_ATTACK_TARGET = target -> {
        class_1657 player;
        return !(target instanceof class_1657) || !(player = (class_1657)target).method_7325() && !player.method_7337() && target.field_6002.method_8407() != class_1267.field_5801;
    };
    protected static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    protected final T mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    protected class_11 path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    protected long lastCanUseCheck;
    protected long attackEndTick = -1L;
    protected long attackDamageTick = -1L;
    private boolean doingHeavyAttack;

    public DelayedAttackGoal(T mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        long l = ((Prehistoric)this.mob).field_6002.method_8510();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        if (((Prehistoric)this.mob).isFleeing() || ((Prehistoric)this.mob).getCurrentOrder() == OrderType.STAY) {
            return false;
        }
        class_1309 target = this.mob.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (((Prehistoric)this.mob).field_6002.method_8407() == class_1267.field_5801 && target instanceof class_1657) {
            return false;
        }
        this.path = this.mob.method_5942().method_6349((class_1297)target, 0);
        if (this.path != null) {
            return true;
        }
        return this.isInRange((class_1297)target);
    }

    public boolean method_6266() {
        if (((Prehistoric)this.mob).field_6002.method_8510() < this.attackEndTick) {
            return true;
        }
        class_1309 target = this.mob.method_5968();
        if (target == null || !target.method_5805() || ((Prehistoric)this.mob).getCurrentOrder() == OrderType.STAY) {
            System.out.println("Cant continue attacking because: " + (target == null));
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.method_5942().method_6357();
        }
        if (!this.mob.method_18407(target.method_24515())) {
            return false;
        }
        return CAN_ATTACK_TARGET.test((class_1297)target);
    }

    public void method_6269() {
        this.mob.method_5942().method_6334(this.path, this.speedModifier);
        this.mob.method_19540(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.attackEndTick = -1L;
        this.attackDamageTick = -1L;
        this.doingHeavyAttack = false;
    }

    public void method_6270() {
        class_1309 target = this.mob.method_5968();
        if (!CAN_ATTACK_TARGET.test((class_1297)target)) {
            this.mob.method_5980(null);
        }
        this.mob.method_19540(false);
        this.mob.method_5942().method_6340();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        boolean canRunAway;
        class_1309 target = this.mob.method_5968();
        if (target == null) {
            return;
        }
        double dist = this.mob.method_5858((class_1297)target);
        if (this.canUpdateMovement()) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            this.mob.method_5951((class_1297)target, 10.0f, 30.0f);
        } else {
            this.ticksUntilNextPathRecalculation = 15;
        }
        boolean inRange = this.isInRange((class_1297)target);
        boolean bl = canRunAway = target instanceof class_1657 || target.method_6052() != this.mob;
        if ((!inRange || canRunAway && Util.movingAwayFrom((class_1297)target, this.mob)) && this.ticksUntilNextPathRecalculation <= 0 && (this.followingTargetEvenIfNotSeen || this.mob.method_5985().method_6369((class_1297)target))) {
            this.ticksUntilNextPathRecalculation = 4 + this.mob.method_6051().method_43048(7);
            if (dist > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (dist > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.method_5942().method_6335((class_1297)target, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.method_38847(this.ticksUntilNextPathRecalculation);
        }
        this.checkAndPerformAttack(target, inRange);
    }

    protected boolean canUpdateMovement() {
        return !this.doingHeavyAttack || ((Prehistoric)this.mob).field_6002.method_8510() > this.attackEndTick;
    }

    protected boolean isInRange(class_1297 attackTarget) {
        return Util.canReachPrey(this.mob, attackTarget);
    }

    protected void checkAndPerformAttack(class_1309 enemy, boolean inRange) {
        long currentTime = ((Prehistoric)this.mob).field_6002.method_8510();
        if (inRange) {
            if (currentTime > this.attackEndTick + 20L) {
                ServerAnimationInfo animationInfo = ((Prehistoric)this.mob).startAttack();
                if (animationInfo.usesAttackBox && enemy instanceof class_3222) {
                    class_3222 player = (class_3222)enemy;
                    MessageHandler.SYNC_CHANNEL.sendToPlayers(List.of(player), (Object)new S2CActivateAttackBoxesMessage((class_1297)this.mob, animationInfo.animation.length()));
                    this.doingHeavyAttack = true;
                } else {
                    this.attackDamageTick = (long)((double)currentTime + animationInfo.actionDelay + 5.0);
                }
                this.attackEndTick = (long)((double)currentTime + animationInfo.animation.length());
                if (this.attackDamageTick > this.attackEndTick) {
                    this.attackDamageTick = this.attackEndTick;
                }
            }
            if (this.attackDamageTick > 0L && currentTime == this.attackDamageTick) {
                ((Prehistoric)this.mob).attackTarget(enemy);
                this.attackDamageTick = -1L;
            }
        }
    }
}

