/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.ai.control.PrehistoricLookControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.LeapSystem;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public abstract class PrehistoricLeaping
extends Prehistoric {
    public static final class_2940<Boolean> LEAPING = class_2945.method_12791(PrehistoricLeaping.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> LEAP_STARTED = class_2945.method_12791(PrehistoricLeaping.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> LEAP_FLYING = class_2945.method_12791(PrehistoricLeaping.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> LEAP_TARGET_ID = class_2945.method_12791(PrehistoricLeaping.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> LEAP_RIDING = class_2945.method_12791(PrehistoricLeaping.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> LEAP_LANDING = class_2945.method_12791(PrehistoricLeaping.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LANDING = class_2945.method_12791(PrehistoricLeaping.class, (class_2941)class_2943.field_13323);
    private final LeapSystem leapSystem = this.registerSystem(new LeapSystem(this));

    protected PrehistoricLeaping(class_1299<? extends PrehistoricLeaping> entityType, class_1937 level, boolean canAttach) {
        super(entityType, level);
        this.field_6207 = new LeapMoveControl();
        this.field_6206 = new LeapLookControl();
    }

    @Override
    protected void method_20417() {
        boolean bl = !this.leapSystem.isLeaping() && !this.method_6113();
        this.field_6201.method_6276(class_1352.class_4134.field_18405, bl && !this.sitSystem.isSitting());
        this.field_6201.method_6276(class_1352.class_4134.field_18407, bl && !this.sitSystem.isSitting());
        this.field_6201.method_6276(class_1352.class_4134.field_18406, bl);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LEAPING, (Object)false);
        this.field_6011.method_12784(LEAP_STARTED, (Object)false);
        this.field_6011.method_12784(LEAP_RIDING, (Object)false);
        this.field_6011.method_12784(LEAP_FLYING, (Object)false);
        this.field_6011.method_12784(LEAP_LANDING, (Object)false);
        this.field_6011.method_12784(LEAP_TARGET_ID, (Object)-1);
        this.field_6011.method_12784(LANDING, (Object)false);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        if (LEAP_RIDING.equals(key)) {
            if (((Boolean)this.field_6011.method_12789(LEAP_RIDING)).booleanValue() && (Integer)this.field_6011.method_12789(LEAP_TARGET_ID) >= 0) {
                this.method_5873(Objects.requireNonNull(this.field_6002.method_8469(((Integer)this.field_6011.method_12789(LEAP_TARGET_ID)).intValue())), true);
            } else {
                this.method_5848();
            }
        }
        super.method_5674(key);
    }

    public double method_5678() {
        return -0.025;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        boolean hurt = super.method_5643(source, amount);
        if (hurt && this.leapSystem.isAttackRiding() && this.method_6065() != null && this.method_6065() == this.method_5854() && this.field_5974.method_43048(2) == 0) {
            this.getLeapSystem().stopAttackRiding();
            this.method_5848();
        }
        return hurt;
    }

    @Override
    protected boolean canClimb() {
        return !this.getLeapSystem().isLeaping() && super.canClimb();
    }

    public LeapSystem getLeapSystem() {
        return this.leapSystem;
    }

    public void startLeap(class_1297 target) {
        this.leapSystem.setLeapStarted(true);
        this.field_6011.method_12778(LEAP_TARGET_ID, (Object)target.method_5628());
    }

    public void method_5697(class_1297 entity) {
        super.method_5697(entity);
        if (this.getLeapSystem().isLeapingAt(entity)) {
            this.getLeapSystem().tryAttackRiding(entity);
        }
    }

    @NotNull
    public AnimationInfo getLeapStartAnimation() {
        return this.getAllAnimations().get(this.getLeapStartAnimationName());
    }

    @NotNull
    public AnimationInfo getLandAnimation() {
        return this.getAllAnimations().get(this.getLandAnimationName());
    }

    @NotNull
    public AnimationInfo getLeapAttackAnimation() {
        return this.getAllAnimations().get(this.getLeapAttackAnimationName());
    }

    public abstract String getLandAnimationName();

    public abstract String getLeapStartAnimationName();

    public abstract String getLeapAttackAnimationName();

    public boolean hasLeapAnimation() {
        return true;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        PausableAnimationController<PrehistoricLeaping> controller = new PausableAnimationController<PrehistoricLeaping>(this, "Movement/Idle", 5, this.getAnimationLogic()::leapingPredicate);
        this.registerEatingListeners(controller, effect -> {
            class_2680 below;
            if ("land".equals(effect) && this.method_24828() && (below = this.field_6002.method_8320(class_2338.method_49637((double)this.method_23317(), (double)(this.method_23318() - 0.2), (double)this.method_23321()))).method_26217() != class_2464.field_11455) {
                class_243 vec3 = this.method_18798();
                this.field_6002.method_8406((class_2394)new class_2388(class_2398.field_11217, below), this.method_23317() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681() / 2.0, this.method_23318(), this.method_23321() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681() / 2.0, vec3.field_1352 * 4.0, 1.0, vec3.field_1350 * 4.0);
            }
        });
        this.registerControllerWithTriggers(controllerRegistrar, controller);
        PausableAnimationController<PrehistoricLeaping> attackController = new PausableAnimationController<PrehistoricLeaping>(this, "Attack", 5, this.getAnimationLogic()::attackPredicate);
        this.registerControllerWithTriggers(controllerRegistrar, attackController);
    }

    class LeapMoveControl
    extends SmoothTurningMoveControl {
        public LeapMoveControl() {
            super(PrehistoricLeaping.this);
        }

        @Override
        public void method_6240() {
            if (!PrehistoricLeaping.this.getLeapSystem().isLeaping()) {
                super.method_6240();
            }
        }
    }

    class LeapLookControl
    extends PrehistoricLookControl {
        public LeapLookControl() {
            super(PrehistoricLeaping.this);
        }

        @Override
        public void method_6231() {
            if (!PrehistoricLeaping.this.getLeapSystem().isLeaping()) {
                super.method_6231();
            }
        }
    }
}

