/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlayerNodeEvaluator {
    protected PathNavigationRegion level;
    protected Player player;
    protected final Int2ObjectMap<Node> nodes = new Int2ObjectOpenHashMap();
    protected int entityWidth;
    protected int entityHeight;
    protected int entityDepth;
    protected boolean canPassDoors;
    protected boolean canOpenDoors;
    protected boolean canFloat;
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    protected float oldWaterCost;
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();

    public void prepare(PathNavigationRegion l, Player p) {
        this.level = l;
        this.player = p;
        this.nodes.clear();
        this.entityWidth = Mth.m_14143_((float)(PathingRenderer.getBbWidth() + 1.0f));
        this.entityHeight = Mth.m_14143_((float)(PathingRenderer.getBbHeight() + 1.0f));
        this.entityDepth = Mth.m_14143_((float)(PathingRenderer.getBbWidth() + 1.0f));
        this.oldWaterCost = PathingDebug.getPathfindingMalus(BlockPathTypes.WATER);
    }

    public void done() {
        PathingDebug.setPathfindingMalus(BlockPathTypes.WATER, this.oldWaterCost);
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        this.level = null;
        this.player = null;
    }

    protected Node getNode(BlockPos pos) {
        return this.getNode(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    protected Node getNode(int x, int y, int z) {
        return (Node)this.nodes.computeIfAbsent(Node.m_77295_((int)x, (int)y, (int)z), l -> new Node(x, y, z));
    }

    public Node getStart() {
        int i = Mth.m_14107_((double)((double)PathingDebug.pos1.m_123342_() + 0.5));
        BlockPathTypes blockPathTypes = this.getCachedBlockType(this.player, PathingDebug.pos1.m_123341_(), i, PathingDebug.pos1.m_123343_());
        if (PathingDebug.getPathfindingMalus(blockPathTypes) < 0.0f) {
            AABB aABB = PathingRenderer.getBigHitbox().m_82338_(PathingDebug.pos1);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            if (this.hasPositiveMalus((BlockPos)mutableBlockPos.m_122169_(aABB.f_82288_, (double)i, aABB.f_82290_)) || this.hasPositiveMalus((BlockPos)mutableBlockPos.m_122169_(aABB.f_82288_, (double)i, aABB.f_82293_)) || this.hasPositiveMalus((BlockPos)mutableBlockPos.m_122169_(aABB.f_82291_, (double)i, aABB.f_82290_)) || this.hasPositiveMalus((BlockPos)mutableBlockPos.m_122169_(aABB.f_82291_, (double)i, aABB.f_82293_))) {
                Node node = this.getNode((BlockPos)mutableBlockPos);
                node.f_77282_ = this.getBlockPathType(this.player, node.m_77288_());
                node.f_77281_ = PathingDebug.getPathfindingMalus(node.f_77282_);
                return node;
            }
        }
        Node node2 = this.getNode(PathingDebug.pos1.m_123341_(), i, PathingDebug.pos1.m_123343_());
        node2.f_77282_ = this.getBlockPathType(this.player, node2.m_77288_());
        node2.f_77281_ = PathingDebug.getPathfindingMalus(node2.f_77282_);
        return node2;
    }

    protected boolean hasPositiveMalus(BlockPos pos) {
        BlockPathTypes blockPathTypes = this.getBlockPathType(this.player, pos);
        return PathingDebug.getPathfindingMalus(blockPathTypes) >= 0.0f;
    }

    public Target getGoal(double x, double y, double z) {
        return new Target(this.getNode(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)));
    }

    public int getBlockedNeighbors(Node[] nodes, Node start, BlockPos[] neighborsX) {
        double d = this.getFloorLevel(new BlockPos(start.f_77271_, start.f_77272_, start.f_77273_));
        int count = 0;
        int countX = 0;
        for (int i = 0; i < this.entityWidth; ++i) {
            for (int j = 0; j < this.entityHeight; ++j) {
                for (int k = 0; k < this.entityDepth; ++k) {
                    Node node = this.findBlockedNode(start.f_77271_ + i, start.f_77272_ + j, start.f_77273_ + k, d);
                    if (node != null) {
                        nodes[count++] = node;
                        continue;
                    }
                    neighborsX[countX++] = new BlockPos(start.f_77271_ + i, start.f_77272_ + j, start.f_77273_ + k);
                }
            }
        }
        return count;
    }

    public int getNeighbors(Node[] nodes, Node node) {
        Node node9;
        Node node8;
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        double d;
        Node node2;
        int i = 0;
        int j = 0;
        BlockPathTypes blockTypeAbove = this.getCachedBlockType(this.player, node.f_77271_, node.f_77272_ + 1, node.f_77273_);
        BlockPathTypes blockType = this.getCachedBlockType(this.player, node.f_77271_, node.f_77272_, node.f_77273_);
        if (PathingDebug.getPathfindingMalus(blockTypeAbove) >= 0.0f && blockType != BlockPathTypes.STICKY_HONEY) {
            j = Mth.m_14143_((float)Math.max(1.0f, this.player.m_274421_()));
        }
        if (this.isNeighborValid(node2 = this.findAcceptedNode(node.f_77271_, node.f_77272_, node.f_77273_ + 1, j, d = this.getFloorLevel(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_)), Direction.SOUTH, blockType), node)) {
            nodes[i++] = node2;
        }
        if (this.isNeighborValid(node3 = this.findAcceptedNode(node.f_77271_ - 1, node.f_77272_, node.f_77273_, j, d, Direction.WEST, blockType), node)) {
            nodes[i++] = node3;
        }
        if (this.isNeighborValid(node4 = this.findAcceptedNode(node.f_77271_ + 1, node.f_77272_, node.f_77273_, j, d, Direction.EAST, blockType), node)) {
            nodes[i++] = node4;
        }
        if (this.isNeighborValid(node5 = this.findAcceptedNode(node.f_77271_, node.f_77272_, node.f_77273_ - 1, j, d, Direction.NORTH, blockType), node)) {
            nodes[i++] = node5;
        }
        if (this.isDiagonalValid(node, node3, node5, node6 = this.findAcceptedNode(node.f_77271_ - 1, node.f_77272_, node.f_77273_ - 1, j, d, Direction.NORTH, blockType))) {
            nodes[i++] = node6;
        }
        if (this.isDiagonalValid(node, node4, node5, node7 = this.findAcceptedNode(node.f_77271_ + 1, node.f_77272_, node.f_77273_ - 1, j, d, Direction.NORTH, blockType))) {
            nodes[i++] = node7;
        }
        if (this.isDiagonalValid(node, node3, node2, node8 = this.findAcceptedNode(node.f_77271_ - 1, node.f_77272_, node.f_77273_ + 1, j, d, Direction.SOUTH, blockType))) {
            nodes[i++] = node8;
        }
        if (this.isDiagonalValid(node, node4, node2, node9 = this.findAcceptedNode(node.f_77271_ + 1, node.f_77272_, node.f_77273_ + 1, j, d, Direction.SOUTH, blockType))) {
            nodes[i++] = node9;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable Node node, Node node2) {
        return node != null && !node.f_77279_ && (node.f_77281_ >= 0.0f || node2.f_77281_ < 0.0f);
    }

    protected boolean isDiagonalValid(Node node, @Nullable Node node2, @Nullable Node node3, @Nullable Node node4) {
        if (node4 == null || node3 == null || node2 == null) {
            return false;
        }
        if (node4.f_77279_) {
            return false;
        }
        if (node3.f_77272_ > node.f_77272_ || node2.f_77272_ > node.f_77272_) {
            return false;
        }
        if (node2.f_77282_ == BlockPathTypes.WALKABLE_DOOR || node3.f_77282_ == BlockPathTypes.WALKABLE_DOOR || node4.f_77282_ == BlockPathTypes.WALKABLE_DOOR) {
            return false;
        }
        boolean bl = node3.f_77282_ == BlockPathTypes.FENCE && node2.f_77282_ == BlockPathTypes.FENCE && (double)PathingRenderer.getBbWidth() < 0.5;
        return node4.f_77281_ >= 0.0f && (node3.f_77272_ < node.f_77272_ || node3.f_77281_ >= 0.0f || bl) && (node2.f_77272_ < node.f_77272_ || node2.f_77281_ >= 0.0f || bl);
    }

    private boolean canReachWithoutCollision(Node node) {
        Vec3 vec3 = new Vec3((double)node.f_77271_ - this.player.m_20185_(), (double)node.f_77272_ - this.player.m_20186_(), (double)node.f_77273_ - this.player.m_20189_());
        AABB aABB = this.player.m_20191_();
        int i = Mth.m_14165_((double)(vec3.m_82553_() / aABB.m_82309_()));
        vec3 = vec3.m_82490_((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(aABB = aABB.m_82383_(vec3))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(BlockPos pos) {
        return PlayerNodeEvaluator.getFloorLevel((BlockGetter)this.level, pos);
    }

    public static double getFloorLevel(BlockGetter level, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        VoxelShape voxelShape = level.m_8055_(blockPos).m_60812_(level, blockPos);
        return (double)blockPos.m_123342_() + (voxelShape.m_83281_() ? 0.0 : voxelShape.m_83297_(Direction.Axis.Y));
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected Node findBlockedNode(int x, int y, int z, double d) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        double e = this.getFloorLevel((BlockPos)mutableBlockPos.m_122178_(x, y, z));
        if ((double)y - d > (double)this.entityHeight && e - d > 1.125) {
            return null;
        }
        BlockPathTypes blockPathType = this.getBlockPathType((BlockGetter)this.level, x, y, z);
        blockPathType = this.evaluateBlockPathType((BlockGetter)this.level, this.canOpenDoors, false, BlockPos.f_121853_, blockPathType);
        Node node = this.getNode(x, y, z);
        node.f_77279_ = true;
        node.f_77282_ = blockPathType;
        node.f_77281_ = blockPathType.m_77124_();
        return node;
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z, int i, double d, Direction direction, BlockPathTypes blockPathTypes) {
        double j;
        double h;
        Node node = null;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        double e = this.getFloorLevel((BlockPos)mutableBlockPos.m_122178_(x, y, z));
        if (e - d > (double)this.entityHeight && e - d > 1.125) {
            return null;
        }
        BlockPathTypes blockPathTypes2 = this.getCachedBlockType(this.player, x, y, z);
        float f = PathingDebug.getPathfindingMalus(blockPathTypes2);
        double g = (double)PathingRenderer.getBbWidth() / 2.0;
        if (f >= 0.0f) {
            node = this.getNode(x, y, z);
            node.f_77282_ = blockPathTypes2;
            node.f_77281_ = Math.max(node.f_77281_, f);
        }
        if (blockPathTypes == BlockPathTypes.FENCE && node != null && node.f_77281_ >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (blockPathTypes2 == BlockPathTypes.WALKABLE || this.isAmphibious() && blockPathTypes2 == BlockPathTypes.WATER) {
            return node;
        }
        if ((node == null || node.f_77281_ < 0.0f) && i > 0 && blockPathTypes2 != BlockPathTypes.FENCE && blockPathTypes2 != BlockPathTypes.UNPASSABLE_RAIL && blockPathTypes2 != BlockPathTypes.TRAPDOOR && blockPathTypes2 != BlockPathTypes.POWDER_SNOW && (node = this.findAcceptedNode(x, y + 1, z, i - 1, d, direction, blockPathTypes)) != null && (node.f_77282_ == BlockPathTypes.OPEN || node.f_77282_ == BlockPathTypes.WALKABLE) && PathingRenderer.getBbWidth() < 1.0f && this.hasCollisions(new AABB((h = (double)(x - direction.m_122429_()) + 0.5) - g, PlayerNodeEvaluator.getFloorLevel((BlockGetter)this.level, (BlockPos)mutableBlockPos.m_122169_(h, (double)(y + 1), j = (double)(z - direction.m_122431_()) + 0.5)) + 0.001, j - g, h + g, (double)PathingRenderer.getBbHeight() + PlayerNodeEvaluator.getFloorLevel((BlockGetter)this.level, (BlockPos)mutableBlockPos.m_122169_((double)node.f_77271_, (double)node.f_77272_, (double)node.f_77273_)) - 0.002, j + g))) {
            node = null;
        }
        if (!this.isAmphibious() && blockPathTypes2 == BlockPathTypes.WATER && !this.canFloat()) {
            if (this.getCachedBlockType(this.player, x, y - 1, z) != BlockPathTypes.WATER) {
                return node;
            }
            while (y > this.player.f_19853_.m_141937_()) {
                if ((blockPathTypes2 = this.getCachedBlockType(this.player, x, --y, z)) == BlockPathTypes.WATER) {
                    node = this.getNode(x, y, z);
                    node.f_77282_ = blockPathTypes2;
                    node.f_77281_ = Math.max(node.f_77281_, PathingDebug.getPathfindingMalus(blockPathTypes2));
                    continue;
                }
                return node;
            }
        }
        if (blockPathTypes2 == BlockPathTypes.OPEN) {
            int k = 0;
            int l = y;
            while (blockPathTypes2 == BlockPathTypes.OPEN) {
                if (--y < this.player.f_19853_.m_141937_()) {
                    Node node2 = this.getNode(x, l, z);
                    node2.f_77282_ = BlockPathTypes.BLOCKED;
                    node2.f_77281_ = -1.0f;
                    return node2;
                }
                if (k++ >= this.player.m_6056_()) {
                    Node node2 = this.getNode(x, y, z);
                    node2.f_77282_ = BlockPathTypes.BLOCKED;
                    node2.f_77281_ = -1.0f;
                    return node2;
                }
                blockPathTypes2 = this.getCachedBlockType(this.player, x, y, z);
                f = PathingDebug.getPathfindingMalus(blockPathTypes2);
                if (blockPathTypes2 != BlockPathTypes.OPEN && f >= 0.0f) {
                    node = this.getNode(x, y, z);
                    node.f_77282_ = blockPathTypes2;
                    node.f_77281_ = Math.max(node.f_77281_, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                Node node2 = this.getNode(x, y, z);
                node2.f_77282_ = BlockPathTypes.BLOCKED;
                node2.f_77281_ = -1.0f;
                return node2;
            }
        }
        if (blockPathTypes2 == BlockPathTypes.FENCE) {
            node = this.getNode(x, y, z);
            node.f_77279_ = true;
            node.f_77282_ = blockPathTypes2;
            node.f_77281_ = blockPathTypes2.m_77124_();
        }
        return node;
    }

    private boolean hasCollisions(AABB aABB) {
        return this.collisionCache.computeIfAbsent((Object)aABB, object -> !this.level.m_45756_((Entity)this.player, aABB));
    }

    public BlockPathTypes getBlockPathType(BlockGetter blockaccess, int x, int y, int z, Player entityliving, int xSize, int ySize, int zSize, boolean canBreakDoors, boolean canEnterDoors) {
        EnumSet<BlockPathTypes> enumSet = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockPathTypes = BlockPathTypes.BLOCKED;
        BlockPos blockPos = entityliving.m_20183_();
        blockPathTypes = this.getBlockPathTypes(blockaccess, x, y, z, xSize, ySize, zSize, canBreakDoors, canEnterDoors, enumSet, blockPathTypes, blockPos);
        if (enumSet.contains(BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        if (enumSet.contains(BlockPathTypes.UNPASSABLE_RAIL)) {
            return BlockPathTypes.UNPASSABLE_RAIL;
        }
        BlockPathTypes blockPathTypes2 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockPathTypes3 : enumSet) {
            if (PathingDebug.getPathfindingMalus(blockPathTypes3) < 0.0f) {
                return blockPathTypes3;
            }
            if (PathingDebug.getPathfindingMalus(blockPathTypes3) < PathingDebug.getPathfindingMalus(blockPathTypes2)) continue;
            blockPathTypes2 = blockPathTypes3;
        }
        if (blockPathTypes == BlockPathTypes.OPEN && PathingDebug.getPathfindingMalus(blockPathTypes2) == 0.0f && xSize <= 1) {
            return BlockPathTypes.OPEN;
        }
        return blockPathTypes2;
    }

    public BlockPathTypes getBlockPathTypes(BlockGetter level, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoors, boolean canEnterDoors, EnumSet<BlockPathTypes> nodeTypeEnum, BlockPathTypes nodeType, BlockPos pos) {
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int m = j + y;
                    int n = k + z;
                    BlockPathTypes blockPathTypes = this.getBlockPathType(level, l, m, n);
                    blockPathTypes = this.evaluateBlockPathType(level, canOpenDoors, canEnterDoors, pos, blockPathTypes);
                    if (i == 0 && j == 0 && k == 0) {
                        nodeType = blockPathTypes;
                    }
                    nodeTypeEnum.add(blockPathTypes);
                }
            }
        }
        return nodeType;
    }

    protected BlockPathTypes evaluateBlockPathType(BlockGetter level, boolean canOpenDoors, boolean canEnterDoors, BlockPos pos, BlockPathTypes nodeType) {
        if (nodeType == BlockPathTypes.DOOR_WOOD_CLOSED && canOpenDoors && canEnterDoors) {
            nodeType = BlockPathTypes.WALKABLE_DOOR;
        }
        if (nodeType == BlockPathTypes.DOOR_OPEN && !canEnterDoors) {
            nodeType = BlockPathTypes.BLOCKED;
        }
        if (nodeType == BlockPathTypes.RAIL && !(level.m_8055_(pos).m_60734_() instanceof BaseRailBlock) && !(level.m_8055_(pos.m_7495_()).m_60734_() instanceof BaseRailBlock)) {
            nodeType = BlockPathTypes.UNPASSABLE_RAIL;
        }
        if (nodeType == BlockPathTypes.LEAVES) {
            nodeType = BlockPathTypes.BLOCKED;
        }
        return nodeType;
    }

    private BlockPathTypes getBlockPathType(Player entityliving, BlockPos pos) {
        return this.getCachedBlockType(entityliving, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    protected BlockPathTypes getCachedBlockType(Player entity, int x, int y, int z) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)x, (int)y, (int)z), l -> this.getBlockPathType((BlockGetter)this.level, x, y, z, entity, this.entityWidth, this.entityHeight, this.entityDepth, this.canOpenDoors(), this.canPassDoors()));
    }

    public BlockPathTypes getBlockPathType(BlockGetter level, int x, int y, int z) {
        return PlayerNodeEvaluator.getBlockPathTypeStatic(level, new BlockPos.MutableBlockPos(x, y, z));
    }

    public static BlockPathTypes getBlockPathTypeStatic(BlockGetter level, BlockPos.MutableBlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        BlockPathTypes blockPathTypes = PlayerNodeEvaluator.getBlockPathTypeRaw(level, (BlockPos)pos);
        if (blockPathTypes == BlockPathTypes.OPEN && j >= level.m_141937_() + 1) {
            BlockPathTypes blockTypeBelow = PlayerNodeEvaluator.getBlockPathTypeRaw(level, (BlockPos)pos.m_122178_(i, j - 1, k));
            BlockPathTypes blockPathTypes2 = blockPathTypes = blockTypeBelow == BlockPathTypes.WALKABLE || blockTypeBelow == BlockPathTypes.OPEN || blockTypeBelow == BlockPathTypes.WATER || blockTypeBelow == BlockPathTypes.LAVA ? BlockPathTypes.OPEN : BlockPathTypes.WALKABLE;
            if (blockTypeBelow == BlockPathTypes.DAMAGE_FIRE) {
                blockPathTypes = BlockPathTypes.DAMAGE_FIRE;
            }
            if (blockTypeBelow == BlockPathTypes.DAMAGE_OTHER) {
                blockPathTypes = BlockPathTypes.DAMAGE_OTHER;
            }
            if (blockTypeBelow == BlockPathTypes.STICKY_HONEY) {
                blockPathTypes = BlockPathTypes.STICKY_HONEY;
            }
            if (blockTypeBelow == BlockPathTypes.POWDER_SNOW) {
                blockPathTypes = BlockPathTypes.DANGER_POWDER_SNOW;
            }
        }
        if (blockPathTypes == BlockPathTypes.WALKABLE) {
            blockPathTypes = PlayerNodeEvaluator.checkNeighbourBlocks(level, pos.m_122178_(i, j, k), blockPathTypes);
        }
        return blockPathTypes;
    }

    public static BlockPathTypes checkNeighbourBlocks(BlockGetter level, BlockPos.MutableBlockPos centerPos, BlockPathTypes nodeType) {
        int i = centerPos.m_123341_();
        int j = centerPos.m_123342_();
        int k = centerPos.m_123343_();
        for (int l = -1; l <= 1; ++l) {
            for (int m = -1; m <= 1; ++m) {
                for (int n = -1; n <= 1; ++n) {
                    if (l == 0 && n == 0) continue;
                    centerPos.m_122178_(i + l, j + m, k + n);
                    BlockState blockState = level.m_8055_((BlockPos)centerPos);
                    if (blockState.m_60713_(Blocks.f_50685_)) {
                        return BlockPathTypes.DANGER_OTHER;
                    }
                    if (PlayerNodeEvaluator.isBurningBlock(blockState)) {
                        return BlockPathTypes.DANGER_FIRE;
                    }
                    if (!level.m_6425_((BlockPos)centerPos).m_205070_(FluidTags.f_13131_)) continue;
                    return BlockPathTypes.WATER_BORDER;
                }
            }
        }
        return nodeType;
    }

    protected static BlockPathTypes getBlockPathTypeRaw(BlockGetter level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        Material material = blockState.m_60767_();
        if (blockState.m_60795_()) {
            return BlockPathTypes.OPEN;
        }
        if (blockState.m_204336_(BlockTags.f_13036_) || blockState.m_60713_(Blocks.f_50196_) || blockState.m_60713_(Blocks.f_152545_)) {
            return BlockPathTypes.TRAPDOOR;
        }
        if (blockState.m_60713_(Blocks.f_152499_)) {
            return BlockPathTypes.POWDER_SNOW;
        }
        if (blockState.m_60713_(Blocks.f_50685_)) {
            return BlockPathTypes.DAMAGE_OTHER;
        }
        if (blockState.m_60713_(Blocks.f_50719_)) {
            return BlockPathTypes.STICKY_HONEY;
        }
        if (blockState.m_60713_(Blocks.f_50262_)) {
            return BlockPathTypes.COCOA;
        }
        FluidState fluidState = level.m_6425_(pos);
        if (fluidState.m_205070_(FluidTags.f_13132_)) {
            return BlockPathTypes.LAVA;
        }
        if (PlayerNodeEvaluator.isBurningBlock(blockState)) {
            return BlockPathTypes.DAMAGE_FIRE;
        }
        if (DoorBlock.m_52817_((BlockState)blockState) && !((Boolean)blockState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            return BlockPathTypes.DOOR_WOOD_CLOSED;
        }
        if (block instanceof DoorBlock && material == Material.f_76279_ && !((Boolean)blockState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            return BlockPathTypes.DOOR_IRON_CLOSED;
        }
        if (block instanceof DoorBlock && ((Boolean)blockState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            return BlockPathTypes.DOOR_OPEN;
        }
        if (block instanceof BaseRailBlock) {
            return BlockPathTypes.RAIL;
        }
        if (block instanceof LeavesBlock) {
            return BlockPathTypes.LEAVES;
        }
        if (blockState.m_204336_(BlockTags.f_13039_) || blockState.m_204336_(BlockTags.f_13032_) || block instanceof FenceGateBlock && !((Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
            return BlockPathTypes.FENCE;
        }
        if (!blockState.m_60647_(level, pos, PathComputationType.LAND)) {
            return BlockPathTypes.BLOCKED;
        }
        if (fluidState.m_205070_(FluidTags.f_13131_)) {
            return BlockPathTypes.WATER;
        }
        return BlockPathTypes.OPEN;
    }

    public static boolean isBurningBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13076_) || state.m_60713_(Blocks.f_49991_) || state.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_((BlockState)state) || state.m_60713_(Blocks.f_152477_);
    }

    public void setCanFloat(boolean canSwim) {
        this.canFloat = canSwim;
    }

    public boolean canPassDoors() {
        return this.canPassDoors;
    }

    public boolean canOpenDoors() {
        return this.canOpenDoors;
    }

    public boolean canFloat() {
        return this.canFloat;
    }
}

