/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.rei;

import com.github.teamfossilsarcheology.fossil.compat.rei.MultiOutputDisplay;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class MultiOutputCategory
implements DisplayCategory<MultiOutputDisplay> {
    public int getDisplayHeight() {
        return 106;
    }

    public List<Widget> setupDisplay(MultiOutputDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getMinX(), bounds.getMinY());
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createSlot((Point)new Point(bounds.getCenterX() - 8, startPoint.y + 5)).entries((Collection)display.getInputEntries().get(0)).markInput());
        Rectangle rectangle = new Rectangle(bounds.getCenterX() - bounds.width / 2 + 4, bounds.y + 23, bounds.width - 8, bounds.height - 28);
        widgets.add(Widgets.createSlotBase((Rectangle)rectangle));
        widgets.add(new ScrollableSlotsWidget(rectangle, display.outputs));
        return widgets;
    }

    private static class ScrollableSlotsWidget
    extends WidgetWithBounds {
        private static final float DEFAULT_SPACE = 25.0f;
        private static final DecimalFormat FORMAT = new DecimalFormat("#.#'%'");
        private final Rectangle boundsRect;
        private final Map<Slot, Double> probabilities;
        private final List<Slot> widgets;
        private final ScrollingContainer scrolling = new ScrollingContainer(){
            private boolean draggingScrollBar;

            public Rectangle getBounds() {
                Rectangle bounds = this.getBounds();
                return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            }

            public int getMaxScrollHeight() {
                double numPerRow = Math.floor((float)boundsRect.width / 25.0f);
                return Mth.m_14165_((double)((double)widgets.size() / numPerRow)) * 24 + 4;
            }

            public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy, boolean snapToRows, double rowSize) {
                if (button == 0 && this.draggingScrollBar) {
                    float height = this.getMaxScrollHeight();
                    Rectangle bounds = this.getBounds();
                    int actualHeight = bounds.height;
                    if (mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY()) {
                        double maxScroll = Math.max(1, this.getMaxScroll());
                        double int3 = Mth.m_14008_((double)((double)(actualHeight * actualHeight) / (double)height), (double)32.0, (double)(actualHeight - 8));
                        double double6 = Math.max(1.0, maxScroll / ((double)actualHeight - int3));
                        float to = Mth.m_14036_((float)((float)(this.scrollAmount() + dy * double6)), (float)0.0f, (float)this.getMaxScroll());
                        if (snapToRows) {
                            double nearestRow = (double)Math.round((double)to / rowSize) * rowSize;
                            this.scrollTo(nearestRow, false);
                        } else {
                            this.scrollTo(to, false);
                        }
                    }
                    return true;
                }
                return false;
            }

            public boolean updateDraggingState(double mouseX, double mouseY, int button) {
                double scrollbarPositionMinX;
                if (!this.hasScrollBar()) {
                    return false;
                }
                int height = this.getMaxScroll() + boundsRect.height;
                Rectangle bounds = this.getBounds();
                int actualHeight = bounds.height;
                if (height > actualHeight && mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY() && mouseX >= (scrollbarPositionMinX = (double)this.getScrollBarX(bounds.getMaxX())) - 1.0 && mouseX <= scrollbarPositionMinX + 8.0) {
                    this.draggingScrollBar = true;
                    return true;
                }
                this.draggingScrollBar = false;
                return false;
            }
        };

        public ScrollableSlotsWidget(Rectangle bounds, List<MultiOutputDisplay.WeightedItem> outputs) {
            this.boundsRect = Objects.requireNonNull(bounds);
            this.probabilities = new Object2DoubleOpenHashMap();
            this.widgets = new ArrayList<Slot>();
            for (MultiOutputDisplay.WeightedItem weightedItem : outputs) {
                Slot slot = Widgets.createSlot((Point)new Point(0, 0)).disableBackground().entries((Collection)weightedItem.item()).markOutput();
                this.widgets.add(slot);
                this.probabilities.put(slot, weightedItem.probability());
            }
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            if (this.containsMouse(mouseX, mouseY)) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -delta, true);
                return true;
            }
            return false;
        }

        public Rectangle getBounds() {
            return this.boundsRect;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        private double calcActualSpace(Rectangle innerBounds, double numPerRow) {
            if ((double)this.widgets.size() <= numPerRow) {
                return 25.0;
            }
            return Math.floor((double)innerBounds.width / numPerRow);
        }

        public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
            this.scrolling.updatePosition(delta);
            Rectangle innerBounds = this.scrolling.getScissorBounds();
            try (CloseableScissors ignored = ScrollableSlotsWidget.scissor((PoseStack)poseStack, (Rectangle)innerBounds);){
                double numPerRow = Math.floor((float)innerBounds.width / 25.0f);
                double actualSpace = this.calcActualSpace(innerBounds, numPerRow);
                double xOffset = (actualSpace - 18.0) / 2.0;
                int y = 0;
                while ((double)y < Math.ceil((double)this.widgets.size() / numPerRow)) {
                    int x = 0;
                    while ((double)x < numPerRow) {
                        int index = (int)((double)y * numPerRow + (double)x);
                        if (this.widgets.size() <= index) break;
                        Slot widget = this.widgets.get(index);
                        widget.getBounds().setLocation((double)this.boundsRect.x + xOffset + (double)x * actualSpace, (double)((float)(this.boundsRect.y + 1) + (float)y * 25.0f - (float)this.scrolling.scrollAmountInt()));
                        widget.m_86412_(poseStack, mouseX, mouseY, delta);
                        this.renderProbability(poseStack, Minecraft.m_91087_().f_91062_, this.probabilities.get(widget), widget.getBounds().x, widget.getBounds().y);
                        ++x;
                    }
                    ++y;
                }
            }
            ignored = ScrollableSlotsWidget.scissor((PoseStack)poseStack, (Rectangle)this.scrolling.getBounds());
            try {
                this.renderFixedScrollbar(-16777216, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }

        private void renderProbability(PoseStack poseStack, Font fr, double stack, int xPosition, int yPosition) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 300.0);
            String string = FORMAT.format(stack);
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            float xOffset = Math.min(11.0f, (float)fr.m_92895_(string) / 2.0f);
            fr.m_271703_(string, (float)(xPosition + 8) - xOffset, (float)(yPosition + 16 + 1), 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            bufferSource.m_109911_();
            poseStack.m_85849_();
        }

        private void renderFixedScrollbar(int background, float alpha, float scrollBarAlphaOffset) {
            Rectangle bounds = this.scrolling.getBounds();
            int maxScroll = this.scrolling.getMaxScroll() == 0 ? 1 : this.scrolling.getMaxScroll();
            int height = bounds.height * bounds.height / this.scrolling.getMaxScrollHeight();
            height = Mth.m_14045_((int)height, (int)32, (int)bounds.height);
            height = (int)((double)height - Math.min(this.scrolling.scrollAmount() < 0.0 ? (double)((int)(-this.scrolling.scrollAmount())) : (double)(this.scrolling.scrollAmount() > (double)maxScroll ? (int)this.scrolling.scrollAmount() - maxScroll : 0), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scrolling.scrollAmount() * (bounds.height - height) / maxScroll + bounds.y, bounds.y), bounds.getMaxY() - height);
            int scrollbarPositionMinX = this.scrolling.getScrollBarX(bounds.getMaxX());
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * scrollBarAlphaOffset;
            float topC = (hovered ? 0.87f : 0.67f) * scrollBarAlphaOffset;
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            float a = (float)(background >> 24 & 0xFF) / 255.0f;
            float r = (float)(background >> 16 & 0xFF) / 255.0f;
            float g = (float)(background >> 8 & 0xFF) / 255.0f;
            float b = (float)(background & 0xFF) / 255.0f;
            buffer.m_5483_((double)scrollbarPositionMinX, (double)bounds.getMaxY(), 10.0).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMaxX, (double)bounds.getMaxY(), 10.0).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMaxX, (double)bounds.y, 10.0).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)bounds.y, 10.0).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)(minY + height), 10.0).m_85950_(bottomC, bottomC, bottomC, alpha).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMaxX, (double)(minY + height), 10.0).m_85950_(bottomC, bottomC, bottomC, alpha).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMaxX, (double)minY, 10.0).m_85950_(bottomC, bottomC, bottomC, alpha).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)minY, 10.0).m_85950_(bottomC, bottomC, bottomC, alpha).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)(minY + height - 1), 10.0).m_85950_(topC, topC, topC, alpha).m_5752_();
            buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 10.0).m_85950_(topC, topC, topC, alpha).m_5752_();
            buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)minY, 10.0).m_85950_(topC, topC, topC, alpha).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)minY, 10.0).m_85950_(topC, topC, topC, alpha).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_69461_();
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }
    }
}

