/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.advancements.ModTriggers;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import net.minecraft.Util;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class ThrownBirdEgg
extends ThrowableItemProjectile {
    private EntityInfo info;
    private boolean cultivated;

    public ThrownBirdEgg(EntityType<? extends ThrownBirdEgg> entityType, Level level) {
        super(entityType, level);
    }

    private ThrownBirdEgg(Player player, Level level) {
        super((EntityType)ModEntities.THROWN_BIRD_EGG.get(), (LivingEntity)player, level);
    }

    private ThrownBirdEgg(Level level, double x, double y, double z, boolean cultivated) {
        super((EntityType)ModEntities.THROWN_BIRD_EGG.get(), x, y, z, level);
        this.cultivated = cultivated;
    }

    public static AbstractProjectileDispenseBehavior getProjectile(final EntityInfo info, final boolean cultivated) {
        return new AbstractProjectileDispenseBehavior(){

            @NotNull
            protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.m_137469_((Object)((Object)new ThrownBirdEgg(level, position.m_7096_(), position.m_7098_(), position.m_7094_(), cultivated)), thrownEgg -> {
                    thrownEgg.m_37446_(stack);
                    thrownEgg.setType(info);
                });
            }
        };
    }

    public static ThrownBirdEgg get(Player player, Level level) {
        return new ThrownBirdEgg(player, level);
    }

    public void setType(EntityInfo info) {
        this.info = info;
    }

    public void setCultivated(boolean cultivated) {
        this.cultivated = cultivated;
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        result.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            if (this.cultivated) {
                this.spawnAnimal(1);
            } else if (this.f_19796_.m_188503_(8) == 0) {
                int amount = 1;
                if (this.f_19796_.m_188503_(32) == 0) {
                    amount = 4;
                }
                this.spawnAnimal(amount);
            }
            this.m_146870_();
        } else {
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * 0.08, (this.f_19796_.m_188500_() - 0.5) * 0.08, (this.f_19796_.m_188500_() - 0.5) * 0.08);
            }
        }
    }

    private void spawnAnimal(int amount) {
        if (this.info.mobType() != PrehistoricMobType.VANILLA_BIRD) {
            for (int i = 0; i < amount; ++i) {
                Player nearestPlayer;
                Prehistoric entity = (Prehistoric)this.info.entityType().m_20615_(this.f_19853_);
                entity.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(entity.m_20183_()), MobSpawnType.BREEDING, new Prehistoric.PrehistoricGroupData(0), null);
                entity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                this.f_19853_.m_7967_((Entity)entity);
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity2;
                    ModTriggers.INCUBATE_EGG_TRIGGER.trigger(player, (Entity)entity);
                }
                if ((nearestPlayer = this.f_19853_.m_45930_((Entity)entity, 5.0)) == null) continue;
                entity.m_21828_(nearestPlayer);
            }
        } else {
            for (int i = 0; i < amount; ++i) {
                AgeableMob entity = this.info == VanillaEntityInfo.PARROT ? (AgeableMob)EntityType.f_20508_.m_20615_(this.f_19853_) : (AgeableMob)EntityType.f_20555_.m_20615_(this.f_19853_);
                entity.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.BREEDING, null, null);
                entity.m_146762_(-24000);
                entity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                this.f_19853_.m_7967_((Entity)entity);
            }
        }
    }

    @NotNull
    protected Item m_7881_() {
        return Items.f_42521_;
    }
}

