/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CActivateAttackBoxesMessage;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class DelayedAttackGoal<T extends Prehistoric>
extends Goal {
    protected static final Predicate<Entity> CAN_ATTACK_TARGET = target -> {
        Player player;
        return !(target instanceof Player) || !(player = (Player)target).m_5833_() && !player.m_7500_() && target.f_19853_.m_46791_() != Difficulty.PEACEFUL;
    };
    protected static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    protected final T mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    protected Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    protected long lastCanUseCheck;
    protected long attackEndTick = -1L;
    protected long attackDamageTick = -1L;
    private boolean doingHeavyAttack;

    public DelayedAttackGoal(T mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = ((Prehistoric)this.mob).f_19853_.m_46467_();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        if (((Prehistoric)this.mob).isFleeing() || ((Prehistoric)this.mob).getCurrentOrder() == OrderType.STAY) {
            return false;
        }
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (((Prehistoric)this.mob).f_19853_.m_46791_() == Difficulty.PEACEFUL && target instanceof Player) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
        if (this.path != null) {
            return true;
        }
        return this.isInRange((Entity)target);
    }

    public boolean m_8045_() {
        if (((Prehistoric)this.mob).f_19853_.m_46467_() < this.attackEndTick) {
            return true;
        }
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_() || ((Prehistoric)this.mob).getCurrentOrder() == OrderType.STAY) {
            System.out.println("Cant continue attacking because: " + (target == null));
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(target.m_20183_())) {
            return false;
        }
        return CAN_ATTACK_TARGET.test((Entity)target);
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.attackEndTick = -1L;
        this.attackDamageTick = -1L;
        this.doingHeavyAttack = false;
    }

    public void m_8041_() {
        LivingEntity target = this.mob.m_5448_();
        if (!CAN_ATTACK_TARGET.test((Entity)target)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean canRunAway;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        double dist = this.mob.m_20280_((Entity)target);
        if (this.canUpdateMovement()) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            this.mob.m_21391_((Entity)target, 10.0f, 30.0f);
        } else {
            this.ticksUntilNextPathRecalculation = 15;
        }
        boolean inRange = this.isInRange((Entity)target);
        boolean bl = canRunAway = target instanceof Player || target.m_21214_() != this.mob;
        if ((!inRange || canRunAway && Util.movingAwayFrom((Entity)target, this.mob)) && this.ticksUntilNextPathRecalculation <= 0 && (this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)target))) {
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
            if (dist > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (dist > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
        this.checkAndPerformAttack(target, inRange);
    }

    protected boolean canUpdateMovement() {
        return !this.doingHeavyAttack || ((Prehistoric)this.mob).f_19853_.m_46467_() > this.attackEndTick;
    }

    protected boolean isInRange(Entity attackTarget) {
        return Util.canReachPrey(this.mob, attackTarget);
    }

    protected void checkAndPerformAttack(LivingEntity enemy, boolean inRange) {
        long currentTime = ((Prehistoric)this.mob).f_19853_.m_46467_();
        if (inRange) {
            if (currentTime > this.attackEndTick + 20L) {
                ServerAnimationInfo animationInfo = ((Prehistoric)this.mob).startAttack();
                if (animationInfo.usesAttackBox && enemy instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)enemy;
                    MessageHandler.SYNC_CHANNEL.sendToPlayers(List.of(player), (Object)new S2CActivateAttackBoxesMessage((Entity)this.mob, animationInfo.animation.length()));
                    this.doingHeavyAttack = true;
                } else {
                    this.attackDamageTick = (long)((double)currentTime + animationInfo.actionDelay + 5.0);
                }
                this.attackEndTick = (long)((double)currentTime + animationInfo.animation.length());
                if (this.attackDamageTick > this.attackEndTick) {
                    this.attackDamageTick = this.attackEndTick;
                }
            }
            if (this.attackDamageTick > 0L && currentTime == this.attackDamageTick) {
                ((Prehistoric)this.mob).attackTarget(enemy);
                this.attackDamageTick = -1L;
            }
        }
    }
}

