/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMoodType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Trilobite;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HuntingTargetGoal
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    private final int randomInterval = HuntingTargetGoal.m_186073_((int)10);
    private final Prehistoric dino;
    private final TargetingConditions huntTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(this::canTarget);
    @Nullable
    private LivingEntity target;

    public HuntingTargetGoal(Prehistoric prehistoric) {
        super((Mob)prehistoric, true, true);
        this.dino = prehistoric;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.target);
        this.dino.moodSystem.setToyTarget(null);
        super.m_8056_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.target = null;
    }

    public boolean m_8036_() {
        if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0 || this.dino.m_6107_()) {
            return false;
        }
        if (this.dino.isHungry() && !this.dino.m_6162_()) {
            this.target = this.findHuntingTarget();
            return this.target != null;
        }
        return false;
    }

    private boolean canTargetHumanoid(LivingEntity entity) {
        if (this.dino.moodSystem.getMoodFace() == PrehistoricMoodType.HAPPY || this.dino.moodSystem.getMoodFace() == PrehistoricMoodType.CONTENT) {
            return false;
        }
        if (this.dino.moodSystem.getMoodFace() == PrehistoricMoodType.ANGRY || this.dino.moodSystem.getMoodFace() == PrehistoricMoodType.SAD) {
            return true;
        }
        return FoodMappings.getMobFoodPoints(entity, this.dino.data().diet()) > 0 && this.dino.m_20205_() * this.dino.getTargetScale() >= entity.m_20205_();
    }

    private boolean canTargetPlayer(Player player) {
        if (player.m_7500_()) {
            return false;
        }
        return this.canTargetHumanoid((LivingEntity)player);
    }

    public boolean m_8045_() {
        if (!super.m_8045_()) {
            return false;
        }
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return !player.m_7500_() && this.canTargetPlayer(player);
        }
        return true;
    }

    private boolean canTarget(LivingEntity target) {
        BlockPos pos;
        if (this.dino.aiResponseType() == PrehistoricEntityInfoAI.Response.SCARED) {
            return false;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            return this.canTargetPlayer(player);
        }
        if (target instanceof Villager) {
            return this.canTargetHumanoid(target);
        }
        if (this.dino instanceof Trilobite && target instanceof Trilobite) {
            return false;
        }
        boolean canTarget = true;
        Prehistoric prehistoric = this.dino;
        if (prehistoric instanceof PrehistoricSwimming) {
            PrehistoricSwimming swimming = (PrehistoricSwimming)prehistoric;
            if (!target.m_20069_() && !swimming.canHuntMobsOnLand()) {
                canTarget = false;
            }
        }
        if (target.m_20069_() && this.dino.aiMovingType() != PrehistoricEntityInfoAI.Moving.AQUATIC && this.dino.aiMovingType() != PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC && !this.dino.f_19853_.m_6425_(pos = BlockPos.m_274561_((double)target.m_20185_(), (double)target.m_20191_().f_82292_, (double)target.m_20189_())).m_76178_() && !this.dino.f_19853_.m_6425_(pos.m_7494_()).m_76178_()) {
            canTarget = false;
        }
        boolean isFood = FoodMappings.getMobFoodPoints(target, this.dino.data().diet()) > 0;
        boolean smallEnough = this.dino.m_20191_().m_82309_() * (double)this.dino.getTargetScale() >= target.m_20191_().m_82309_();
        return canTarget && isFood && smallEnough && !target.getClass().equals(this.dino.getClass());
    }

    private LivingEntity findHuntingTarget() {
        return this.f_26135_.f_19853_.m_45963_(LivingEntity.class, this.huntTargetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_(), this.getTargetSearchArea(this.m_7623_()));
    }

    @NotNull
    private AABB getTargetSearchArea(double targetDistance) {
        double yDist = 4.0;
        if (this.dino instanceof PrehistoricFlying || this.dino instanceof PrehistoricSwimming) {
            yDist = targetDistance;
        }
        return this.f_26135_.m_20191_().m_82377_(targetDistance, yDist, targetDistance);
    }
}

