/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimationController;

public class PausableAnimationController<T extends GeoEntity>
extends AnimationController<T> {
    private boolean paused;
    private double lastTick;

    public PausableAnimationController(T animatable, String name, int transitionTickTime, AnimationController.AnimationStateHandler<T> animationHandler) {
        super(animatable, name, transitionTickTime, animationHandler);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause(boolean paused) {
        this.paused = paused;
    }

    public double getCurrentTick() {
        if (this.getCurrentAnimation() != null) {
            return this.lastTick % this.getCurrentAnimation().animation().length();
        }
        return this.lastTick;
    }

    public void overrideTick(double tick) {
        this.lastTick = tick;
    }

    protected double adjustTick(double tick) {
        if (!this.paused) {
            this.lastTick = super.adjustTick(tick);
        }
        return this.lastTick;
    }

    public void setAnimationSpeed(double animationSpeed, double animationTick) {
        if (animationSpeed == 0.0) {
            return;
        }
        if (animationSpeed != this.getAnimationSpeed() && this.getCurrentAnimation() != null) {
            double timeInAnim = animationTick - this.tickOffset;
            double mult = this.getAnimationSpeed() / animationSpeed;
            this.tickOffset = animationTick - timeInAnim * mult;
            this.setAnimationSpeed(animationSpeed);
        }
    }
}

