/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.data;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.data.AI;
import com.github.teamfossilsarcheology.fossil.entity.data.Attribute;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class EntityDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Attribute.class, (Object)new Attribute.Deserializer()).registerTypeAdapter(AI.class, (Object)new AI.Deserializer()).registerTypeAdapter(Diet.class, (Object)new Diet.Deserializer()).registerTypeAdapter(Data.class, (Object)new Data.Deserializer()).disableHtmlEscaping().create();
    public static final EntityDataLoader INSTANCE = new EntityDataLoader(GSON);
    private ImmutableMap<String, Data> entities = ImmutableMap.of();

    public EntityDataLoader(Gson gson) {
        super(gson, "entity_info");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> fileEntry : jsons.entrySet()) {
            JsonElement jsonElement = fileEntry.getValue();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject root = (JsonObject)jsonElement;
            if (!fileEntry.getKey().m_135827_().equals("fossil")) continue;
            builder.put((Object)fileEntry.getKey().m_135815_(), (Object)((Data)GSON.fromJson((JsonElement)root, Data.class)));
        }
        this.entities = builder.build();
        FossilMod.LOGGER.info("Loaded data for {} entities", (Object)this.entities.size());
    }

    public Data getData(String entityName) {
        return (Data)this.entities.get((Object)entityName);
    }

    public ImmutableMap<String, Data> getEntities() {
        return this.entities;
    }

    public void replaceData(Map<String, Data> dataMap) {
        this.entities = ImmutableMap.copyOf(dataMap);
        FossilMod.LOGGER.info("Replacing client data for {} entities", (Object)this.entities.size());
    }

    public record Data(Attribute attributes, AI ai, Diet diet, float eggScale, float minScale, float maxScale, int teenAgeDays, int adultAgeDays, int maxHunger, int maxPopulation, boolean canBeRidden, boolean breaksBlocks) {
        public static Data readBuf(FriendlyByteBuf buf) {
            return new Data(Attribute.readBuf(buf), AI.readBuf(buf), Diet.readBuf(buf), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readBoolean());
        }

        public static void writeBuf(FriendlyByteBuf buf, Data data) {
            Attribute.writeBuf(buf, data.attributes);
            AI.writeBuf(buf, data.ai);
            Diet.writeBuf(buf, data.diet);
            buf.writeFloat(data.eggScale).writeFloat(data.minScale).writeFloat(data.maxScale).writeInt(data.teenAgeDays).writeInt(data.adultAgeDays).writeInt(data.maxHunger).writeInt(data.maxPopulation).writeBoolean(data.canBeRidden).writeBoolean(data.breaksBlocks);
        }

        public int adultAgeInTicks() {
            return this.adultAgeDays * 24000;
        }

        public static class Deserializer
        implements JsonDeserializer<Data> {
            public Data deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject root = json.getAsJsonObject();
                Attribute attribute = (Attribute)GSON.getAdapter(Attribute.class).fromJsonTree((JsonElement)root.getAsJsonObject("attributes"));
                AI ai = (AI)GSON.getAdapter(AI.class).fromJsonTree((JsonElement)root.getAsJsonObject("ai"));
                Diet diet = (Diet)GSON.fromJson((JsonElement)root, Diet.class);
                float eggScale = GsonHelper.m_13820_((JsonObject)root, (String)"eggScale", (float)1.0f);
                float minScale = root.get("scaleBase").getAsFloat();
                float maxScale = root.get("scaleMax").getAsFloat();
                int teenAgeDays = root.get("teenAgeDays").getAsInt();
                int adultAgeDays = root.get("adultAgeDays").getAsInt();
                int maxHunger = root.get("maxHunger").getAsInt();
                int maxPopulation = GsonHelper.m_13824_((JsonObject)root, (String)"maxPopulation", (int)15);
                boolean canBeRidden = GsonHelper.m_13855_((JsonObject)root, (String)"canBeRidden", (boolean)false);
                boolean breaksBlocks = GsonHelper.m_13855_((JsonObject)root, (String)"breaksBlocks", (boolean)false);
                return new Data(attribute, ai, diet, eggScale, minScale, maxScale, teenAgeDays, adultAgeDays, maxHunger, maxPopulation, canBeRidden, breaksBlocks);
            }
        }
    }
}

