/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FriendlyPiglin
extends TamableAnimal {
    public static final Component KILLED = Component.m_237115_((String)"entity.fossil.friendly_piglin.kill");
    public static final Component SUMMONED = Component.m_237115_((String)"entity.fossil.friendly_piglin.summon");

    public FriendlyPiglin(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 5.0).m_22266_(Attributes.f_22276_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21824_() ? 25.0 : 20.0);
        this.m_213945_(level.m_213780_(), difficulty);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8107_() {
        this.m_21203_();
        if (this.m_213856_() > 0.5f) {
            this.f_20891_ += 2;
        }
        super.m_8107_();
    }

    public boolean m_214076_(ServerLevel level, LivingEntity killedEntity) {
        boolean bl = super.m_214076_(level, killedEntity);
        if (bl) {
            this.sendMessageToOwner(KILLED);
        }
        return bl;
    }

    public void sendMessageToOwner(Component component) {
        if (this.m_269323_() instanceof Player) {
            ((Player)this.m_269323_()).m_5661_(component, false);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity trueSource = source.m_7639_();
        if (!this.f_19853_.f_46443_) {
            this.m_21839_(false);
        }
        if (trueSource != null && !(trueSource instanceof Player) && !(trueSource instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity target) {
        boolean hurtTarget = super.m_7327_(target);
        if (hurtTarget) {
            float f = this.f_19853_.m_6436_(this.m_20183_()).m_19056_();
            if (this.m_21120_(this.m_21526_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND).m_41619_() && this.m_6060_() && this.f_19796_.m_188501_() < f * 0.3f) {
                target.m_20254_(2 * (int)f);
            }
            this.m_6674_(this.m_21526_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        }
        return hurtTarget;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof Creeper || target instanceof Ghast) {
            return false;
        }
        if (target instanceof Wolf) {
            Wolf wolf = (Wolf)target;
            return !wolf.m_21824_() || wolf.m_269323_() != owner;
        }
        if (target instanceof FriendlyPiglin) {
            FriendlyPiglin piglin = (FriendlyPiglin)target;
            return !piglin.m_21824_() || piglin.m_269323_() != owner;
        }
        if (target instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)target;
            return horse.m_30614_();
        }
        if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12610_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12613_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12612_;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.f_19853_.f_46443_) {
            return this.m_21830_((LivingEntity)player) || this.m_21824_() ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_150930_(Items.f_42587_) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(player, hand, stack);
                this.m_5634_(2.0f);
                this.m_146852_(GameEvent.f_223708_, (Entity)player);
                return InteractionResult.SUCCESS;
            }
            if (this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return null;
    }
}

