/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.ai.control.PrehistoricLookControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.LeapSystem;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public abstract class PrehistoricLeaping
extends Prehistoric {
    public static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(PrehistoricLeaping.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LEAP_STARTED = SynchedEntityData.m_135353_(PrehistoricLeaping.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LEAP_FLYING = SynchedEntityData.m_135353_(PrehistoricLeaping.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> LEAP_TARGET_ID = SynchedEntityData.m_135353_(PrehistoricLeaping.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> LEAP_RIDING = SynchedEntityData.m_135353_(PrehistoricLeaping.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LEAP_LANDING = SynchedEntityData.m_135353_(PrehistoricLeaping.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LANDING = SynchedEntityData.m_135353_(PrehistoricLeaping.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final LeapSystem leapSystem = this.registerSystem(new LeapSystem(this));

    protected PrehistoricLeaping(EntityType<? extends PrehistoricLeaping> entityType, Level level, boolean canAttach) {
        super(entityType, level);
        this.f_21342_ = new LeapMoveControl();
        this.f_21365_ = new LeapLookControl();
    }

    @Override
    protected void m_8022_() {
        boolean bl = !this.leapSystem.isLeaping() && !this.m_5803_();
        this.f_21345_.m_25360_(Goal.Flag.MOVE, bl && !this.sitSystem.isSitting());
        this.f_21345_.m_25360_(Goal.Flag.JUMP, bl && !this.sitSystem.isSitting());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, bl);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LEAPING, (Object)false);
        this.f_19804_.m_135372_(LEAP_STARTED, (Object)false);
        this.f_19804_.m_135372_(LEAP_RIDING, (Object)false);
        this.f_19804_.m_135372_(LEAP_FLYING, (Object)false);
        this.f_19804_.m_135372_(LEAP_LANDING, (Object)false);
        this.f_19804_.m_135372_(LEAP_TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(LANDING, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        if (LEAP_RIDING.equals(key)) {
            if (((Boolean)this.f_19804_.m_135370_(LEAP_RIDING)).booleanValue() && (Integer)this.f_19804_.m_135370_(LEAP_TARGET_ID) >= 0) {
                this.m_7998_(Objects.requireNonNull(this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(LEAP_TARGET_ID)).intValue())), true);
            } else {
                this.m_8127_();
            }
        }
        super.m_7350_(key);
    }

    public double m_6049_() {
        return -0.025;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (hurt && this.leapSystem.isAttackRiding() && this.m_21188_() != null && this.m_21188_() == this.m_20202_() && this.f_19796_.m_188503_(2) == 0) {
            this.getLeapSystem().stopAttackRiding();
            this.m_8127_();
        }
        return hurt;
    }

    @Override
    protected boolean canClimb() {
        return !this.getLeapSystem().isLeaping() && super.canClimb();
    }

    public LeapSystem getLeapSystem() {
        return this.leapSystem;
    }

    public void startLeap(Entity target) {
        this.leapSystem.setLeapStarted(true);
        this.f_19804_.m_135381_(LEAP_TARGET_ID, (Object)target.m_19879_());
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (this.getLeapSystem().isLeapingAt(entity)) {
            this.getLeapSystem().tryAttackRiding(entity);
        }
    }

    @NotNull
    public AnimationInfo getLeapStartAnimation() {
        return this.getAllAnimations().get(this.getLeapStartAnimationName());
    }

    @NotNull
    public AnimationInfo getLandAnimation() {
        return this.getAllAnimations().get(this.getLandAnimationName());
    }

    @NotNull
    public AnimationInfo getLeapAttackAnimation() {
        return this.getAllAnimations().get(this.getLeapAttackAnimationName());
    }

    public abstract String getLandAnimationName();

    public abstract String getLeapStartAnimationName();

    public abstract String getLeapAttackAnimationName();

    public boolean hasLeapAnimation() {
        return true;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        PausableAnimationController<PrehistoricLeaping> controller = new PausableAnimationController<PrehistoricLeaping>(this, "Movement/Idle", 5, this.getAnimationLogic()::leapingPredicate);
        this.registerEatingListeners(controller, effect -> {
            BlockState below;
            if ("land".equals(effect) && this.m_20096_() && (below = this.f_19853_.m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 0.2), (double)this.m_20189_()))).m_60799_() != RenderShape.INVISIBLE) {
                Vec3 vec3 = this.m_20184_();
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, below), this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() / 2.0, this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() / 2.0, vec3.f_82479_ * 4.0, 1.0, vec3.f_82481_ * 4.0);
            }
        });
        this.registerControllerWithTriggers(controllerRegistrar, controller);
        PausableAnimationController<PrehistoricLeaping> attackController = new PausableAnimationController<PrehistoricLeaping>(this, "Attack", 5, this.getAnimationLogic()::attackPredicate);
        this.registerControllerWithTriggers(controllerRegistrar, attackController);
    }

    class LeapMoveControl
    extends SmoothTurningMoveControl {
        public LeapMoveControl() {
            super(PrehistoricLeaping.this);
        }

        @Override
        public void m_8126_() {
            if (!PrehistoricLeaping.this.getLeapSystem().isLeaping()) {
                super.m_8126_();
            }
        }
    }

    class LeapLookControl
    extends PrehistoricLookControl {
        public LeapLookControl() {
            super(PrehistoricLeaping.this);
        }

        @Override
        public void m_8128_() {
            if (!PrehistoricLeaping.this.getLeapSystem().isLeaping()) {
                super.m_8128_();
            }
        }
    }
}

