/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.TrilobitePathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimmingBucketable;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class Trilobite
extends PrehistoricSwimmingBucketable {
    protected Trilobite(EntityType<? extends Trilobite> entityType, Level level) {
        super(entityType, level, FossilMod.location("animations/entity/trilobite.animation.json"));
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new TrilobiteMoveControl();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new DinoOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinoOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new DinoHurtByTargetGoal(this));
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new TrilobitePathNavigation((Mob)this, level);
    }

    @Override
    public boolean m_6147_() {
        return this.f_19862_ && this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13131_);
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        super.m_7023_(travelVector);
        if (this.m_6147_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.005, 0.0));
        } else if (this.f_19853_.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
        }
    }

    @Override
    public void refreshTexturePath() {
    }

    @Override
    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public Item getOrderItem() {
        return (Item)ModItems.MAGIC_CONCH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.ARTHROPLEURA_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ARTHROPLEURA_DEATH.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        PausableAnimationController<Trilobite> ctrl = new PausableAnimationController<Trilobite>(this, "Movement/Idle", 5, state -> {
            AnimationController controller = state.getController();
            if (this.getAnimationLogic().tryNextAnimation(state, controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = this.getAnimationLogic().getActiveAnimation(controller.getName());
            if (activeAnimation.isPresent() && this.getAnimationLogic().tryForcedAnimation(state, activeAnimation.get())) {
                return PlayState.CONTINUE;
            }
            if (state.isMoving()) {
                this.getAnimationLogic().addActiveAnimation(controller.getName(), AnimationCategory.WALK);
            } else {
                this.getAnimationLogic().addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
            }
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = this.getAnimationLogic().getActiveAnimation(controller.getName());
            newAnimation.ifPresent(activeAnimationInfo -> controller.setAnimation(RawAnimation.begin().then(activeAnimationInfo.animationName(), activeAnimationInfo.loop() ? Animation.LoopType.LOOP : Animation.LoopType.PLAY_ONCE)));
            return PlayState.CONTINUE;
        });
        this.registerEatingListeners(ctrl);
        controllerRegistrar.add(new AnimationController[]{ctrl});
    }

    class TrilobiteMoveControl
    extends MoveControl {
        public TrilobiteMoveControl() {
            super((Mob)Trilobite.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                double d = this.f_24975_ - this.f_24974_.m_20185_();
                double e = this.f_24977_ - this.f_24974_.m_20189_();
                double o = this.f_24976_ - this.f_24974_.m_20186_();
                double p = d * d + o * o + e * e;
                if (p < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                float n = (float)(Mth.m_14136_((double)e, (double)d) * 180.0 / 3.1415927410125732) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), n, 90.0f));
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) * 0.4f);
            } else {
                this.f_24974_.m_21564_(0.0f);
            }
        }
    }
}

