/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class FossilFoodMappings {
    public static void register() {
        FoodMappingsManager.INSTANCE.listen(manager -> {
            BuiltInRegistries.f_256975_.m_203561_(BlockTags.f_13035_).m_203614_().map(Holder::m_203334_).forEach(block -> manager.addPlant((Block)block, 20));
            BuiltInRegistries.f_256975_.m_203561_(BlockTags.f_13041_).m_203614_().map(Holder::m_203334_).forEach(block -> manager.addPlant((Block)block, 5));
            BuiltInRegistries.f_256975_.m_203561_(BlockTags.f_13104_).m_203614_().map(Holder::m_203334_).forEach(block -> manager.addPlant((Block)block, 15));
            for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
                if (prehistoricEntityInfo.mobType == PrehistoricMobType.FISH) {
                    if (prehistoricEntityInfo.eggItem != null) {
                        manager.addFish(prehistoricEntityInfo.eggItem, 20);
                    }
                    if (prehistoricEntityInfo.foodItem != null) {
                        manager.addFish(prehistoricEntityInfo.foodItem);
                    }
                    if (prehistoricEntityInfo.cookedFoodItem != null) {
                        manager.addFish(prehistoricEntityInfo.cookedFoodItem);
                    }
                } else {
                    if (prehistoricEntityInfo.foodItem != null) {
                        manager.addMeat((ItemLike)prehistoricEntityInfo.foodItem);
                    }
                    if (prehistoricEntityInfo.cookedFoodItem != null) {
                        manager.addMeat((ItemLike)prehistoricEntityInfo.cookedFoodItem);
                    }
                }
                if (prehistoricEntityInfo.mobType != PrehistoricMobType.BIRD) continue;
                manager.addEgg(prehistoricEntityInfo.cultivatedBirdEggItem, 15);
                manager.addEgg(prehistoricEntityInfo.birdEggItem, 10);
            }
            for (Enum enum_ : VanillaEntityInfo.values()) {
                if (((VanillaEntityInfo)enum_).mobType != PrehistoricMobType.VANILLA_BIRD) continue;
                manager.addEgg(((VanillaEntityInfo)enum_).cultivatedBirdEggItem, 15);
            }
        });
    }
}

