/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.util;

import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.AlexDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.ArgentinaDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.BrewinAndChewinCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.ButcherDelightFoodCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.CasualnessDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.CoffeeDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.CornDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.CrabberDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.CulturalDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.DelightfulCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.EndDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.EnderDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.FarmerRespiteCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.FestiveDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.ItalianDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.MinerDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.NetherDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.OceanDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.PineappleDelightCompat;
import com.github.teamfossilsarcheology.fossil.forge.compat.farmers.addon.SeedDelightCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.fml.ModList;

public class AddonConstants {
    private static final Map<String, Consumer<FoodMappingsManager>> SUPPORTED_ADDONS = new HashMap<String, Consumer<FoodMappingsManager>>();

    public static void registerAddonFoodMappings(FoodMappingsManager manager) {
        for (Map.Entry<String, Consumer<FoodMappingsManager>> entry : SUPPORTED_ADDONS.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            entry.getValue().accept(manager);
        }
    }

    private static void register(String modId, Consumer<FoodMappingsManager> function) {
        SUPPORTED_ADDONS.put(modId, function);
    }

    static {
        AddonConstants.register("alexsdelight", AlexDelightCompat::registerFoodMappings);
        AddonConstants.register("argentinas_delight", ArgentinaDelightCompat::registerFoodMappings);
        AddonConstants.register("brewinandchewin", BrewinAndChewinCompat::registerFoodMappings);
        AddonConstants.register("butchersdelightfoods", ButcherDelightFoodCompat::registerFoodMappings);
        AddonConstants.register("casualness_delight", CasualnessDelightCompat::registerFoodMappings);
        AddonConstants.register("coffee_delight", CoffeeDelightCompat::registerFoodMappings);
        AddonConstants.register("corn_delight", CornDelightCompat::registerFoodMappings);
        AddonConstants.register("culturaldelights", CulturalDelightCompat::registerFoodMappings);
        AddonConstants.register("crabbersdelight", CrabberDelightCompat::registerFoodMappings);
        AddonConstants.register("delightful", DelightfulCompat::registerFoodMappings);
        AddonConstants.register("endersdelight", EnderDelightCompat::registerFoodMappings);
        AddonConstants.register("ends_delight", EndDelightCompat::registerFoodMappings);
        AddonConstants.register("farmersrespite", FarmerRespiteCompat::registerFoodMappings);
        AddonConstants.register("festive_delight", FestiveDelightCompat::registerFoodMappings);
        AddonConstants.register("italian_delight", ItalianDelightCompat::registerFoodMappings);
        AddonConstants.register("miners_delight", MinerDelightCompat::registerFoodMappings);
        AddonConstants.register("nethersdelight", NetherDelightCompat::registerFoodMappings);
        AddonConstants.register("oceansdelight", OceanDelightCompat::registerFoodMappings);
        AddonConstants.register("pineapple_delight", PineappleDelightCompat::registerFoodMappings);
        AddonConstants.register("seeddelight", SeedDelightCompat::registerFoodMappings);
    }
}

