/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.item;

import com.github.teamfossilsarcheology.fossil.entity.Javelin;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class JavelinItem
extends TieredItem {
    private final boolean ancient;

    public JavelinItem(Tier tier, boolean ancient) {
        super(tier, new JavelinProperties().stacksToWithDurability(16, 30).arch$tab(ModTabs.FA_OTHER_ITEM_TAB));
        this.ancient = ancient;
    }

    public JavelinItem(Tier tier) {
        this(tier, false);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity shooter, int timeCharged) {
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        boolean infiniteAmmo = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
        int i = this.m_8105_(stack) - timeCharged;
        float speed = BowItem.m_40661_((int)i);
        if ((double)speed < 0.1) {
            return;
        }
        if (!level.f_46443_) {
            int flameLevel;
            int punchLevel;
            int powerLevel;
            int damage = stack.m_41776_() - (stack.m_41773_() + (player.m_150110_().f_35937_ ? 0 : 1));
            Javelin javelin = new Javelin(level, shooter, this.m_43314_(), this.ancient, damage);
            javelin.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed * 3.0f, 1.0f);
            if (speed == 1.0f) {
                javelin.m_36762_(true);
            }
            if ((powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                javelin.m_36781_(javelin.m_36789_() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                javelin.m_36735_(punchLevel);
            }
            if ((flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack)) > 0) {
                javelin.m_20254_(100);
            }
            if (infiniteAmmo) {
                javelin.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.m_7967_((Entity)javelin);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.4f + 1.2f) + speed * 0.5f);
        if (!infiniteAmmo) {
            stack.m_41774_(1);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public int m_6473_() {
        return 0;
    }

    public static class JavelinProperties
    extends Item.Properties {
        public JavelinProperties stacksToWithDurability(int maxStackSize, int durability) {
            this.m_41503_(durability);
            this.f_41478_ = maxStackSize;
            return this;
        }
    }
}

