/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.item;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.item.AncientHelmetItem;
import com.github.teamfossilsarcheology.fossil.item.AncientSwordItem;
import com.github.teamfossilsarcheology.fossil.item.ArtificialHoneycombItem;
import com.github.teamfossilsarcheology.fossil.item.CustomRecordItem;
import com.github.teamfossilsarcheology.fossil.item.DescriptiveItem;
import com.github.teamfossilsarcheology.fossil.item.FoodBucketItem;
import com.github.teamfossilsarcheology.fossil.item.FossilItem;
import com.github.teamfossilsarcheology.fossil.item.JavelinItem;
import com.github.teamfossilsarcheology.fossil.item.LaserPointerItem;
import com.github.teamfossilsarcheology.fossil.item.ModArmorMaterials;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import com.github.teamfossilsarcheology.fossil.item.ModToolTiers;
import com.github.teamfossilsarcheology.fossil.item.StoneTabletItem;
import com.github.teamfossilsarcheology.fossil.item.ToyBallItem;
import com.github.teamfossilsarcheology.fossil.item.ToyScratchingPostItem;
import com.github.teamfossilsarcheology.fossil.item.ToyTetheredLogItem;
import com.github.teamfossilsarcheology.fossil.item.WhipItem;
import com.github.teamfossilsarcheology.fossil.material.ModFluids;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.TimePeriod;
import dev.architectury.core.item.ArchitecturyBucketItem;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"fossil", (ResourceKey)Registries.f_256913_);
    public static final RegistrySupplier<Item> LASER_POINTER = ITEMS.register("laser_pointer", () -> new LaserPointerItem(new Item.Properties().m_41487_(1).arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> TAR_BUCKET = ITEMS.register("tar_bucket", () -> new ArchitecturyBucketItem(ModFluids.TAR, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_).arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> TAR_DROP = ITEMS.register("tar_drop", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<RecordItem> MUSIC_DISC_BONES = ITEMS.register("music_disc_bones", () -> CustomRecordItem.get(0, ModSounds.MUSIC_BONES, new Item.Properties().m_41487_(1).arch$tab(ModTabs.FA_OTHER_ITEM_TAB).m_41497_(Rarity.RARE), 196));
    public static final RegistrySupplier<RecordItem> MUSIC_DISC_ANU = ITEMS.register("music_disc_anu", () -> CustomRecordItem.get(1, ModSounds.MUSIC_ANU, new Item.Properties().m_41487_(1).arch$tab(ModTabs.FA_OTHER_ITEM_TAB).m_41497_(Rarity.RARE), 221));
    public static final RegistrySupplier<RecordItem> MUSIC_DISC_SCARAB = ITEMS.register("music_disc_scarab", () -> CustomRecordItem.get(2, ModSounds.MUSIC_SCARAB, new Item.Properties().m_41487_(1).arch$tab(ModTabs.FA_OTHER_ITEM_TAB).m_41497_(Rarity.RARE), 153));
    public static final RegistrySupplier<RecordItem> MUSIC_DISC_DISCOVERY = ITEMS.register("music_disc_discovery", () -> CustomRecordItem.get(3, ModSounds.MUSIC_DISCOVERY, new Item.Properties().m_41487_(1).arch$tab(ModTabs.FA_OTHER_ITEM_TAB).m_41497_(Rarity.RARE), 250));
    public static final RegistrySupplier<Item> BIO_FOSSIL = ITEMS.register("fossil_bio", () -> new FossilItem(TimePeriod.MESOZOIC));
    public static final RegistrySupplier<Item> PlANT_FOSSIL = ITEMS.register("fossil_plant", () -> new FossilItem(null));
    public static final RegistrySupplier<Item> SHALE_FOSSIL = ITEMS.register("fossil_shale", () -> new FossilItem(TimePeriod.PALEOZOIC));
    public static final RegistrySupplier<Item> TAR_FOSSIL = ITEMS.register("fossil_tar", () -> new FossilItem(TimePeriod.CENOZOIC));
    public static final RegistrySupplier<Item> RELIC_SCRAP = ITEMS.register("relic_scrap", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> STONE_TABLET = ITEMS.register("stone_tablet", () -> new StoneTabletItem(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> SKULL_STICK = ITEMS.register("skull_stick", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> BROKEN_SWORD = ITEMS.register("broken_sword", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> BROKEN_HELMET = ITEMS.register("broken_helmet", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> ANCIENT_SWORD = ITEMS.register("ancient_sword", () -> new AncientSwordItem((Tier)Tiers.IRON, 3, -2.4f));
    public static final RegistrySupplier<Item> ANCIENT_HELMET = ITEMS.register("ancient_helmet", () -> AncientHelmetItem.get(ModArmorMaterials.ANCIENT, ArmorItem.Type.HELMET, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> FROZEN_MEAT = ITEMS.register("frozen_meat", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> TOOTH_DAGGER = ITEMS.register("tooth_dagger", () -> new SwordItem((Tier)ModToolTiers.TOOTH_DAGGER, 3, -2.4f, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<JavelinItem> WOODEN_JAVELIN = ITEMS.register("wooden_javelin", () -> new JavelinItem((Tier)Tiers.WOOD));
    public static final RegistrySupplier<JavelinItem> STONE_JAVELIN = ITEMS.register("stone_javelin", () -> new JavelinItem((Tier)Tiers.STONE));
    public static final RegistrySupplier<JavelinItem> GOLD_JAVELIN = ITEMS.register("gold_javelin", () -> new JavelinItem((Tier)Tiers.GOLD));
    public static final RegistrySupplier<JavelinItem> IRON_JAVELIN = ITEMS.register("iron_javelin", () -> new JavelinItem((Tier)Tiers.IRON));
    public static final RegistrySupplier<JavelinItem> DIAMOND_JAVELIN = ITEMS.register("diamond_javelin", () -> new JavelinItem((Tier)Tiers.DIAMOND));
    public static final RegistrySupplier<JavelinItem> ANCIENT_JAVELIN = ITEMS.register("ancient_javelin", () -> new JavelinItem((Tier)Tiers.WOOD, true));
    public static final RegistrySupplier<SwordItem> SCARAB_SWORD = ITEMS.register("scarab_sword", () -> new SwordItem((Tier)ModToolTiers.SCARAB, 3, -2.4f, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<PickaxeItem> SCARAB_PICKAXE = ITEMS.register("scarab_pickaxe", () -> new PickaxeItem((Tier)ModToolTiers.SCARAB, 1, -2.8f, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<AxeItem> SCARAB_AXE = ITEMS.register("scarab_axe", () -> new AxeItem((Tier)ModToolTiers.SCARAB, 4.0f, -3.0f, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<ShovelItem> SCARAB_SHOVEL = ITEMS.register("scarab_shovel", () -> new ShovelItem((Tier)ModToolTiers.SCARAB, 1.5f, -3.0f, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<HoeItem> SCARAB_HOE = ITEMS.register("scarab_hoe", () -> new HoeItem((Tier)ModToolTiers.SCARAB, -2, -1.0f, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> BONE_HELMET = ITEMS.register("bone_helmet", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.BONE, ArmorItem.Type.HELMET, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> BONE_CHESTPLATE = ITEMS.register("bone_chestplate", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.BONE, ArmorItem.Type.CHESTPLATE, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> BONE_LEGGINGS = ITEMS.register("bone_leggings", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.BONE, ArmorItem.Type.LEGGINGS, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> BONE_BOOTS = ITEMS.register("bone_boots", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.BONE, ArmorItem.Type.BOOTS, new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> WHIP = ITEMS.register("whip", WhipItem::new);
    public static final RegistrySupplier<Item> CHICKEN_ESSENCE = ITEMS.register("essence_chicken", () -> new DescriptiveItem(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> STUNTED_ESSENCE = ITEMS.register("essence_stunted", () -> new DescriptiveItem(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> POTTERY_SHARD = ITEMS.register("pottery_shard", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> BIO_GOO = ITEMS.register("bio_goo", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> SCARAB_GEM = ITEMS.register("scarab_gem", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> AQUATIC_SCARAB_GEM = ITEMS.register("scarab_gem_aquatic", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> ANCIENT_KEY = ITEMS.register("ancient_key", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> ANCIENT_CLOCK = ITEMS.register("ancient_clock", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> DINOPEDIA = ITEMS.register("dinopedia", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB)));
    public static final RegistrySupplier<Item> ELASMOTHERIUM_FUR = ITEMS.register("fur_elasmotherium", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> MAMMOTH_FUR = ITEMS.register("fur_mammoth", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> THERIZINOSAURUS_DOWN = ITEMS.register("fur_therizinosaurus", () -> new Item(new Item.Properties()));
    public static final RegistrySupplier<Item> FAILURESAURUS_FLESH = ITEMS.register("failuresaurus_flesh", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> MAGIC_CONCH = ITEMS.register("magic_conch", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> RAW_CHICKEN_SOUP = ITEMS.register("chicken_soup_raw", () -> new FoodBucketItem(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB).m_41495_(Items.f_42446_).m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(2.0f).m_38767_())));
    public static final RegistrySupplier<Item> COOKED_CHICKEN_SOUP = ITEMS.register("chicken_soup_cooked", () -> new FoodBucketItem(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB).m_41495_(Items.f_42446_).m_41489_(new FoodProperties.Builder().m_38760_(8).m_38758_(2.0f).m_38767_())));
    public static final RegistrySupplier<Item> COOKED_EGG = ITEMS.register("cooked_egg", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB).m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(2.0f).m_38767_())));
    public static final RegistrySupplier<Item> ARTIFICIAL_HONEYCOMB = ITEMS.register("artificial_honeycomb", () -> new ArtificialHoneycombItem(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> FERN_SEED_FOSSIL = ITEMS.register("fossil_seed_fern", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> FERN_SEED = ITEMS.register("fern_seed", () -> new ItemNameBlockItem((Block)ModBlocks.FERNS.get(), new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> CALAMITES_FOSSIL_SAPLING = ITEMS.register("fossil_sapling_calamites", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> CORDAITES_FOSSIL_SAPLING = ITEMS.register("fossil_sapling_cordaites", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> PALM_FOSSIL_SAPLING = ITEMS.register("fossil_sapling_palm", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> SIGILLARIA_FOSSIL_SAPLING = ITEMS.register("fossil_sapling_sigillaria", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<Item> TEMPSKYA_FOSSIL_SAPLING = ITEMS.register("fossil_sapling_tempskya", () -> new Item(new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    public static final RegistrySupplier<SpawnEggItem> TAR_SLIME_SPAWN_EGG = ModItems.registerSpawnEgg("spawn_egg_tar_slime", ModEntities.TAR_SLIME, 0x222222, 723723);
    public static final RegistrySupplier<SpawnEggItem> ANU_BOSS_SPAWN_EGG = ModItems.registerSpawnEgg("spawn_egg_anu_boss", ModEntities.ANU_BOSS, 986895, 16198912);
    public static final RegistrySupplier<SpawnEggItem> SENTRY_PIGLIN_SPAWN_EGG = ModItems.registerSpawnEgg("spawn_egg_sentry_piglin", ModEntities.SENTRY_PIGLIN, 15373203, 13674320);
    public static final RegistrySupplier<SpawnEggItem> FAILURESAURUS_SPAWN_EGG = ModItems.registerSpawnEgg("spawn_egg_failuresaurus", ModEntities.FAILURESAURUS, 4643483, 2456391);
    public static final Map<DyeColor, RegistrySupplier<ToyBallItem>> TOY_BALLS = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), ModItems::registerBall));
    public static final Map<String, RegistrySupplier<ToyTetheredLogItem>> TOY_TETHERED_LOGS = WoodType.m_61843_().filter(ToyBase::isVanillaWood).collect(Collectors.toMap(WoodType::f_61839_, ModItems::registerTetheredLog));
    public static final Map<String, RegistrySupplier<ToyScratchingPostItem>> TOY_SCRATCHING_POSTS = WoodType.m_61843_().filter(ToyBase::isVanillaWood).collect(Collectors.toMap(WoodType::f_61839_, ModItems::registerScratchingPost));

    private static <T extends Mob> RegistrySupplier<SpawnEggItem> registerSpawnEgg(String id, RegistrySupplier<EntityType<T>> type, int color1, int color2) {
        return ITEMS.register(id, () -> new ArchitecturySpawnEggItem(type, color1, color2, new Item.Properties().arch$tab(ModTabs.FA_MOB_ITEM_TAB)));
    }

    private static RegistrySupplier<ToyBallItem> registerBall(DyeColor color) {
        return ITEMS.register("toy_ball_" + color.m_41065_(), () -> new ToyBallItem(color, new Item.Properties().arch$tab(ModTabs.FA_BLOCK_TAB)));
    }

    private static RegistrySupplier<ToyTetheredLogItem> registerTetheredLog(WoodType woodType) {
        return ITEMS.register("toy_tethered_log_" + woodType.f_61839_(), () -> new ToyTetheredLogItem(woodType, new Item.Properties().arch$tab(ModTabs.FA_BLOCK_TAB)));
    }

    private static RegistrySupplier<ToyScratchingPostItem> registerScratchingPost(WoodType woodType) {
        return ITEMS.register("toy_scratching_post_" + woodType.f_61839_(), () -> new ToyScratchingPostItem(woodType, new Item.Properties().arch$tab(ModTabs.FA_BLOCK_TAB)));
    }

    public static void register() {
        VanillaEntityInfo.register();
        PrehistoricEntityInfo.register();
        ITEMS.register();
    }
}

