/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.biome;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.world.feature.placement.ModPlacedFeatures;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModBiomes {
    public static final ResourceKey<Biome> ANU_LAIR_KEY = ModBiomes.resource("anu_lair");
    public static final ResourceKey<Biome> TREASURE_ROOM_KEY = ModBiomes.resource("treasure_room");
    public static final ResourceKey<Biome> VOLCANO_KEY = ModBiomes.resource("volcano");

    private static ResourceKey<Biome> resource(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)FossilMod.location(name));
    }

    public static void bootstrap(BootstapContext<Biome> context) {
        context.m_255272_(ANU_LAIR_KEY, (Object)ModBiomes.anuLair((HolderGetter<PlacedFeature>)context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_)));
        context.m_255272_(TREASURE_ROOM_KEY, (Object)ModBiomes.treasureRoom((HolderGetter<PlacedFeature>)context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_)));
        context.m_255272_(VOLCANO_KEY, (Object)ModBiomes.volcano((HolderGetter<PlacedFeature>)context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_)));
    }

    public static Biome volcano(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LAKES, ModPlacedFeatures.VOLCANO_LAVA_LAKE_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, ModPlacedFeatures.VOLCANO_ASH_DISK_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, ModPlacedFeatures.VOLCANO_MAGMA_DISK_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, ModPlacedFeatures.VOLCANO_VENT_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, ModPlacedFeatures.VOLCANO_FOSSIL_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, ModPlacedFeatures.VOLCANO_CONE_KEY);
        return ModBiomes.biome(false, 2.0f, 0.0f, 9965584, 4982792, 0x504040, ModBiomes.calculateSkyColor(2.0f), new MobSpawnSettings.Builder(), biomeBuilder);
    }

    public static Biome treasureRoom(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        return ModBiomes.biome(false, 0.5f, 0.5f, 0, 0, 0, 0, new MobSpawnSettings.Builder(), biomeBuilder);
    }

    public static Biome anuLair(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder mobs = new MobSpawnSettings.Builder();
        mobs.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20511_, 2, 1, 8));
        mobs.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SENTRY_PIGLIN.get(), 6, 1, 8));
        return ModBiomes.biome(false, 0.5f, 0.5f, 4159204, 329011, 0, 0, mobs, biomeBuilder);
    }

    protected static int calculateSkyColor(float temperature) {
        float i = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - i * 0.05f), (float)(0.5f + i * 0.1f), (float)1.0f);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int fogColor, int skyColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(skyColor).m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }
}

