/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MutantTreeFeature
extends CustomTreeFeature {
    @Override
    protected boolean placeTree(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        int treeHeight = context.m_225041_().m_188503_(3) + 8;
        int foliageHeight = 4;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        BlockState log = ((RotatedPillarBlock)ModBlocks.MUTANT_TREE_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.MUTANT_TREE_LEAVES.get()).m_49966_();
        BlockState vine = ((Block)ModBlocks.MUTANT_TREE_VINE.get()).m_49966_();
        for (int i = 0; i < treeHeight - 1; ++i) {
            level.m_7731_(pos.m_6630_(i), log, 19);
        }
        int trunk = treeHeight - foliageHeight;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> vinePositions = new ArrayList<BlockPos>();
        for (int i = 0; i < foliageHeight; ++i) {
            int offset = i == 0 ? 3 : 3 - i + 1;
            for (int x = -offset; x <= offset; ++x) {
                for (int z = -offset; z <= offset; ++z) {
                    if (!level.m_46859_((BlockPos)mutable.m_122154_((Vec3i)pos, x, trunk + i, z))) continue;
                    this.placeLeaf(level, (BlockPos)mutable, leaves);
                    if (i != 0 || Math.abs(x) != 3 && Math.abs(z) != 3) continue;
                    vinePositions.add(mutable.m_7949_());
                }
            }
        }
        BlockPos belowFoliage = pos.m_6630_(trunk - 1);
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                int absX = Math.abs(x);
                int absZ = Math.abs(z);
                if (level.m_213780_().m_188503_(6) == 0 && (absX == 2 && absZ <= 2 || absX <= 2 && absZ == 2)) {
                    mutable.m_122154_((Vec3i)belowFoliage, x, 1, z);
                    BlockPos diff = mutable.m_7918_(-belowFoliage.m_123341_(), -belowFoliage.m_123342_(), -belowFoliage.m_123343_());
                    float steps = Math.max(Mth.m_14040_((int)diff.m_123341_()), Math.max(Mth.m_14040_((int)diff.m_123342_()), Mth.m_14040_((int)diff.m_123343_())));
                    float dX = (float)diff.m_123341_() / steps;
                    float dY = (float)diff.m_123342_() / steps;
                    float dZ = (float)diff.m_123343_() / steps;
                    int i = 1;
                    while ((float)i <= steps) {
                        level.m_7731_((BlockPos)mutable.m_122154_((Vec3i)belowFoliage, (int)(0.5 + (double)(dX * (float)i)), (int)(dY * (float)i), (int)(0.5 + (double)(dZ * (float)i))), (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)this.getLogAxis(belowFoliage, (BlockPos)mutable)), 19);
                        ++i;
                    }
                    continue;
                }
                if (level.m_213780_().m_188503_(5) == 0 && (x != 0 || z != 0)) {
                    if (!level.m_8055_((BlockPos)mutable.m_122154_((Vec3i)belowFoliage, x, 1, z)).m_60713_(leaves.m_60734_())) continue;
                    this.removeLeaf(level, (BlockPos)mutable);
                    if (absX != 3 && absZ != 3) continue;
                    vinePositions.remove(mutable.m_7949_());
                    continue;
                }
                if (level.m_213780_().m_188503_(2) != 0 || absX != 3 && absZ != 3) continue;
                this.placeLeaf(level, (BlockPos)mutable.m_122154_((Vec3i)belowFoliage, x, 0, z), leaves);
                vinePositions.remove(mutable.m_7494_());
                vinePositions.add(mutable.m_7949_());
            }
        }
        this.placeVine(level, vine, vinePositions);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122159_((Vec3i)belowFoliage, direction);
            for (int i = 0; !(i >= trunk || level.m_46859_((BlockPos)mutable) && level.m_46859_(mutable.m_7495_()) && level.m_213780_().m_188503_(9) == 0); ++i) {
                mutable.m_122173_(Direction.DOWN);
            }
        }
        return true;
    }

    private Direction.Axis getLogAxis(BlockPos pos, BlockPos otherPos) {
        Direction.Axis axis = Direction.Axis.Y;
        int xDiff = Math.abs(otherPos.m_123341_() - pos.m_123341_());
        int diff = Math.max(xDiff, Math.abs(otherPos.m_123343_() - pos.m_123343_()));
        if (diff > 0) {
            axis = xDiff == diff ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }

    private void placeVine(WorldGenLevel level, BlockState state, List<BlockPos> leafPositions) {
        RandomSource random = level.m_213780_();
        leafPositions.forEach(blockPos -> {
            BlockPos pos;
            if (random.m_188503_(4) == 0 && this.isAir(level, pos = blockPos.m_122024_())) {
                this.placeHangingVine(level, pos, VineBlock.f_57835_, state);
            }
            if (random.m_188503_(4) == 0 && this.isAir(level, pos = blockPos.m_122029_())) {
                this.placeHangingVine(level, pos, VineBlock.f_57837_, state);
            }
            if (random.m_188503_(4) == 0 && this.isAir(level, pos = blockPos.m_122012_())) {
                this.placeHangingVine(level, pos, VineBlock.f_57836_, state);
            }
            if (random.m_188503_(4) == 0 && this.isAir(level, pos = blockPos.m_122019_())) {
                this.placeHangingVine(level, pos, VineBlock.f_57834_, state);
            }
        });
    }

    private void placeHangingVine(WorldGenLevel level, BlockPos pos, BooleanProperty sideProperty, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)sideProperty, (Comparable)Boolean.valueOf(true)), 19);
        pos = pos.m_7495_();
        for (int i = 4; this.isAir(level, pos) && i > 0; --i) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)sideProperty, (Comparable)Boolean.valueOf(true)), 19);
            pos = pos.m_7495_();
        }
    }
}

