/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstructionsList
extends class_362
implements class_4068 {
    static final class_2960 ICON_OVERLAY_LOCATION = new class_2960("textures/gui/resource_packs.png");
    private final List<InstructionEntry> children = new ArrayList<InstructionEntry>();
    private final List<Instruction> instructions;
    private final class_310 minecraft;
    @Nullable
    private InstructionEntry selected;
    @Nullable
    private InstructionEntry hovered;
    protected int width = 200;
    protected int y0 = 5;
    protected int y1 = this.y0 + 300;
    protected int x0 = 5;
    protected int x1 = this.x0 + this.width;
    protected int itemHeight = 20;
    protected int rowWidth = this.x1 - this.x0 - 10;
    private final class_4185 removeButton;
    private final class_4185 upButton;
    private final class_4185 downButton;
    private double dragStartX;
    private double dragStartY;
    private double dragMoveX;
    private double dragMoveY;
    private int dragIndex = -1;
    private boolean dragOffset;
    private InstructionEntry dragging;

    public InstructionsList(InstructionTab.Pair pair, class_310 minecraft) {
        this.minecraft = minecraft;
        this.instructions = pair.instructions();
        this.instructions.forEach(instruction -> this.children.add(new InstructionEntry((Instruction)instruction, minecraft)));
        this.removeButton = new class_4185(this.x0, this.y1 + 5, 70, 20, (class_2561)new class_2585("Remove item"), button -> {
            if (this.selected != null) {
                this.instructions.remove(this.children.indexOf(this.selected));
                this.children.remove(this.selected);
                this.selected = null;
                if (!this.children.isEmpty()) {
                    this.selected = this.children.get(0);
                }
            }
        });
        this.upButton = new class_4185(this.x0 + 110, this.y1 + 5, 20, 20, (class_2561)new class_2585(""), button -> {
            int i = this.children.indexOf(this.selected);
            if (i != 0) {
                Collections.swap(this.children, i, i - 1);
                Collections.swap(this.instructions, i, i - 1);
            }
        }){

            public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
                super.method_25359(poseStack, mouseX, mouseY, partialTick);
                RenderSystem.setShaderTexture((int)0, (class_2960)ICON_OVERLAY_LOCATION);
                int left = this.field_22760 + this.field_22758 / 2;
                int top = this.field_22761 + (this.field_22759 - 8) / 2;
                class_332.method_25290((class_4587)poseStack, (int)(left - 8), (int)(top - 5), (float)111.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                RenderSystem.setShader(class_757::method_34542);
            }
        };
        this.downButton = new class_4185(this.x0 + 80, this.y1 + 5, 20, 20, (class_2561)new class_2585(""), button -> {
            int i = this.children.indexOf(this.selected);
            if (i != this.children.size() - 1) {
                Collections.swap(this.children, i, i + 1);
                Collections.swap(this.instructions, i, i + 1);
            }
        }){

            public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
                super.method_25359(poseStack, mouseX, mouseY, partialTick);
                RenderSystem.setShaderTexture((int)0, (class_2960)ICON_OVERLAY_LOCATION);
                int left = this.field_22760 + this.field_22758 / 2;
                int top = this.field_22761 + (this.field_22759 - 8) / 2;
                class_332.method_25290((class_4587)poseStack, (int)(left - 23), (int)(top - 4), (float)64.0f, (float)16.0f, (int)32, (int)32, (int)256, (int)256);
                RenderSystem.setShader(class_757::method_34542);
            }
        };
    }

    public void addInstruction(Instruction instruction) {
        this.children.add(new InstructionEntry(instruction, this.minecraft));
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        InstructionTab.highlightInstructionEntity = null;
        InstructionTab.highlightInstruction = null;
        if (this.method_25405(mouseX, mouseY)) {
            InstructionEntry entry = this.getEntryAtPosition(mouseX, mouseY);
            if (entry != null) {
                if (entry.method_25402(mouseX, mouseY, button)) {
                    this.method_25395(entry);
                    this.method_25398(true);
                    return true;
                }
            } else if (button == 0) {
                this.selected = null;
                return true;
            }
        }
        if (this.removeButton.method_25405(mouseX, mouseY)) {
            return this.removeButton.method_25402(mouseX, mouseY, button);
        }
        if (this.upButton.method_25405(mouseX, mouseY)) {
            return this.upButton.method_25402(mouseX, mouseY, button);
        }
        if (this.downButton.method_25405(mouseX, mouseY)) {
            return this.downButton.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging != null) {
            if (this.dragging.method_25403(mouseX, mouseY, button, dragX, dragY)) {
                Pair<class_243, class_243> pair = this.getPositionOfEntry(this.dragging);
                class_243 compare = ((class_243)pair.getFirst()).method_1031(this.dragMoveX, this.dragMoveY, 0.0);
                if (compare.field_1352 < (double)this.getRowLeft()) {
                    compare = ((class_243)pair.getSecond()).method_1031(this.dragMoveX, this.dragMoveY, 0.0);
                }
                InstructionEntry above = this.getEntryAtPosition(compare.field_1352, compare.field_1351 - (double)this.itemHeight / 2.0);
                InstructionEntry below = this.getEntryAtPosition(compare.field_1352, compare.field_1351 + (double)this.itemHeight / 2.0);
                this.dragIndex = above == null && below != null ? 0 : (below == null && above != null ? this.children.size() : this.children.indexOf(below));
                this.dragOffset = this.children.indexOf(this.dragging) < this.dragIndex;
                return true;
            }
            this.dragIndex = -1;
            return false;
        }
        InstructionEntry entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            return entry.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    private int getRowLeft() {
        return this.x0 + this.width / 2 - this.rowWidth / 2;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        int prevIndex;
        int dragTarget;
        if (this.method_25399() != null) {
            this.method_25399().method_25406(mouseX, mouseY, button);
        }
        if (this.dragging != null && this.dragIndex != -1 && (dragTarget = this.dragOffset ? this.dragIndex - 1 : this.dragIndex) != (prevIndex = this.children.indexOf(this.dragging))) {
            if (prevIndex < dragTarget) {
                Collections.rotate(this.children.subList(prevIndex, dragTarget + 1), -1);
                Collections.rotate(this.instructions.subList(prevIndex, dragTarget + 1), -1);
            } else {
                Collections.rotate(this.children.subList(dragTarget, prevIndex + 1), 1);
                Collections.rotate(this.instructions.subList(dragTarget, prevIndex + 1), 1);
            }
        }
        this.dragging = null;
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.y0 && mouseY <= (double)this.y1 && mouseX >= (double)this.x0 && mouseX <= (double)this.x1;
    }

    private Pair<class_243, class_243> getPositionOfEntry(InstructionEntry entry) {
        int left = this.getRowLeft();
        int right = left + this.rowWidth;
        int centerY = this.children.indexOf(entry) * this.itemHeight + this.y0 + 2 + this.itemHeight / 2;
        return new Pair((Object)new class_243((double)left, (double)centerY, 0.0), (Object)new class_243((double)right, (double)centerY, 0.0));
    }

    @Nullable
    private InstructionEntry getEntryAtPosition(double mouseX, double mouseY) {
        int left = this.getRowLeft();
        int right = left + this.rowWidth;
        int m = class_3532.method_15357((double)(mouseY - (double)this.y0)) - 2;
        int n = m / this.itemHeight;
        return mouseX >= (double)left && mouseX <= (double)right && n >= 0 && m >= 0 && n < this.children.size() ? (InstructionEntry)this.method_25396().get(n) : null;
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.y1 = Math.max(300, 300);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        this.hovered = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22735);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912((double)this.x0, (double)this.y1, 0.0).method_22913((float)this.x0 / 32.0f, (float)this.y1 / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.x1, (double)this.y1, 0.0).method_22913((float)this.x1 / 32.0f, (float)this.y1 / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.x1, (double)this.y0, 0.0).method_22913((float)this.x1 / 32.0f, (float)this.y0 / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.x0, (double)this.y0, 0.0).method_22913((float)this.x0 / 32.0f, (float)this.y0 / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        tesselator.method_1350();
        int rowLeft = this.x0 + this.width / 2 - this.rowWidth / 2 + 2;
        this.renderList(poseStack, rowLeft, this.y0 + 4, mouseX, mouseY, partialTick);
        this.removeButton.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.upButton.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.downButton.method_25394(poseStack, mouseX, mouseY, partialTick);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected void renderList(class_4587 poseStack, int x, int y, int mouseX, int mouseY, float partialTick) {
        int itemCount = this.children.size();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        int rowLeft = this.getRowLeft();
        int rowRight = rowLeft + this.rowWidth;
        int rowHeight = this.itemHeight - 4;
        for (int i = 0; i < itemCount; ++i) {
            int rowTop = y + i * this.itemHeight;
            int rowBottom = rowTop + this.itemHeight;
            if (rowBottom < this.y0 || rowTop > this.y1) continue;
            InstructionEntry entry = this.children.get(i);
            if (Objects.equals(this.selected, entry)) {
                this.renderEntry(tesselator, bufferBuilder, rowLeft, rowRight, rowTop, rowHeight);
            }
            entry.render(poseStack, rowTop, rowLeft, Objects.equals(this.hovered, entry) && this.dragging == null);
            if (!Objects.equals(this.dragging, entry)) continue;
            int dragLeft = (int)(this.dragStartX + this.dragMoveX + (double)this.width / 2.0 - (double)this.rowWidth / 2.0);
            int dragRight = (int)(this.dragStartX + this.dragMoveX + (double)this.width / 2.0 + (double)this.rowWidth / 2.0);
            int dragTop = (int)((double)rowTop + (this.dragStartY + this.dragMoveY - (double)this.y0));
            this.renderEntry(tesselator, bufferBuilder, dragLeft, dragRight, dragTop, rowHeight);
            entry.render(poseStack, dragTop, dragLeft, true);
        }
        if (this.dragging != null && this.dragIndex != -1) {
            int arrowLeft = rowLeft - 2;
            int arrowHeight = rowHeight / 2;
            int arrowTop = y + this.dragIndex * this.itemHeight - arrowHeight;
            RenderSystem.disableTexture();
            RenderSystem.setShader(class_757::method_34539);
            if (this.dragIndex == this.children.indexOf(this.dragging) + (this.dragOffset ? 1 : 0)) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.5f, (float)1.0f, (float)0.5f, (float)1.0f);
            }
            bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
            bufferBuilder.method_22912((double)arrowLeft, (double)(arrowTop + arrowHeight + 4), 0.0).method_1344();
            bufferBuilder.method_22912((double)(arrowLeft + 6), (double)arrowTop + (double)arrowHeight / 2.0 + 2.0, 0.0).method_1344();
            bufferBuilder.method_22912((double)arrowLeft, (double)arrowTop, 0.0).method_1344();
            tesselator.method_1350();
            RenderSystem.enableTexture();
        }
    }

    private void renderEntry(class_289 tesselator, class_287 bufferBuilder, int rowLeft, int rowRight, int rowTop, int rowHeight) {
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34539);
        float f = 0.75f;
        RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22912((double)rowLeft, (double)(rowTop + rowHeight + 2), 0.0).method_1344();
        bufferBuilder.method_22912((double)rowRight, (double)(rowTop + rowHeight + 2), 0.0).method_1344();
        bufferBuilder.method_22912((double)rowRight, (double)(rowTop - 2), 0.0).method_1344();
        bufferBuilder.method_22912((double)rowLeft, (double)(rowTop - 2), 0.0).method_1344();
        tesselator.method_1350();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22912((double)(rowLeft + 1), (double)(rowTop + rowHeight + 1), 0.0).method_1344();
        bufferBuilder.method_22912((double)(rowRight - 1), (double)(rowTop + rowHeight + 1), 0.0).method_1344();
        bufferBuilder.method_22912((double)(rowRight - 1), (double)(rowTop - 1), 0.0).method_1344();
        bufferBuilder.method_22912((double)(rowLeft + 1), (double)(rowTop - 1), 0.0).method_1344();
        tesselator.method_1350();
        RenderSystem.enableTexture();
    }

    class InstructionEntry
    implements class_364 {
        private final Instruction instruction;
        private final class_310 minecraft;

        public InstructionEntry(Instruction instruction, class_310 minecraft) {
            this.instruction = instruction;
            this.minecraft = minecraft;
        }

        public void render(class_4587 poseStack, int top, int left, boolean isMouseOver) {
            if (isMouseOver) {
                class_332.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585(this.instruction.toString()), (int)(left + 4), (int)(top + 4), (int)Integer.parseUnsignedInt("a8a2a2", 16));
            } else {
                class_332.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585(this.instruction.toString()), (int)(left + 4), (int)(top + 4), (int)Integer.parseUnsignedInt("ffffff", 16));
            }
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (button == 0) {
                if (InstructionsList.this.dragging == null) {
                    InstructionsList.this.dragStartX = InstructionsList.this.x0;
                    InstructionsList.this.dragStartY = InstructionsList.this.y0;
                    InstructionsList.this.dragMoveX = 0.0;
                    InstructionsList.this.dragMoveY = 0.0;
                }
                InstructionsList.this.dragging = this;
                InstructionsList.this.dragMoveX += dragX;
                InstructionsList.this.dragMoveY += dragY;
                return true;
            }
            return false;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                InstructionsList.this.selected = this;
                InstructionTab.highlightInstruction = this.instruction;
                return true;
            }
            return false;
        }
    }
}

