/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4459;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmphNodeEvaluator
extends PlayerNodeEvaluator {
    @Override
    public void prepare(class_1950 level, class_1657 p) {
        super.prepare(level, p);
        PathingDebug.setPathfindingMalus(class_7.field_18, 0.0f);
    }

    @Override
    public class_9 getStart() {
        class_238 aABB = PathingRenderer.getBigHitbox().method_997(class_243.method_24955((class_2382)PathingDebug.pos1));
        return super.getNode(class_3532.method_15357((double)aABB.field_1323), class_3532.method_15357((double)(aABB.field_1322 + 0.5)), class_3532.method_15357((double)aABB.field_1321));
    }

    @Override
    @NotNull
    public class_4459 getGoal(double x, double y, double z) {
        return new class_4459(super.getNode(class_3532.method_15357((double)x), class_3532.method_15357((double)(y + 0.5)), class_3532.method_15357((double)z)));
    }

    @Override
    @Nullable
    protected class_9 getNode(int x, int y, int z) {
        if (this.isAmphibious()) {
            return super.getNode(x, y, z);
        }
        class_9 node = null;
        class_7 blockPathTypes = this.getCachedBlockType(this.player, x, y, z);
        if (blockPathTypes == class_7.field_18) {
            float f;
            float f2 = PathingDebug.getPathfindingMalus(blockPathTypes);
            if (f >= 0.0f) {
                node = super.getNode(x, y, z);
                node.field_41 = blockPathTypes;
                node.field_43 = Math.max(node.field_43, f2);
                if (this.level.method_8316(new class_2338(x, y, z)).method_15769()) {
                    node.field_43 += 8.0f;
                }
            }
        }
        return node;
    }

    @Override
    public int getNeighbors(class_9[] nodes, class_9 node) {
        int x = node.field_40;
        int y = node.field_39;
        int z = node.field_38;
        class_7 type = this.getCachedBlockType(this.player, x, y, z);
        if (type == class_7.field_18 || type == class_7.field_4) {
            int i = 0;
            EnumMap map = Maps.newEnumMap(class_2350.class);
            for (class_2350 direction : class_2350.values()) {
                class_9 faceNode = this.getNode(x + direction.method_10148(), y + direction.method_10164(), z + direction.method_10165());
                map.put(direction, faceNode);
                if (!this.isNodeValid(faceNode)) continue;
                nodes[i++] = faceNode;
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2350 direction2 = direction.method_10170();
                class_9 diagonalNode = this.getNode(x + direction.method_10148() + direction2.method_10148(), y, z + direction.method_10165() + direction2.method_10165());
                if (!this.isDiagonalNodeValid(diagonalNode, (class_9)map.get(direction), (class_9)map.get(direction2))) continue;
                nodes[i++] = diagonalNode;
            }
            return i;
        }
        int i = super.getNeighbors(nodes, node);
        class_7 typeAbove = this.getCachedBlockType(this.player, x, y + 1, z);
        int j = PathingDebug.getPathfindingMalus(type) > 0.0f && typeAbove != class_7.field_21326 ? class_3532.method_15375((float)Math.max(1, 1)) : 0;
        double floorLevel = this.getFloorLevel(new class_2338(x, y, z));
        class_9 nodeAbove = this.findAcceptedNode(x, y + 1, z, Math.max(0, j - 1), floorLevel, class_2350.field_11036, type);
        class_9 nodeBelow = this.findAcceptedNode(x, y - 1, z, j, floorLevel, class_2350.field_11033, type);
        if (this.isNeighborValid(nodeAbove, node)) {
            nodes[i++] = nodeAbove;
        }
        if (this.isNeighborValid(nodeBelow, node) && type != class_7.field_19) {
            nodes[i++] = nodeBelow;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable class_9 node) {
        return node != null && !node.field_42 && this.getBlockPathType((class_1922)this.level, node.field_40, node.field_39, node.field_38) != class_7.field_22;
    }

    protected boolean isDiagonalNodeValid(@Nullable class_9 diagonal, @Nullable class_9 node1, @Nullable class_9 node2) {
        return this.isNodeValid(diagonal) && node1 != null && node1.field_43 >= 0.0f && node2 != null && node2.field_43 >= 0.0f;
    }

    protected boolean isVerticalDiagonalNodeValid(@Nullable class_9 diagonal, @Nullable class_9 node1, @Nullable class_9 node2) {
        return this.isNodeValid(diagonal) && node1 != null && node1.field_43 >= 0.0f && node2 != null && node2.field_43 >= 0.0f;
    }

    @Override
    protected boolean isAmphibious() {
        return true;
    }

    @Override
    @NotNull
    public class_7 getBlockPathType(class_1922 level, int x, int y, int z) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_7 type = AmphNodeEvaluator.getBlockPathTypeRaw(level, (class_2338)mutableBlockPos.method_10103(x, y, z));
        if (type == class_7.field_18) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_7 neighbourType = AmphNodeEvaluator.getBlockPathTypeRaw(level, (class_2338)mutableBlockPos.method_10103(x, y, z).method_10098(direction));
                if (neighbourType != class_7.field_22) continue;
                return class_7.field_4;
            }
            return class_7.field_18;
        }
        if (!this.isAmphibious()) {
            return class_7.field_22;
        }
        return AmphNodeEvaluator.getBlockPathTypeStatic(level, mutableBlockPos);
    }
}

