/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_4459;
import net.minecraft.class_5;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class PlayerPathFinder {
    protected static final float FUDGING = 1.5f;
    protected final class_9[] neighbors = new class_9[32];
    protected int maxVisitedNodes;
    public final PlayerNodeEvaluator nodeEvaluator;
    protected final class_5 openSet = new class_5();
    protected final List<class_9> closedSet = new ArrayList<class_9>();

    public PlayerPathFinder(PlayerNodeEvaluator nE, int i) {
        this.nodeEvaluator = nE;
        this.maxVisitedNodes = i;
    }

    @Nullable
    public PlayerPath findPath(class_1950 region, class_1657 player, Set<class_2338> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.openSet.method_5();
        this.closedSet.clear();
        this.nodeEvaluator.prepare(region, player);
        class_9 node = this.nodeEvaluator.getStart();
        Map<class_4459, class_2338> map = targetPositions.stream().collect(Collectors.toMap(blockPos -> this.nodeEvaluator.getGoal(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), Function.identity()));
        PlayerPath path = this.findPath(node, map, maxRange, accuracy, searchDepthMultiplier);
        this.nodeEvaluator.done();
        if (path != null) {
            path.setDebug(this.openSet.method_35493(), (class_9[])this.closedSet.toArray(class_9[]::new), map.keySet());
        }
        return path;
    }

    @Nullable
    protected PlayerPath findPath(class_9 node, Map<class_4459, class_2338> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        Set<class_4459> set = targetPos.keySet();
        node.field_36 = 0.0f;
        node.field_47 = node.field_34 = this.getBestH(node, set);
        this.openSet.method_5();
        this.openSet.method_2(node);
        int i = 1;
        HashSet set3 = Sets.newHashSetWithExpectedSize((int)set.size());
        int j = (int)((float)this.maxVisitedNodes * searchDepthMultiplier);
        while (!this.openSet.method_8() && i < j) {
            class_9 node2 = this.openSet.method_6();
            this.closedSet.add(node2);
            System.out.println(node2 + " f: " + node2.field_47 + " g: " + node2.field_36 + " h: " + node2.field_34);
            node2.field_42 = true;
            for (class_4459 target2 : set) {
                if (node2.method_21653((class_9)target2) > (float)accuracy) continue;
                target2.method_21665();
                set3.add(target2);
            }
            if (!set3.isEmpty()) break;
            if (node2.method_31(node) >= maxRange) continue;
            int k = this.nodeEvaluator.getNeighbors(this.neighbors, node2);
            for (int l = 0; l < k; ++l) {
                class_9 node3 = this.neighbors[l];
                float f = node2.method_31(node3);
                node3.field_46 = node2.field_46 + f;
                float g = node2.field_36 + f + node3.field_43;
                if (node3.field_46 >= maxRange || node3.method_27() && g >= node3.field_36) continue;
                node3.field_35 = node2;
                node3.field_36 = g;
                node3.field_34 = this.getBestH(node3, set) * 1.5f;
                if (node3.method_27()) {
                    this.openSet.method_3(node3, node3.field_36 + node3.field_34);
                    continue;
                }
                node3.field_47 = node3.field_36 + node3.field_34;
                System.out.println("Adding " + node3 + " f: " + node3.field_47 + " g: " + node3.field_36 + " h: " + node3.field_34);
                this.openSet.method_2(node3);
            }
            ++i;
        }
        Optional<PlayerPath> optional = !set3.isEmpty() ? set3.stream().map(target -> this.reconstructPath(target.method_21664(), (class_2338)targetPos.get(target), true)).min(Comparator.comparingInt(PlayerPath::getNodeCount)) : set.stream().map(target -> this.reconstructPath(target.method_21664(), (class_2338)targetPos.get(target), false)).min(Comparator.comparingDouble(PlayerPath::getDistToTarget).thenComparingInt(PlayerPath::getNodeCount));
        return optional.orElse(null);
    }

    float getBestH(class_9 node, Set<class_4459> targets) {
        float f = Float.MAX_VALUE;
        for (class_4459 target : targets) {
            float g = node.method_31((class_9)target);
            target.method_21662(g, node);
            f = Math.min(g, f);
        }
        return f;
    }

    PlayerPath reconstructPath(class_9 point, class_2338 targetPos, boolean reachesTarget) {
        ArrayList list = Lists.newArrayList();
        class_9 node = point;
        list.add(0, node);
        while (node.field_35 != null) {
            node = node.field_35;
            list.add(0, node);
        }
        return new PlayerPath(list, targetPos, reachesTarget);
    }
}

