/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugPathFinder;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathFinder;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathNavigation;
import java.util.Objects;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class SweepPathNavigation
extends PlayerPathNavigation {
    @Nullable
    private class_2338 pathToPosition;
    static final float EPSILON = 1.0E-8f;

    public SweepPathNavigation(class_1657 player, class_1937 level) {
        super(player, level, "Sweep");
    }

    @Override
    protected PlayerPathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new PlayerNodeEvaluator();
        return new DebugPathFinder(this.nodeEvaluator, maxVisitedNodes, false);
    }

    @Override
    protected void followThePath() {
        class_243 max;
        class_243 base;
        PlayerPath path = Objects.requireNonNull(this.path);
        path.sweepNextNodeIndex = path.getDebugNodeIndex();
        class_243 entityPos = this.sweepStartPos;
        int pathLength = path.getNodeCount();
        for (int i = path.getDebugNodeIndex(); i < path.getNodeCount(); ++i) {
            if ((double)path.getNode((int)i).field_39 == Math.floor(entityPos.field_1351)) continue;
            pathLength = i;
            break;
        }
        if (this.tryShortcut(path, entityPos, pathLength, base = entityPos.method_1031((double)(-PathingRenderer.getBbWidth() * 0.5f), 0.0, (double)(-PathingRenderer.getBbWidth() * 0.5f)), max = base.method_1031((double)PathingRenderer.getBbWidth(), (double)PathingRenderer.getBbHeight(), (double)PathingRenderer.getBbWidth())) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, PathingRenderer.getBbWidth() * 0.5f))) {
            path.setSweepNodeIndex(path.sweepNextNodeIndex + 1);
        }
    }

    @Override
    public void setSweepStartPos(class_243 vec) {
        super.setSweepStartPos(vec);
        if (this.path != null) {
            this.followThePath();
            this.tick();
        }
    }

    @Override
    public PlayerPath createPath(class_2338 blockPos, int i) {
        this.pathToPosition = blockPos;
        return super.createPath(blockPos, i);
    }

    @Override
    public PlayerPath createPath(class_1297 entity, int i) {
        this.pathToPosition = entity.method_24515();
        return super.createPath(entity, i);
    }

    @Override
    public void tick() {
        class_243 vec3 = this.path.getNextEntityPos((class_1297)this.player);
        this.setNextWantedPosition(vec3.field_1352, this.getGroundY(vec3), vec3.field_1350);
        vec3 = this.path.getSweepEntityPos((class_1297)this.player);
        this.setSweepWantedPosition(vec3.field_1352, this.getGroundY(vec3), vec3.field_1350);
        if (this.isDone() && this.pathToPosition != null) {
            if (this.pathToPosition.method_19769((class_2374)this.player.method_19538(), (double)PathingRenderer.getBbWidth()) || this.player.method_23318() > (double)this.pathToPosition.method_10264() && new class_2338((double)this.pathToPosition.method_10263(), this.player.method_23318(), (double)this.pathToPosition.method_10260()).method_19769((class_2374)this.player.method_19538(), (double)PathingRenderer.getBbWidth())) {
                this.pathToPosition = null;
            } else {
                this.setNextWantedPosition(this.pathToPosition.method_10263(), this.pathToPosition.method_10264(), this.pathToPosition.method_10260());
                this.setSweepWantedPosition(this.pathToPosition.method_10263(), this.pathToPosition.method_10264(), this.pathToPosition.method_10260());
            }
        }
    }

    private boolean isAt(PlayerPath path, float threshold) {
        class_243 entityPos = this.sweepStartPos;
        class_243 pathPos = path.getSweepEntityPos((class_1297)this.player);
        return class_3532.method_15379((float)((float)(entityPos.field_1352 - pathPos.field_1352))) < threshold && class_3532.method_15379((float)((float)(entityPos.field_1350 - pathPos.field_1350))) < threshold && Math.abs(entityPos.field_1351 - pathPos.field_1351) <= 1.0;
    }

    private boolean atElevationChange(PlayerPath path) {
        int curr = path.sweepNextNodeIndex;
        int end = Math.min(path.getNodeCount(), curr + class_3532.method_15386((float)(PathingRenderer.getBbWidth() * 0.5f)) + 1);
        int currY = path.getNode((int)curr).field_39;
        for (int i = curr + 1; i < end; ++i) {
            if (path.getNode((int)i).field_39 == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(PlayerPath path, class_243 entityPos, int pathLength, class_243 base, class_243 max) {
        int i = pathLength;
        while (--i > path.getDebugNodeIndex()) {
            class_243 vec = path.getEntityPosAtNode(i).method_1020(entityPos);
            if (this.isCollisionOnPath(vec, base, max)) continue;
            path.setSweepNodeIndex(i);
            return false;
        }
        return true;
    }

    private boolean isCollisionOnPath(class_243 pathVec, class_243 minBounds, class_243 maxBounds) {
        float pathLength = (float)pathVec.method_1033();
        if (pathLength < 1.0E-8f) {
            return false;
        }
        float[] trailingPositions = new float[3];
        int[] leadingEdges = new int[3];
        int[] trailingEdges = new int[3];
        int[] stepDirections = new int[3];
        float[] stepDelta = new float[3];
        float[] stepLength = new float[3];
        float[] normedAxis = new float[3];
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            float axisLength = SweepPathNavigation.chooseLengthForAxis(axis, pathVec);
            boolean stepDirection = axisLength >= 0.0f;
            int idx = axis.ordinal();
            stepDirections[idx] = stepDirection ? 1 : -1;
            float lead = SweepPathNavigation.chooseLengthForAxis(axis, stepDirection ? maxBounds : minBounds);
            trailingPositions[idx] = SweepPathNavigation.chooseLengthForAxis(axis, stepDirection ? minBounds : maxBounds);
            leadingEdges[idx] = SweepPathNavigation.leadEdgesToInt(lead, stepDirections[idx]);
            trailingEdges[idx] = SweepPathNavigation.trailEdgeToInt(trailingPositions[idx], stepDirections[idx]);
            normedAxis[idx] = axisLength / pathLength;
            stepDelta[idx] = class_3532.method_15379((float)(pathLength / axisLength));
            float dist = stepDirection ? (float)(leadingEdges[idx] + 1) - lead : lead - (float)leadingEdges[idx];
            stepLength[idx] = stepDelta[idx] < Float.POSITIVE_INFINITY ? stepDelta[idx] * dist : Float.POSITIVE_INFINITY;
        }
        class_2338.class_2339 pos = new class_2338.class_2339();
        float previousStepLength = 0.0f;
        do {
            class_2350.class_2351 axis = stepLength[0] < stepLength[1] ? (stepLength[0] < stepLength[2] ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051) : (stepLength[1] < stepLength[2] ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051);
            int idx = axis.ordinal();
            float dt = stepLength[idx] - previousStepLength;
            previousStepLength = stepLength[idx];
            int n = idx;
            leadingEdges[n] = leadingEdges[n] + stepDirections[idx];
            int n2 = idx;
            stepLength[n2] = stepLength[n2] + stepDelta[idx];
            for (class_2350.class_2351 axis2 : class_2350.class_2351.values()) {
                int i;
                int n3 = i = axis2.ordinal();
                trailingPositions[n3] = trailingPositions[n3] + dt * normedAxis[i];
                trailingEdges[i] = SweepPathNavigation.trailEdgeToInt(trailingPositions[i], stepDirections[i]);
            }
            int stepX = stepDirections[0];
            int minX = axis == class_2350.class_2351.field_11048 ? leadingEdges[0] : trailingEdges[0];
            int maxX = leadingEdges[0] + stepX;
            int stepY = stepDirections[1];
            int minY = axis == class_2350.class_2351.field_11052 ? leadingEdges[1] : trailingEdges[1];
            int maxY = leadingEdges[1] + stepY;
            int stepZ = stepDirections[2];
            int minZ = axis == class_2350.class_2351.field_11051 ? leadingEdges[2] : trailingEdges[2];
            int maxZ = leadingEdges[2] + stepZ;
            for (int x = minX; x != maxX; x += stepX) {
                for (int z = minZ; z != maxZ; z += stepZ) {
                    if (!this.isCollisionAtColumn(x, minY, z, maxY, stepY, pos)) continue;
                    return true;
                }
            }
        } while (previousStepLength <= pathLength);
        return false;
    }

    private boolean isCollisionAtColumn(int x, int minY, int z, int maxY, int stepY, class_2338.class_2339 pos) {
        for (int y = minY; y != maxY; y += stepY) {
            class_2680 block = this.level.method_8320((class_2338)pos.method_10103(x, y, z));
            if (block.method_26171((class_1922)this.level, (class_2338)pos, class_10.field_50)) continue;
            return true;
        }
        class_7 in = this.nodeEvaluator.getBlockPathType((class_1922)this.level, x, minY, z);
        float malus = PathingDebug.getPathfindingMalus(in);
        if (malus < 0.0f || malus >= 8.0f) {
            return true;
        }
        class_7 below = this.nodeEvaluator.getBlockPathType((class_1922)this.level, x, minY - 1, z);
        if (below == class_7.field_18 || below == class_7.field_14 || below == class_7.field_7) {
            return true;
        }
        return in == class_7.field_3 || in == class_7.field_9 || in == class_7.field_17;
    }

    static float chooseLengthForAxis(class_2350.class_2351 axis, class_243 vec) {
        return (float)axis.method_10172(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    static int leadEdgesToInt(float coord, int step) {
        return class_3532.method_15375((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return class_3532.method_15375((float)(coord + (float)step * 1.0E-8f));
    }
}

