/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.geckolib;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.easing.EasingType;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.keyframe.AnimationPoint;
import software.bernie.geckolib3.core.keyframe.BoneAnimationQueue;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.core.snapshot.BoneSnapshot;
import software.bernie.geckolib3.core.snapshot.DirtyTracker;
import software.bernie.geckolib3.core.util.MathUtil;

public class AnimationProcessorOverride {
    public static <T extends IAnimatable> void tickAdditiveAnimations(double seekTime, AnimationEvent<T> event, boolean reloadAnimations, List<IBone> modelRendererList, MolangParser parser, boolean crashWhenCantFindBone, AnimationData manager, Map<String, DirtyTracker> modelTracker, Map<String, Pair<IBone, BoneSnapshot>> boneSnapshots) {
        for (AnimationController controller : manager.getAnimationControllers().values()) {
            if (reloadAnimations) {
                controller.markNeedsReload();
                controller.getBoneAnimationQueues().clear();
            }
            controller.isJustStarting = manager.isFirstTick;
            event.setController(controller);
            controller.process(seekTime, event, modelRendererList, boneSnapshots, parser, crashWhenCantFindBone);
        }
        for (IBone bone : modelRendererList) {
            DirtyTracker dirtyTracker = modelTracker.get(bone.getName());
            if (dirtyTracker == null) continue;
            boolean firstRot = true;
            boolean firstPos = true;
            boolean firstScale = true;
            BoneSnapshot snapshot = (BoneSnapshot)boneSnapshots.get(bone.getName()).getRight();
            BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
            for (AnimationController controller : manager.getAnimationControllers().values()) {
                BoneAnimationQueue boneAnimation = (BoneAnimationQueue)controller.getBoneAnimationQueues().get(bone.getName());
                AnimationPoint rXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                AnimationPoint rYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                AnimationPoint rZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                AnimationPoint pXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                AnimationPoint pYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                AnimationPoint pZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                AnimationPoint sXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                AnimationPoint sYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                AnimationPoint sZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                if (rXPoint != null && rYPoint != null && rZPoint != null) {
                    bone.setRotationX(MathUtil.lerpValues((AnimationPoint)rXPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) + (firstRot ? initialSnapshot.rotationValueX : bone.getRotationX()));
                    bone.setRotationY(MathUtil.lerpValues((AnimationPoint)rYPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) + (firstRot ? initialSnapshot.rotationValueY : bone.getRotationY()));
                    bone.setRotationZ(MathUtil.lerpValues((AnimationPoint)rZPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) + (firstRot ? initialSnapshot.rotationValueZ : bone.getRotationZ()));
                    snapshot.rotationValueX = bone.getRotationX();
                    snapshot.rotationValueY = bone.getRotationY();
                    snapshot.rotationValueZ = bone.getRotationZ();
                    snapshot.isCurrentlyRunningRotationAnimation = true;
                    dirtyTracker.hasRotationChanged = true;
                    firstRot = false;
                }
                if (pXPoint != null && pYPoint != null && pZPoint != null) {
                    bone.setPositionX(MathUtil.lerpValues((AnimationPoint)pXPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) + (firstPos ? 0.0f : bone.getPositionX()));
                    bone.setPositionY(MathUtil.lerpValues((AnimationPoint)pYPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) + (firstPos ? 0.0f : bone.getPositionY()));
                    bone.setPositionZ(MathUtil.lerpValues((AnimationPoint)pZPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) + (firstPos ? 0.0f : bone.getPositionZ()));
                    snapshot.positionOffsetX = bone.getPositionX();
                    snapshot.positionOffsetY = bone.getPositionY();
                    snapshot.positionOffsetZ = bone.getPositionZ();
                    snapshot.isCurrentlyRunningPositionAnimation = true;
                    dirtyTracker.hasPositionChanged = true;
                    firstPos = false;
                }
                if (sXPoint == null || sYPoint == null || sZPoint == null) continue;
                bone.setScaleX(MathUtil.lerpValues((AnimationPoint)sXPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) * (firstScale ? 1.0f : bone.getScaleX()));
                bone.setScaleY(MathUtil.lerpValues((AnimationPoint)sYPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) * (firstScale ? 1.0f : bone.getScaleY()));
                bone.setScaleZ(MathUtil.lerpValues((AnimationPoint)sZPoint, (EasingType)controller.easingType, (Function)controller.customEasingMethod) * (firstScale ? 1.0f : bone.getScaleZ()));
                snapshot.scaleValueX = bone.getScaleX();
                snapshot.scaleValueY = bone.getScaleY();
                snapshot.scaleValueZ = bone.getScaleZ();
                snapshot.isCurrentlyRunningScaleAnimation = true;
                dirtyTracker.hasScaleChanged = true;
                firstScale = false;
            }
        }
    }
}

