/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.rei;

import com.github.teamfossilsarcheology.fossil.recipe.MultiOutputAndSlotsRecipe;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class MultiOutputDisplay
implements Display {
    protected final EntryIngredient input;
    protected final NavigableMap<Double, EntryIngredient> weightedOutputs;
    public final List<WeightedItem> outputs;
    @Nullable
    protected final class_2960 location;

    protected MultiOutputDisplay(MultiOutputAndSlotsRecipe recipe) {
        this(EntryIngredients.ofIngredient((class_1856)recipe.getInput()), MultiOutputDisplay.map(recipe.getWeightedOutputs()), recipe.method_8114());
    }

    private static NavigableMap<Double, EntryIngredient> map(NavigableMap<Double, class_1799> output) {
        TreeMap<Double, EntryIngredient> newMap = new TreeMap<Double, EntryIngredient>();
        output.forEach((aDouble, itemStack) -> newMap.put((Double)aDouble, EntryIngredients.of((class_1799)itemStack)));
        return newMap;
    }

    protected MultiOutputDisplay(EntryIngredient input, NavigableMap<Double, EntryIngredient> output, @Nullable class_2960 location) {
        this.input = input;
        this.weightedOutputs = output;
        this.location = location;
        Iterator iterator = this.weightedOutputs.entrySet().iterator();
        ArrayList<WeightedItem> newOutputs = new ArrayList<WeightedItem>();
        if (iterator.hasNext()) {
            double total = (Double)this.weightedOutputs.lastKey();
            Map.Entry entry = iterator.next();
            double previous = (Double)entry.getKey();
            newOutputs.add(new WeightedItem(previous / total * 100.0, (EntryIngredient)entry.getValue()));
            while (iterator.hasNext()) {
                entry = iterator.next();
                newOutputs.add(new WeightedItem(((Double)entry.getKey() - previous) / total * 100.0, (EntryIngredient)entry.getValue()));
                previous = (Double)entry.getKey();
            }
        }
        newOutputs.sort((o1, o2) -> DoubleComparators.OPPOSITE_COMPARATOR.compare(o1.probability, o2.probability));
        this.outputs = newOutputs;
    }

    public List<EntryIngredient> getInputEntries() {
        return Collections.singletonList(this.input);
    }

    public List<EntryIngredient> getOutputEntries() {
        return Lists.newArrayList(this.weightedOutputs.values());
    }

    public Optional<class_2960> getDisplayLocation() {
        return Optional.ofNullable(this.location);
    }

    public record WeightedItem(double probability, EntryIngredient item) {
    }

    public static class Serializer<T extends MultiOutputDisplay>
    implements DisplaySerializer<T> {
        protected final Constructor<T> constructor;

        protected Serializer(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        public class_2487 save(class_2487 tag, T display) {
            tag.method_10566("Input", (class_2520)((MultiOutputDisplay)display).input.saveIngredient());
            class_2499 weights = new class_2499();
            class_2499 items = new class_2499();
            for (Map.Entry entry : ((MultiOutputDisplay)display).weightedOutputs.entrySet()) {
                weights.add((Object)class_2489.method_23241((double)((Double)entry.getKey())));
                weights.add((Object)((EntryIngredient)entry.getValue()).saveIngredient());
            }
            tag.method_10566("Weights", (class_2520)weights);
            tag.method_10566("Items", (class_2520)items);
            tag.method_10582("Location", ((MultiOutputDisplay)display).location.toString());
            return tag;
        }

        public T read(class_2487 tag) {
            EntryIngredient input = EntryIngredient.read((class_2499)tag.method_10554("Input", 10));
            class_2499 weights = tag.method_10554("Weights", 6);
            class_2499 items = tag.method_10554("Items", 9);
            TreeMap<Double, EntryIngredient> weighted = new TreeMap<Double, EntryIngredient>();
            double total = 0.0;
            for (int i = 0; i < items.size(); ++i) {
                EntryIngredient item = EntryIngredient.read((class_2499)items.method_10603(i));
                if (item.isEmpty()) continue;
                weighted.put(total += weights.method_10611(i), item);
            }
            class_2960 location = new class_2960(tag.method_10558("Location"));
            return (T)((MultiOutputDisplay)this.constructor.construct(input, weighted, location));
        }

        @FunctionalInterface
        public static interface Constructor<R> {
            public R construct(EntryIngredient var1, NavigableMap<Double, EntryIngredient> var2, class_2960 var3);
        }
    }
}

