/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_7;
import net.minecraft.class_8;

public class DinoFollowOwnerGoal
extends class_1352 {
    private final Prehistoric dino;
    private final double speedModifier;
    private final double sprintModifier;
    private final float startDistanceSqr;
    private final float sprintDistanceSqr;
    private final float stopDistanceSqr;
    private final float teleportDistanceSqr;
    private final boolean canFly;
    private boolean shouldSprint;
    private class_1309 owner;
    private float oldWaterCost;
    private int timeToRecalcPath;

    public DinoFollowOwnerGoal(Prehistoric dino, double sprintModifier, float startDistance, float stopDistance, boolean canFly) {
        this(dino, sprintModifier, startDistance, stopDistance, 18.0f, canFly);
    }

    public DinoFollowOwnerGoal(Prehistoric dino, double sprintModifier, float startDistance, float stopDistance, float teleportDistance, boolean canFly) {
        this.dino = dino;
        this.speedModifier = 1.0;
        this.sprintModifier = sprintModifier;
        this.startDistanceSqr = startDistance * startDistance;
        this.sprintDistanceSqr = this.startDistanceSqr + 3.0f;
        this.stopDistanceSqr = stopDistance * stopDistance;
        this.teleportDistanceSqr = teleportDistance * teleportDistance;
        this.canFly = canFly;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 currentOwner = this.dino.method_6177();
        if (currentOwner == null || currentOwner.method_7325()) {
            return false;
        }
        if (this.dino.getCurrentOrder() != OrderType.FOLLOW) {
            return false;
        }
        if (this.dino.method_5858((class_1297)currentOwner) < (double)this.startDistanceSqr) {
            return false;
        }
        this.owner = currentOwner;
        return true;
    }

    public boolean method_6266() {
        if (this.dino.method_5942().method_6357() || this.dino.getCurrentOrder() != OrderType.FOLLOW) {
            return false;
        }
        return this.dino.method_5858((class_1297)this.owner) > (double)this.stopDistanceSqr;
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dino.method_5944(class_7.field_18);
        this.dino.method_5941(class_7.field_18, 0.0f);
        this.shouldSprint = this.dino.method_5858((class_1297)this.owner) >= (double)this.sprintDistanceSqr;
    }

    public void method_6270() {
        this.owner = null;
        this.dino.method_5942().method_6340();
        this.dino.method_5941(class_7.field_18, this.oldWaterCost);
    }

    public void method_6268() {
        this.dino.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dino.method_5978());
        --this.timeToRecalcPath;
        if (this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.method_38847(10);
        if (this.dino.method_5858((class_1297)this.owner) >= (double)this.sprintDistanceSqr) {
            this.shouldSprint = true;
        }
        if (!this.dino.method_5934() && this.dino.method_5858((class_1297)this.owner) >= (double)this.teleportDistanceSqr) {
            this.teleportToOwner();
            return;
        }
        this.dino.method_5942().method_6335((class_1297)this.owner, this.shouldSprint ? this.sprintModifier : this.speedModifier);
    }

    private void teleportToOwner() {
        class_2338 ownerBlockPos = this.owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = ownerBlockPos.method_10263() + this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(x, y = ownerBlockPos.method_10264() + this.randomIntInclusive(-1, 1), z = ownerBlockPos.method_10260() + this.randomIntInclusive(-3, 3))) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(x, y, z))) {
            return false;
        }
        this.dino.method_5808((double)x + 0.5, y, (double)z + 0.5, this.dino.method_36454(), this.dino.method_36455());
        this.dino.method_5942().method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 teleportPos) {
        class_1937 level = this.dino.method_37908();
        class_8 nodeEvaluator = this.dino.method_5942().method_6342();
        class_7 type = nodeEvaluator.method_17((class_1922)level, teleportPos.method_10263(), teleportPos.method_10264(), teleportPos.method_10260());
        if (type == class_7.field_18 && this.dino.method_5944(type) == 0.0f) {
            return level.method_8587((class_1297)this.dino, this.dino.method_5829().method_996(teleportPos.method_10059((class_2382)this.dino.method_24515())));
        }
        if (type != class_7.field_12) {
            return false;
        }
        if (!this.canFly && level.method_8320(teleportPos).method_26204() instanceof class_2397) {
            return false;
        }
        return level.method_8587((class_1297)this.dino, this.dino.method_5829().method_996(teleportPos.method_10059((class_2382)this.dino.method_24515())));
    }

    private int randomIntInclusive(int min, int max) {
        return this.dino.method_6051().nextInt(max - min + 1) + min;
    }
}

