/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import org.jetbrains.annotations.Nullable;

public class DinoMatingGoal
extends class_1352 {
    private final double speedModifier;
    private final Prehistoric male;
    private Prehistoric female;

    public DinoMatingGoal(Prehistoric dinosaur, double speed) {
        this.male = dinosaur;
        this.speedModifier = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!FossilConfig.isEnabled("breedingDinos")) {
            return false;
        }
        if (this.male.getGender() != Gender.MALE || !this.male.isAdult() || this.male.getMatingCooldown() > 0 || this.male.moodSystem.getMood() <= 50) {
            return false;
        }
        List<? extends Prehistoric> sameTypes = this.male.getNearbySpeciesMembers(64);
        if (sameTypes.size() + 1 >= this.male.data().maxPopulation()) {
            this.male.setMatingCooldown(this.male.method_6051().nextInt(5000) + 5000);
            return false;
        }
        double shortestDistance = Double.MAX_VALUE;
        for (Prehistoric prehistoric : sameTypes) {
            if (!this.male.method_6474((class_1429)prehistoric) || this.male.method_5858((class_1297)prehistoric) > shortestDistance) continue;
            this.female = prehistoric;
            shortestDistance = this.male.method_5858((class_1297)this.female);
        }
        return this.female != null;
    }

    public boolean method_6266() {
        return this.female.method_5805() && this.male.method_6474((class_1429)this.female);
    }

    public void method_6270() {
        this.female = null;
    }

    public void method_6268() {
        this.male.method_5988().method_6226((class_1297)this.female, 10.0f, (float)this.male.method_5978());
        this.male.method_5942().method_6335((class_1297)this.female, this.speedModifier);
        if (this.male.method_24516((class_1297)this.female, (double)this.male.method_17681() * 1.5)) {
            this.female.procreate(this.male);
            this.male.procreate(this.female);
            this.male.setMatingCooldown(this.male.method_6051().nextInt(6000) + 6000);
            this.female.setMatingCooldown(this.male.method_6051().nextInt(12000) + 24000);
        }
    }

    @Nullable
    public Prehistoric getPartner() {
        return this.female;
    }
}

