/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.control;

import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.S2CMarkMessage;
import com.github.teamfossilsarcheology.fossil.util.Version;
import net.minecraft.class_1335;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class CustomFlightMoveControl
extends SmoothTurningMoveControl {
    private final PrehistoricFlying mob;
    private boolean shouldLandAtTarget;
    private class_243 flyingWanted = class_243.field_1353;
    private int tick;
    private int lastStuckCheck;
    private class_243 lastStuckCheckPos = class_243.field_1353;

    public CustomFlightMoveControl(PrehistoricFlying mob) {
        super(mob);
        this.mob = mob;
    }

    public void setFlyingTarget(double x, double y, double z, boolean shouldLandAtTarget) {
        this.flyingWanted = new class_243(x, y, z);
        this.shouldLandAtTarget = shouldLandAtTarget;
        this.field_6372 = 1.0;
        if (Version.debugEnabled()) {
            int[] targets = new int[3];
            class_2680[] blocks = new class_2680[]{shouldLandAtTarget ? class_2246.field_10234.method_9564() : class_2246.field_10205.method_9564()};
            targets[0] = class_3532.method_15357((double)x);
            targets[1] = class_3532.method_15357((double)y);
            targets[2] = class_3532.method_15357((double)z);
            MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)((class_3218)this.mob.field_6002).method_18766(serverPlayer -> true), (Object)new S2CMarkMessage(targets, blocks, false));
        }
    }

    public void method_6239(double x, double y, double z, double speed) {
        super.method_6239(x, y, z, speed);
        if (this.mob.isUsingStuckNavigation()) {
            this.flyingWanted = new class_243(x, y, z);
        }
    }

    public void setOperation(class_1335.class_1336 operation) {
        this.field_6374 = operation;
    }

    @Override
    public void method_6240() {
        if (!this.mob.method_6581()) {
            this.mob.method_5875(false);
            super.method_6240();
        } else if (this.field_6374 == class_1335.class_1336.field_6378) {
            this.mob.method_5875(true);
            class_243 offset = this.flyingWanted.method_1020(this.mob.method_19538());
            double dist = offset.method_1033();
            if (dist > Math.min(1.5, (double)this.mob.method_17681())) {
                float initialYRot = this.mob.method_36454();
                float initialXRot = this.mob.method_36455();
                float initialYaw = Util.yRotToYaw(initialYRot);
                float targetYaw = (float)class_3532.method_15349((double)offset.field_1350, (double)offset.field_1352) * 57.295776f;
                float targetPitch = (float)class_3532.method_15349((double)(-offset.field_1351), (double)offset.method_37267()) * 57.295776f;
                float newYaw = class_3532.method_15388((float)initialYaw, (float)targetYaw, (float)4.0f);
                float newPitch = class_3532.method_15388((float)initialXRot, (float)targetPitch, (float)4.0f);
                this.mob.method_36456(Util.yawToYRot(newYaw));
                this.mob.field_6283 = this.mob.method_36454();
                this.mob.method_36457(newPitch);
                if (class_3532.method_15356((float)initialYRot, (float)this.mob.method_36454()) < 3.0f) {
                    float limit = 1.2f;
                    if (dist > 15.0) {
                        limit = 2.2f;
                    } else if (dist > 5.0) {
                        limit = 1.8f;
                    }
                    limit = this.shouldLandAtTarget ? limit * 0.8f : limit;
                    this.field_6372 = class_3532.method_15348((float)((float)this.field_6372), (float)limit, (float)((float)(0.05 * (1.8 / this.field_6372))));
                } else {
                    this.field_6372 = class_3532.method_15348((float)((float)this.field_6372), (float)0.2f, (float)0.025f);
                }
                double targetXMove = this.field_6372 * (double)class_3532.method_15362((float)(newYaw * ((float)Math.PI / 180))) * Math.abs(offset.field_1352 / dist);
                double targetYMove = this.field_6372 * (double)class_3532.method_15374((float)(-targetPitch * ((float)Math.PI / 180))) * Math.abs(offset.field_1351 / dist);
                double targetZMove = this.field_6372 * (double)class_3532.method_15374((float)(newYaw * ((float)Math.PI / 180))) * Math.abs(offset.field_1350 / dist);
                class_243 move = this.mob.method_18798();
                double newX = class_3532.method_15348((float)((float)move.field_1352), (float)((float)targetXMove), (float)0.01f);
                double newY = class_3532.method_15348((float)((float)move.field_1351), (float)((float)targetYMove), (float)0.01f);
                double newZ = class_3532.method_15348((float)((float)move.field_1350), (float)((float)targetZMove), (float)0.01f);
                this.mob.method_18800(newX, newY, newZ);
            } else {
                if (this.mob.isUsingStuckNavigation()) {
                    this.mob.switchNavigator(false);
                }
                if (this.shouldLandAtTarget) {
                    if (!this.mob.field_6002.method_22347(this.mob.method_24515().method_10074())) {
                        this.mob.onReachAirTarget(new class_2338(this.flyingWanted));
                        this.mob.setFlying(false);
                        this.field_6374 = class_1335.class_1336.field_6377;
                    }
                } else {
                    this.mob.onReachAirTarget(new class_2338(this.flyingWanted));
                    this.field_6374 = class_1335.class_1336.field_6377;
                }
            }
            if (this.mob.field_36331 && offset.field_1351 < 0.0) {
                if (!this.mob.isUsingStuckNavigation()) {
                    if (offset.method_37267() < 6.0 && offset.field_1351 > -3.0) {
                        this.mob.setFlying(false);
                        this.field_6374 = class_1335.class_1336.field_6377;
                        this.mob.moveTo(this.flyingWanted, true, false);
                    } else {
                        this.mob.doStuckNavigation(this.flyingWanted);
                    }
                }
            } else if (this.mob.field_5976 || this.mob.field_5992) {
                this.doStuckDetection(this.mob.method_19538());
            }
        } else {
            this.mob.method_5875(false);
        }
    }

    private void doStuckDetection(class_243 pos) {
        ++this.tick;
        if (this.tick - this.lastStuckCheck > 100) {
            if (pos.method_1025(this.lastStuckCheckPos) < 2.25) {
                if (this.mob.isUsingStuckNavigation()) {
                    this.mob.method_5942().method_6356();
                } else {
                    this.mob.doStuckNavigation(this.flyingWanted);
                }
            }
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = pos;
        }
    }
}

