/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming;

import com.github.teamfossilsarcheology.fossil.entity.ai.DinoHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.LeaveWaterGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class Spinosaurus
extends PrehistoricSwimming {
    public static final String GRAB = "animation.spinosaurus.grab";
    public static final String IDLE = "animation.spinosaurus.idle";
    public static final String IDLE_WATER = "animation.spinosaurus.idle_water";
    public static final String IDLE_WATER_FLOAT = "animation.spinosaurus.idle_water_float";
    public static final String SWIM_FLOATING = "animation.spinosaurus.swim_floating";
    public static final String SWIM_UNDERWATER = "animation.spinosaurus.swim_underwater";
    public static final String WALK_WATER = "animation.spinosaurus.walk_water";
    private final SpinoAnimationLogic animationLogic = new SpinoAnimationLogic(this);

    public Spinosaurus(class_1299<Spinosaurus> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(21, new LeaveWaterGoal<Spinosaurus>(this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new DinoOwnerHurtByTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new DinoOwnerHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new DinoHurtByTargetGoal(this));
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.SPINOSAURUS;
    }

    @Override
    public class_1792 getOrderItem() {
        return (class_1792)ModItems.SKULL_STICK.get();
    }

    @Override
    public float getTargetScale() {
        return 1.5f;
    }

    @Override
    public float grabTargetSize() {
        return this.method_17681();
    }

    @Override
    @NotNull
    public AnimationInfo nextGrabbingAnimation() {
        return this.getAllAnimations().get(GRAB);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)ModSounds.SPINOSAURUS_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)ModSounds.SPINOSAURUS_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)ModSounds.SPINOSAURUS_DEATH.get();
    }

    @Override
    public AnimationLogic<Prehistoric> getAnimationLogic() {
        return this.animationLogic;
    }

    @Override
    public void registerControllers(AnimationData data) {
        PausableAnimationController<Spinosaurus> controller = new PausableAnimationController<Spinosaurus>(this, "Movement/Idle", 5.0f, this.animationLogic::spinoPredicate);
        this.registerEatingListeners(controller);
        data.addAnimationController(controller);
        data.addAnimationController(new PausableAnimationController<Spinosaurus>(this, "Attack", 0.0f, this.getAnimationLogic()::grabAttackPredicate));
    }

    static class SpinoAnimationLogic
    extends AnimationLogic<Prehistoric> {
        public SpinoAnimationLogic(PrehistoricSwimming entity) {
            super(entity);
        }

        public PlayState spinoPredicate(AnimationEvent<PrehistoricSwimming> event) {
            if (this.isBlocked()) {
                return PlayState.STOP;
            }
            AnimationController controller = event.getController();
            if (this.tryNextAnimation(controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
            if (activeAnimation.isPresent() && this.tryForcedAnimation(event, activeAnimation.get())) {
                return PlayState.CONTINUE;
            }
            double animationSpeed = 1.0;
            if (((PrehistoricSwimming)event.getAnimatable()).isBeached()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.BEACHED);
            } else if (((Prehistoric)this.entity).method_6113()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (event.isMoving()) {
                if (((Prehistoric)this.entity).method_5799()) {
                    boolean onGround;
                    boolean bl = onGround = ((Prehistoric)this.entity).method_23318() - Math.floor(((Prehistoric)this.entity).method_23318()) < 0.05 && ((Prehistoric)this.entity).field_6002.method_8316(((Prehistoric)this.entity).method_24515().method_10074()).method_15769();
                    if (((Prehistoric)this.entity).method_5777(class_3486.field_15517)) {
                        if (onGround) {
                            this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.WALK_WATER).animation, AnimationCategory.SWIM, false);
                        } else {
                            this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.SWIM_UNDERWATER).animation, AnimationCategory.SWIM, false);
                        }
                    } else if (onGround) {
                        animationSpeed = this.addMovementAnimation(event, false);
                    } else {
                        this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.SWIM_FLOATING).animation, AnimationCategory.SWIM, false);
                    }
                } else {
                    animationSpeed = this.addMovementAnimation(event, false);
                }
            } else if (((PrehistoricSwimming)event.getAnimatable()).isWeak()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.KNOCKOUT);
            } else if (((Prehistoric)this.entity).method_5799()) {
                if (((Prehistoric)this.entity).method_5777(class_3486.field_15517)) {
                    this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE_WATER).animation, AnimationCategory.IDLE, false);
                } else {
                    this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE_WATER_FLOAT).animation, AnimationCategory.IDLE, false);
                }
            } else {
                this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE).animation, AnimationCategory.IDLE, false);
            }
            SpinoAnimationLogic.setAnimationSpeed(controller, animationSpeed, event.getAnimationTick());
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
            if (newAnimation.isPresent()) {
                controller.setAnimation(new AnimationBuilder().addAnimation(newAnimation.get().animationName(), (ILoopType)(newAnimation.get().loop() ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE)));
            }
            return PlayState.CONTINUE;
        }
    }
}

