/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import net.minecraft.class_2487;

public class SitSystem
extends AISystem {
    private int ticksSat;
    private int sitCooldown = 3600;

    public SitSystem(Prehistoric mob) {
        super(mob);
    }

    @Override
    public void serverTick() {
        if (this.sitCooldown > 0) {
            --this.sitCooldown;
        }
        if (!this.isSitting() && this.canSit() && (this.sitCooldown == 0 && this.mob.method_6051().nextInt(1000) == 0 || this.mob.getCurrentOrder() == OrderType.STAY)) {
            this.setSitting(true);
        }
        if (this.isSitting()) {
            ++this.ticksSat;
            if (this.mob.getCurrentOrder() != OrderType.STAY && (this.ticksSat > 300 && this.mob.method_6051().nextInt(100) == 0 || !this.canSit())) {
                this.setSitting(false);
            }
        }
    }

    protected boolean canSit() {
        if (this.isDisabled() || this.mob.hasTarget() || this.mob.method_5782() || this.mob.method_6065() != null || this.mob.getCurrentOrder() == OrderType.FOLLOW) {
            return false;
        }
        if (this.mob.isDeadlyHungry()) {
            return false;
        }
        if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC) {
            return this.mob.method_5799();
        }
        if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC) {
            return this.mob.method_5799() || this.mob.method_24828();
        }
        return this.mob.method_24828();
    }

    public boolean isSitting() {
        return (Boolean)this.mob.method_5841().method_12789(Prehistoric.SITTING);
    }

    public void setSitting(boolean sitting) {
        this.mob.method_5841().method_12778(Prehistoric.SITTING, (Object)sitting);
        if (sitting) {
            this.ticksSat = 0;
            this.mob.method_5942().method_6340();
            this.mob.method_18800(0.0, this.mob.method_18798().field_1351, 0.0);
        }
    }

    @Override
    public void saveAdditional(class_2487 tag) {
        tag.method_10556("Sitting", this.isSitting());
    }

    @Override
    public void load(class_2487 tag) {
        this.setSitting(tag.method_10577("Sitting"));
    }
}

