/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.util.DinopediaInfo;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3518;

public enum Diet implements DinopediaInfo
{
    CARNIVORE(FoodType.MEAT),
    HERBIVORE(FoodType.PLANT),
    OMNIVORE(FoodType.MEAT, FoodType.PLANT, FoodType.FISH),
    PISCIVORE(FoodType.FISH),
    CARNIVORE_EGG(FoodType.MEAT, FoodType.EGG),
    INSECTIVORE(FoodType.MEAT),
    PISCI_CARNIVORE(FoodType.MEAT, FoodType.FISH),
    PASSIVE(new FoodType[0]);

    private final class_2561 name = new class_2588("pedia.fossil.diet." + this.name().toLowerCase(Locale.ROOT));
    private final class_2561 description = new class_2588("pedia.fossil.diet." + this.name().toLowerCase(Locale.ROOT) + ".desc");
    private final Set<FoodType> flag;

    private Diet(FoodType ... types) {
        this.flag = types.length > 0 ? EnumSet.of(types[0], types) : EnumSet.noneOf(FoodType.class);
    }

    public boolean canEat(FoodType type) {
        return this.flag.contains((Object)type);
    }

    public Set<FoodType> flags() {
        return this.flag;
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public class_2561 getDescription() {
        return this.description;
    }

    public static Diet readBuf(class_2540 buf) {
        return Diet.valueOf(buf.method_19772());
    }

    public static void writeBuf(class_2540 buf, Diet diet) {
        buf.method_10814(diet.name());
    }

    public static class Deserializer
    implements JsonDeserializer<Diet> {
        public Diet deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Diet.valueOf(class_3518.method_15253((JsonObject)json.getAsJsonObject(), (String)"diet", (String)PASSIVE.name()));
        }
    }
}

