/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiOutputAndSlotsRecipeBuilder<T extends MultiOutputAndSlotsRecipeBuilder<T>>
implements class_5797 {
    protected final String modId;
    protected final class_1935 itemInput;
    protected final class_6862<class_1792> tagInput;
    protected final NavigableMap<ItemHolder, Double> weightedOutputs = new TreeMap<ItemHolder, Double>();
    public double total;

    protected MultiOutputAndSlotsRecipeBuilder(String modId, class_1935 itemInput) {
        this.modId = modId;
        this.itemInput = itemInput;
        this.tagInput = null;
    }

    protected MultiOutputAndSlotsRecipeBuilder(String modId, class_6862<class_1792> tagInput) {
        this.modId = modId;
        this.itemInput = null;
        this.tagInput = tagInput;
    }

    public T addOutput(class_1935 itemLike, double weight) {
        return this.addOutput(itemLike, 1, weight);
    }

    public T addOutput(class_1935 itemLike, int count, double weight) {
        this.total += weight;
        this.weightedOutputs.put(new ItemHolder(class_2378.field_11142.method_10221((Object)itemLike.method_8389()), count), weight);
        return (T)this;
    }

    @NotNull
    public class_5797 method_33530(String criterionName, class_184 criterionTrigger) {
        return this;
    }

    @NotNull
    public class_5797 method_33529(@Nullable String groupName) {
        return this;
    }

    @NotNull
    public class_1792 method_36441() {
        return class_1802.field_8634;
    }

    public void method_10431(@NotNull Consumer<class_2444> consumer) {
        this.method_17972(consumer, this.getDefaultRecipeId());
    }

    public void method_36443(@NotNull Consumer<class_2444> consumer, @NotNull String recipeId) {
        class_2960 resourceLocation2 = new class_2960(recipeId);
        class_2960 resourceLocation = this.getDefaultRecipeId();
        if (resourceLocation2.equals((Object)resourceLocation)) {
            throw new IllegalStateException("Recipe " + recipeId + " should remove its 'save' argument as it is equal to default one");
        }
        this.method_17972(consumer, resourceLocation2);
    }

    protected abstract class_2960 getDefaultRecipeId();

    public record ItemHolder(class_2960 location, int count) implements Comparable<ItemHolder>
    {
        @Override
        public int compareTo(@NotNull ItemHolder o) {
            return this.location.method_12832().compareTo(o.location.method_12832());
        }
    }

    public static abstract class Result
    implements class_2444 {
        private final class_2960 recipeLocation;
        private final class_1856 ingredient;
        private final NavigableMap<ItemHolder, Double> weightedOutputs;

        protected Result(class_2960 recipeLocation, class_1856 ingredient, NavigableMap<ItemHolder, Double> weightedOutputs) {
            this.recipeLocation = recipeLocation;
            this.ingredient = ingredient;
            this.weightedOutputs = weightedOutputs;
        }

        public void method_10416(JsonObject json) {
            json.add("input", this.ingredient.method_8089());
            JsonArray outputs = new JsonArray();
            for (Map.Entry output : this.weightedOutputs.entrySet()) {
                ItemHolder itemStack = (ItemHolder)output.getKey();
                JsonObject outputObject = new JsonObject();
                outputObject.addProperty("item", itemStack.location.toString());
                if (itemStack.count > 1) {
                    outputObject.addProperty("count", (Number)itemStack.count);
                }
                outputObject.addProperty("weight", (Number)output.getValue());
                outputs.add((JsonElement)outputObject);
            }
            json.add("outputs", (JsonElement)outputs);
        }

        @NotNull
        public class_2960 method_10417() {
            return this.recipeLocation;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

