/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class CalamitesTreeFeature
extends CustomTreeFeature {
    @Override
    protected boolean placeTree(class_5821<class_3111> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        int treeHeight = context.method_33654().nextInt(15) + 15;
        int m = this.getMaxFreeTreeHeight((class_3746)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        class_2680 log = ((class_2465)ModBlocks.CALAMITES_LOG.get()).method_9564();
        class_2680 leaves = ((class_2397)ModBlocks.CALAMITES_LEAVES.get()).method_9564();
        class_2338 canopyCenter = pos.method_10084();
        int minWidth = 2;
        int maxWidth = 4;
        float widthStep = (float)(maxWidth - minWidth) / (float)treeHeight;
        while (canopyCenter.method_10264() < pos.method_10086(treeHeight - 1).method_10264()) {
            int difference = pos.method_10086(treeHeight).method_10264() - canopyCenter.method_10264();
            float canopyWidth = (float)minWidth + widthStep * (float)difference;
            if (difference > 4) {
                canopyCenter = canopyCenter.method_10086(4);
                this.genCircle(level, canopyCenter, canopyWidth - 2.0f, false);
                this.genCircle(level, canopyCenter.method_10084(), canopyWidth - 1.0f, false);
                level.method_8652(canopyCenter.method_10095(), (class_2680)log.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051), 19);
                level.method_8652(canopyCenter.method_10067(), (class_2680)log.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048), 19);
                level.method_8652(canopyCenter.method_10078(), (class_2680)log.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048), 19);
                level.method_8652(canopyCenter.method_10072(), (class_2680)log.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051), 19);
                this.genCircle(level, canopyCenter.method_10086(2), canopyWidth, true);
                this.genCircle(level, canopyCenter.method_10086(3), canopyWidth + 1.0f, true);
                continue;
            }
            class_2338.class_2339 topBlocks = canopyCenter.method_10086(difference).method_25503();
            level.method_8652((class_2338)topBlocks, log, 19);
            level.method_8652((class_2338)topBlocks.method_10104(class_2350.field_11036, 1), log, 19);
            level.method_8652((class_2338)topBlocks.method_10104(class_2350.field_11036, 1), log, 19);
            this.placeLeaf(level, topBlocks.method_10095(), leaves);
            this.placeLeaf(level, topBlocks.method_10067(), leaves);
            this.placeLeaf(level, topBlocks.method_10078(), leaves);
            this.placeLeaf(level, topBlocks.method_10072(), leaves);
            this.placeLeaf(level, (class_2338)topBlocks.method_10104(class_2350.field_11036, 1), leaves);
            canopyCenter = canopyCenter.method_10086(4);
        }
        for (int i = 0; i < treeHeight; ++i) {
            level.method_8652(pos.method_10086(i), log, 19);
        }
        return true;
    }

    private void genCircle(class_5281 level, class_2338 pos, float size, boolean spikes) {
        class_2680 leaves = ((class_2397)ModBlocks.CALAMITES_LEAVES.get()).method_9564();
        for (class_2338 blockpos : class_2338.method_10097((class_2338)pos.method_10080((double)(-size), 0.0, (double)(-size)), (class_2338)pos.method_10080((double)size, 0.0, (double)size))) {
            int distanceX = Math.abs(blockpos.method_10263() - pos.method_10263());
            int distanceZ = Math.abs(blockpos.method_10260() - pos.method_10260());
            if (spikes) {
                boolean corner = blockpos.method_10263() == pos.method_10263() || blockpos.method_10260() == pos.method_10260() || distanceX == distanceZ;
                if (!corner || !(blockpos.method_10262((class_2382)pos) > (double)(size - 1.0f) * (double)(size - 1.0f)) || !(blockpos.method_10262((class_2382)pos) <= (double)(size * size))) continue;
                this.placeLeaf(level, blockpos, leaves);
                continue;
            }
            if (!(blockpos.method_10262((class_2382)pos) <= (double)(size * size))) continue;
            this.placeLeaf(level, blockpos, leaves);
        }
    }
}

