/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.CultureVatBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.EnergyContainerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.inventory.CultureVatMenu;
import com.github.teamfossilsarcheology.fossil.recipe.CultureVatRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import com.github.teamfossilsarcheology.fossil.recipe.WithFuelRecipe;
import com.github.teamfossilsarcheology.fossil.tags.ModItemTags;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CultureVatBlockEntity
extends EnergyContainerBlockEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return CultureVatBlockEntity.this.litTime;
                }
                case 1: {
                    return CultureVatBlockEntity.this.litDuration;
                }
                case 2: {
                    return CultureVatBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return CultureVatBlockEntity.this.energyStorage.getEnergy();
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CultureVatBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    CultureVatBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    CultureVatBlockEntity.this.cookingProgress = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    protected class_2371<class_1799> items = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private class_1799 fuel = class_1799.field_8037;

    public CultureVatBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.CULTURE_VAT.get(), blockPos, blockState);
    }

    public static int getItemFuelTime(class_1799 stack) {
        return ModRecipes.getCultureVatFuelValue((class_1935)stack.method_7909());
    }

    @Override
    public class_3913 getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_2499 listTag = tag.method_10554("FuelItem", 10);
        if (!listTag.isEmpty()) {
            this.fuel = class_1799.method_7915((class_2487)listTag.method_10602(0));
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2499 listTag = new class_2499();
        listTag.add((Object)this.fuel.method_7953(new class_2487()));
        tag.method_10566("FuelItem", (class_2520)listTag);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, CultureVatBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (FossilConfig.isEnabled("machinesRequireEnergy") && this.energyStorage.getEnergy() <= 0) {
            if (this.cookingProgress > 0) {
                this.cookingProgress = class_3532.method_15340((int)(this.cookingProgress - 2), (int)0, (int)CultureVatMenu.CULTIVATION_DURATION);
            }
            return;
        }
        int prevCookingProgress = this.cookingProgress;
        boolean wasFueled = this.litTime > 0;
        boolean wasProcessing = this.cookingProgress > 0;
        boolean dirty = false;
        if (this.litTime > 0) {
            --this.litTime;
        }
        if (this.canProcess() && (this.litTime == 0 || this.litTime > 0 && !this.canProcess(this.fuel))) {
            class_1799 fuelStack = (class_1799)this.items.get(1);
            this.litDuration = this.litTime = CultureVatBlockEntity.getItemFuelTime(fuelStack);
            this.fuel = fuelStack.method_7972();
            if (this.litTime > 0) {
                dirty = true;
                fuelStack.method_7934(1);
                if (fuelStack.method_7960() && fuelStack.method_7909().method_7857()) {
                    this.items.set(1, (Object)new class_1799((class_1935)fuelStack.method_7909().method_7858()));
                }
            }
        }
        if (this.litTime > 0 && this.canProcess(this.fuel)) {
            ++this.cookingProgress;
            if (this.cookingProgress >= CultureVatMenu.CULTIVATION_DURATION) {
                this.cookingProgress = 0;
                this.createItem();
                dirty = true;
            }
        }
        if (prevCookingProgress != this.cookingProgress && FossilConfig.isEnabled("machinesRequireEnergy")) {
            this.energyStorage.extractEnergy(FossilConfig.getInt("machineEnergyUsage"));
        }
        if (this.litTime == 0 && this.cookingProgress > 0 || this.litTime > 0 && this.cookingProgress > 0 && !this.canProcess(this.fuel)) {
            this.cookingProgress = class_3532.method_15340((int)(this.cookingProgress - 2), (int)0, (int)CultureVatMenu.CULTIVATION_DURATION);
        }
        if (wasFueled != this.litTime > 0) {
            dirty = true;
            state = (class_2680)state.method_11657((class_2769)CultureVatBlock.ACTIVE, (Comparable)Boolean.valueOf(this.litTime > 0));
            level.method_8652(pos, state, 3);
        }
        if (wasProcessing != this.cookingProgress > 0) {
            dirty = true;
            state = (class_2680)state.method_11657(CultureVatBlock.EMBRYO, (Comparable)((Object)this.getDNAType()));
            level.method_8652(pos, state, 3);
        }
        if (dirty) {
            CultureVatBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
        if (this.cookingProgress == 3001 && level.method_8409().method_43048(100) < FossilConfig.getInt("cultureVatFailChance")) {
            ((CultureVatBlock)((Object)ModBlocks.CULTURE_VAT.get())).onFailedCultivation(level, pos);
        }
    }

    public CultureVatBlock.EmbryoType getDNAType() {
        class_1799 input = (class_1799)this.items.get(0);
        if (input.method_7960()) {
            return CultureVatBlock.EmbryoType.NONE;
        }
        if (input.method_31573(ModItemTags.FOSSIL_SAPLINGS)) {
            return CultureVatBlock.EmbryoType.TREE;
        }
        if (input.method_31573(ModItemTags.DNA_PLANTS)) {
            return CultureVatBlock.EmbryoType.PLANT;
        }
        if (input.method_31573(ModItemTags.DNA_LIMBLESS)) {
            return CultureVatBlock.EmbryoType.LIMBLESS;
        }
        if (input.method_31573(ModItemTags.DNA_INSECTS)) {
            return CultureVatBlock.EmbryoType.INSECT;
        }
        return CultureVatBlock.EmbryoType.GENERIC;
    }

    private boolean isValidInput(class_1799 inputStack, class_1799 fuelStack) {
        CultureVatRecipe recipe = ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(inputStack, fuelStack), this.field_11863);
        if (recipe != null) {
            class_1799 output = (class_1799)this.items.get(2);
            return output.method_7960() || output.method_7962(recipe.method_8110());
        }
        return false;
    }

    protected boolean canProcess(class_1799 fuelStack) {
        if (FossilConfig.isEnabled("machinesRequireEnergy") && this.energyStorage.getEnergy() <= FossilConfig.getInt("machineEnergyUsage")) {
            return false;
        }
        class_1799 inputStack = (class_1799)this.items.get(0);
        if (!inputStack.method_7960() && !fuelStack.method_7960()) {
            return this.isValidInput(inputStack, fuelStack);
        }
        return false;
    }

    @Override
    protected boolean canProcess() {
        return this.canProcess((class_1799)this.items.get(1));
    }

    @Override
    protected void createItem() {
        if (this.canProcess(this.fuel)) {
            class_1799 inputStack = (class_1799)this.items.get(0);
            CultureVatRecipe recipe = ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(inputStack, this.fuel), this.field_11863);
            class_1799 result = recipe.method_8110();
            class_1799 output = (class_1799)this.items.get(2);
            if (output.method_7960()) {
                this.items.set(2, (Object)result);
            } else if (output.method_7962(result)) {
                output.method_7933(result.method_7947());
            }
            ((class_1799)this.items.get(0)).method_7934(1);
        }
    }

    @Override
    @NotNull
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.fossil.culture_vat");
    }

    @NotNull
    protected class_1703 method_5465(int containerId, @NotNull class_1661 inventory) {
        return new CultureVatMenu(containerId, inventory, this, this.dataAccess);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 current = (class_1799)this.items.get(slot);
        boolean sameItems = !stack.method_7960() && stack.method_7962(current) && class_1799.method_7975((class_1799)stack, (class_1799)current);
        this.items.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (slot == 0 && !sameItems) {
            this.cookingProgress = 0;
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(CultureVatBlock.EMBRYO, (Comparable)((Object)this.getDNAType())), 3);
            this.method_5431();
        }
    }

    public boolean method_5437(int index, @NotNull class_1799 stack) {
        if (index == 2) {
            return false;
        }
        if (index == 1) {
            return ModRecipes.isCultureVatFuel((class_1935)stack.method_7909());
        }
        return ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(true, stack), this.field_11863) != null;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return side == class_2350.field_11033 ? SLOTS_FOR_DOWN : (side == class_2350.field_11036 ? SLOTS_FOR_UP : SLOTS_FOR_SIDES);
    }

    public boolean method_5492(int index, @NotNull class_1799 itemStack, @Nullable class_2350 direction) {
        return this.method_5437(index, itemStack);
    }

    public boolean method_5493(int index, @NotNull class_1799 stack, @NotNull class_2350 direction) {
        return direction != class_2350.field_11036 && index == 2;
    }
}

