/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_7919;

public class EggTab
extends DebugTab<DinosaurEgg> {
    private int hatchingTime;
    private double scaleOverride;

    protected EggTab(DebugScreen debugScreen, DinosaurEgg entity) {
        super(debugScreen, entity);
        this.hatchingTime = entity.getHatchingTime();
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        int yPos = 0;
        final EntityDataLoader.Data data = EntityDataLoader.INSTANCE.getData(((DinosaurEgg)this.entity).getPrehistoricEntityInfo().resourceName);
        DebugSlider hatchingTimeSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)class_2561.method_43470((String)"Hatching time in ticks: "), (class_2561)class_2561.method_43470((String)""), 0.0, ((DinosaurEgg)this.entity).getTotalHatchingTime(), ((DinosaurEgg)this.entity).getHatchingTime(), 5.0, 0, true){

            @Override
            protected void method_25344() {
                EggTab.this.hatchingTime = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        DebugSlider scaleSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)class_2561.method_43470((String)"Scale: "), (class_2561)class_2561.method_43470((String)""), 0.05, Math.max(2.0f, data.eggScale()), data.eggScale(), 0.05, 2, true){

            @Override
            protected void method_25344() {
                EggTab.this.scaleOverride = this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize);
                ((DinosaurEgg)EggTab.this.entity).setScaleOverride((float)EggTab.this.scaleOverride);
            }

            public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
                super.method_25394(poseStack, mouseX, mouseY, partialTick);
                int j = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
                String currentEggScale = String.valueOf(data.eggScale());
                int currentScaleX = (int)(((double)data.eggScale() - this.minValue) / (this.maxValue - this.minValue) * (double)(this.field_22758 - EggTab.this.minecraft.field_1772.method_1727(currentEggScale)));
                2.method_25303((class_4587)poseStack, (class_327)EggTab.this.minecraft.field_1772, (String)currentEggScale, (int)(this.method_46426() + currentScaleX), (int)(this.method_46427() - 8), (int)(j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
            }
        };
        this.addWidget(hatchingTimeSlider);
        this.addWidget(scaleSlider);
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Set Info"), button -> {
            ((DinosaurEgg)this.entity).setScaleOverride(-1.0f);
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new SyncDebugInfoMessage(((DinosaurEgg)this.entity).method_5628(), "", this.hatchingTime, 0, 0, 0, 0, 0));
        }).method_46434(20, yPos += 30, 150, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Set the info above on the server"))).method_46431());
    }
}

