/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1950;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3614;
import net.minecraft.class_3922;
import net.minecraft.class_4459;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class PlayerNodeEvaluator {
    protected class_1950 level;
    protected class_1657 player;
    protected final Int2ObjectMap<class_9> nodes = new Int2ObjectOpenHashMap();
    protected int entityWidth;
    protected int entityHeight;
    protected int entityDepth;
    protected boolean canPassDoors;
    protected boolean canOpenDoors;
    protected boolean canFloat;
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    protected float oldWaterCost;
    private final Long2ObjectMap<class_7> pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<class_238> collisionCache = new Object2BooleanOpenHashMap();

    public void prepare(class_1950 l, class_1657 p) {
        this.level = l;
        this.player = p;
        this.nodes.clear();
        this.entityWidth = class_3532.method_15375((float)(PathingRenderer.getBbWidth() + 1.0f));
        this.entityHeight = class_3532.method_15375((float)(PathingRenderer.getBbHeight() + 1.0f));
        this.entityDepth = class_3532.method_15375((float)(PathingRenderer.getBbWidth() + 1.0f));
        this.oldWaterCost = PathingDebug.getPathfindingMalus(class_7.field_18);
    }

    public void done() {
        PathingDebug.setPathfindingMalus(class_7.field_18, this.oldWaterCost);
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        this.level = null;
        this.player = null;
    }

    protected class_9 getNode(class_2338 pos) {
        return this.getNode(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    protected class_9 getNode(int x, int y, int z) {
        return (class_9)this.nodes.computeIfAbsent(class_9.method_30((int)x, (int)y, (int)z), l -> new class_9(x, y, z));
    }

    public class_9 getStart() {
        int i = class_3532.method_15357((double)((double)PathingDebug.pos1.method_10264() + 0.5));
        class_7 blockPathTypes = this.getCachedBlockType(this.player, PathingDebug.pos1.method_10263(), i, PathingDebug.pos1.method_10260());
        if (PathingDebug.getPathfindingMalus(blockPathTypes) < 0.0f) {
            class_238 aABB = PathingRenderer.getBigHitbox().method_996(PathingDebug.pos1);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            if (this.hasPositiveMalus((class_2338)mutableBlockPos.method_10102(aABB.field_1323, (double)i, aABB.field_1321)) || this.hasPositiveMalus((class_2338)mutableBlockPos.method_10102(aABB.field_1323, (double)i, aABB.field_1324)) || this.hasPositiveMalus((class_2338)mutableBlockPos.method_10102(aABB.field_1320, (double)i, aABB.field_1321)) || this.hasPositiveMalus((class_2338)mutableBlockPos.method_10102(aABB.field_1320, (double)i, aABB.field_1324))) {
                class_9 node = this.getNode((class_2338)mutableBlockPos);
                node.field_41 = this.getBlockPathType(this.player, node.method_22879());
                node.field_43 = PathingDebug.getPathfindingMalus(node.field_41);
                return node;
            }
        }
        class_9 node2 = this.getNode(PathingDebug.pos1.method_10263(), i, PathingDebug.pos1.method_10260());
        node2.field_41 = this.getBlockPathType(this.player, node2.method_22879());
        node2.field_43 = PathingDebug.getPathfindingMalus(node2.field_41);
        return node2;
    }

    protected boolean hasPositiveMalus(class_2338 pos) {
        class_7 blockPathTypes = this.getBlockPathType(this.player, pos);
        return PathingDebug.getPathfindingMalus(blockPathTypes) >= 0.0f;
    }

    public class_4459 getGoal(double x, double y, double z) {
        return new class_4459(this.getNode(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z)));
    }

    public int getBlockedNeighbors(class_9[] nodes, class_9 start, class_2338[] neighborsX) {
        double d = this.getFloorLevel(new class_2338(start.field_40, start.field_39, start.field_38));
        int count = 0;
        int countX = 0;
        for (int i = 0; i < this.entityWidth; ++i) {
            for (int j = 0; j < this.entityHeight; ++j) {
                for (int k = 0; k < this.entityDepth; ++k) {
                    class_9 node = this.findBlockedNode(start.field_40 + i, start.field_39 + j, start.field_38 + k, d);
                    if (node != null) {
                        nodes[count++] = node;
                        continue;
                    }
                    neighborsX[countX++] = new class_2338(start.field_40 + i, start.field_39 + j, start.field_38 + k);
                }
            }
        }
        return count;
    }

    public int getNeighbors(class_9[] nodes, class_9 node) {
        class_9 node9;
        class_9 node8;
        class_9 node7;
        class_9 node6;
        class_9 node5;
        class_9 node4;
        class_9 node3;
        double d;
        class_9 node2;
        int i = 0;
        int j = 0;
        class_7 blockTypeAbove = this.getCachedBlockType(this.player, node.field_40, node.field_39 + 1, node.field_38);
        class_7 blockType = this.getCachedBlockType(this.player, node.field_40, node.field_39, node.field_38);
        if (PathingDebug.getPathfindingMalus(blockTypeAbove) >= 0.0f && blockType != class_7.field_21326) {
            j = class_3532.method_15375((float)Math.max(1.0f, this.player.field_6013));
        }
        if (this.isNeighborValid(node2 = this.findAcceptedNode(node.field_40, node.field_39, node.field_38 + 1, j, d = this.getFloorLevel(new class_2338(node.field_40, node.field_39, node.field_38)), class_2350.field_11035, blockType), node)) {
            nodes[i++] = node2;
        }
        if (this.isNeighborValid(node3 = this.findAcceptedNode(node.field_40 - 1, node.field_39, node.field_38, j, d, class_2350.field_11039, blockType), node)) {
            nodes[i++] = node3;
        }
        if (this.isNeighborValid(node4 = this.findAcceptedNode(node.field_40 + 1, node.field_39, node.field_38, j, d, class_2350.field_11034, blockType), node)) {
            nodes[i++] = node4;
        }
        if (this.isNeighborValid(node5 = this.findAcceptedNode(node.field_40, node.field_39, node.field_38 - 1, j, d, class_2350.field_11043, blockType), node)) {
            nodes[i++] = node5;
        }
        if (this.isDiagonalValid(node, node3, node5, node6 = this.findAcceptedNode(node.field_40 - 1, node.field_39, node.field_38 - 1, j, d, class_2350.field_11043, blockType))) {
            nodes[i++] = node6;
        }
        if (this.isDiagonalValid(node, node4, node5, node7 = this.findAcceptedNode(node.field_40 + 1, node.field_39, node.field_38 - 1, j, d, class_2350.field_11043, blockType))) {
            nodes[i++] = node7;
        }
        if (this.isDiagonalValid(node, node3, node2, node8 = this.findAcceptedNode(node.field_40 - 1, node.field_39, node.field_38 + 1, j, d, class_2350.field_11035, blockType))) {
            nodes[i++] = node8;
        }
        if (this.isDiagonalValid(node, node4, node2, node9 = this.findAcceptedNode(node.field_40 + 1, node.field_39, node.field_38 + 1, j, d, class_2350.field_11035, blockType))) {
            nodes[i++] = node9;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable class_9 node, class_9 node2) {
        return node != null && !node.field_42 && (node.field_43 >= 0.0f || node2.field_43 < 0.0f);
    }

    protected boolean isDiagonalValid(class_9 node, @Nullable class_9 node2, @Nullable class_9 node3, @Nullable class_9 node4) {
        if (node4 == null || node3 == null || node2 == null) {
            return false;
        }
        if (node4.field_42) {
            return false;
        }
        if (node3.field_39 > node.field_39 || node2.field_39 > node.field_39) {
            return false;
        }
        if (node2.field_41 == class_7.field_26446 || node3.field_41 == class_7.field_26446 || node4.field_41 == class_7.field_26446) {
            return false;
        }
        boolean bl = node3.field_41 == class_7.field_10 && node2.field_41 == class_7.field_10 && (double)PathingRenderer.getBbWidth() < 0.5;
        return node4.field_43 >= 0.0f && (node3.field_39 < node.field_39 || node3.field_43 >= 0.0f || bl) && (node2.field_39 < node.field_39 || node2.field_43 >= 0.0f || bl);
    }

    private boolean canReachWithoutCollision(class_9 node) {
        class_243 vec3 = new class_243((double)node.field_40 - this.player.method_23317(), (double)node.field_39 - this.player.method_23318(), (double)node.field_38 - this.player.method_23321());
        class_238 aABB = this.player.method_5829();
        int i = class_3532.method_15384((double)(vec3.method_1033() / aABB.method_995()));
        vec3 = vec3.method_1021((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(aABB = aABB.method_997(vec3))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(class_2338 pos) {
        return PlayerNodeEvaluator.getFloorLevel((class_1922)this.level, pos);
    }

    public static double getFloorLevel(class_1922 level, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        class_265 voxelShape = level.method_8320(blockPos).method_26220(level, blockPos);
        return (double)blockPos.method_10264() + (voxelShape.method_1110() ? 0.0 : voxelShape.method_1105(class_2350.class_2351.field_11052));
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected class_9 findBlockedNode(int x, int y, int z, double d) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        double e = this.getFloorLevel((class_2338)mutableBlockPos.method_10103(x, y, z));
        if ((double)y - d > (double)this.entityHeight && e - d > 1.125) {
            return null;
        }
        class_7 blockPathType = this.getBlockPathType((class_1922)this.level, x, y, z);
        blockPathType = this.evaluateBlockPathType((class_1922)this.level, this.canOpenDoors, false, class_2338.field_10980, blockPathType);
        class_9 node = this.getNode(x, y, z);
        node.field_42 = true;
        node.field_41 = blockPathType;
        node.field_43 = blockPathType.method_11();
        return node;
    }

    @Nullable
    protected class_9 findAcceptedNode(int x, int y, int z, int i, double d, class_2350 direction, class_7 blockPathTypes) {
        double j;
        double h;
        class_9 node = null;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        double e = this.getFloorLevel((class_2338)mutableBlockPos.method_10103(x, y, z));
        if (e - d > (double)this.entityHeight && e - d > 1.125) {
            return null;
        }
        class_7 blockPathTypes2 = this.getCachedBlockType(this.player, x, y, z);
        float f = PathingDebug.getPathfindingMalus(blockPathTypes2);
        double g = (double)PathingRenderer.getBbWidth() / 2.0;
        if (f >= 0.0f) {
            node = this.getNode(x, y, z);
            node.field_41 = blockPathTypes2;
            node.field_43 = Math.max(node.field_43, f);
        }
        if (blockPathTypes == class_7.field_10 && node != null && node.field_43 >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (blockPathTypes2 == class_7.field_12 || this.isAmphibious() && blockPathTypes2 == class_7.field_18) {
            return node;
        }
        if ((node == null || node.field_43 < 0.0f) && i > 0 && blockPathTypes2 != class_7.field_10 && blockPathTypes2 != class_7.field_25418 && blockPathTypes2 != class_7.field_19 && blockPathTypes2 != class_7.field_33534 && (node = this.findAcceptedNode(x, y + 1, z, i - 1, d, direction, blockPathTypes)) != null && (node.field_41 == class_7.field_7 || node.field_41 == class_7.field_12) && PathingRenderer.getBbWidth() < 1.0f && this.hasCollisions(new class_238((h = (double)(x - direction.method_10148()) + 0.5) - g, PlayerNodeEvaluator.getFloorLevel((class_1922)this.level, (class_2338)mutableBlockPos.method_10102(h, (double)(y + 1), j = (double)(z - direction.method_10165()) + 0.5)) + 0.001, j - g, h + g, (double)PathingRenderer.getBbHeight() + PlayerNodeEvaluator.getFloorLevel((class_1922)this.level, (class_2338)mutableBlockPos.method_10102((double)node.field_40, (double)node.field_39, (double)node.field_38)) - 0.002, j + g))) {
            node = null;
        }
        if (!this.isAmphibious() && blockPathTypes2 == class_7.field_18 && !this.canFloat()) {
            if (this.getCachedBlockType(this.player, x, y - 1, z) != class_7.field_18) {
                return node;
            }
            while (y > this.player.field_6002.method_31607()) {
                if ((blockPathTypes2 = this.getCachedBlockType(this.player, x, --y, z)) == class_7.field_18) {
                    node = this.getNode(x, y, z);
                    node.field_41 = blockPathTypes2;
                    node.field_43 = Math.max(node.field_43, PathingDebug.getPathfindingMalus(blockPathTypes2));
                    continue;
                }
                return node;
            }
        }
        if (blockPathTypes2 == class_7.field_7) {
            int k = 0;
            int l = y;
            while (blockPathTypes2 == class_7.field_7) {
                if (--y < this.player.field_6002.method_31607()) {
                    class_9 node2 = this.getNode(x, l, z);
                    node2.field_41 = class_7.field_22;
                    node2.field_43 = -1.0f;
                    return node2;
                }
                if (k++ >= this.player.method_5850()) {
                    class_9 node2 = this.getNode(x, y, z);
                    node2.field_41 = class_7.field_22;
                    node2.field_43 = -1.0f;
                    return node2;
                }
                blockPathTypes2 = this.getCachedBlockType(this.player, x, y, z);
                f = PathingDebug.getPathfindingMalus(blockPathTypes2);
                if (blockPathTypes2 != class_7.field_7 && f >= 0.0f) {
                    node = this.getNode(x, y, z);
                    node.field_41 = blockPathTypes2;
                    node.field_43 = Math.max(node.field_43, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                class_9 node2 = this.getNode(x, y, z);
                node2.field_41 = class_7.field_22;
                node2.field_43 = -1.0f;
                return node2;
            }
        }
        if (blockPathTypes2 == class_7.field_10) {
            node = this.getNode(x, y, z);
            node.field_42 = true;
            node.field_41 = blockPathTypes2;
            node.field_43 = blockPathTypes2.method_11();
        }
        return node;
    }

    private boolean hasCollisions(class_238 aABB) {
        return this.collisionCache.computeIfAbsent((Object)aABB, object -> !this.level.method_8587((class_1297)this.player, aABB));
    }

    public class_7 getBlockPathType(class_1922 blockaccess, int x, int y, int z, class_1657 entityliving, int xSize, int ySize, int zSize, boolean canBreakDoors, boolean canEnterDoors) {
        EnumSet<class_7> enumSet = EnumSet.noneOf(class_7.class);
        class_7 blockPathTypes = class_7.field_22;
        class_2338 blockPos = entityliving.method_24515();
        blockPathTypes = this.getBlockPathTypes(blockaccess, x, y, z, xSize, ySize, zSize, canBreakDoors, canEnterDoors, enumSet, blockPathTypes, blockPos);
        if (enumSet.contains(class_7.field_10)) {
            return class_7.field_10;
        }
        if (enumSet.contains(class_7.field_25418)) {
            return class_7.field_25418;
        }
        class_7 blockPathTypes2 = class_7.field_22;
        for (class_7 blockPathTypes3 : enumSet) {
            if (PathingDebug.getPathfindingMalus(blockPathTypes3) < 0.0f) {
                return blockPathTypes3;
            }
            if (PathingDebug.getPathfindingMalus(blockPathTypes3) < PathingDebug.getPathfindingMalus(blockPathTypes2)) continue;
            blockPathTypes2 = blockPathTypes3;
        }
        if (blockPathTypes == class_7.field_7 && PathingDebug.getPathfindingMalus(blockPathTypes2) == 0.0f && xSize <= 1) {
            return class_7.field_7;
        }
        return blockPathTypes2;
    }

    public class_7 getBlockPathTypes(class_1922 level, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoors, boolean canEnterDoors, EnumSet<class_7> nodeTypeEnum, class_7 nodeType, class_2338 pos) {
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int m = j + y;
                    int n = k + z;
                    class_7 blockPathTypes = this.getBlockPathType(level, l, m, n);
                    blockPathTypes = this.evaluateBlockPathType(level, canOpenDoors, canEnterDoors, pos, blockPathTypes);
                    if (i == 0 && j == 0 && k == 0) {
                        nodeType = blockPathTypes;
                    }
                    nodeTypeEnum.add(blockPathTypes);
                }
            }
        }
        return nodeType;
    }

    protected class_7 evaluateBlockPathType(class_1922 level, boolean canOpenDoors, boolean canEnterDoors, class_2338 pos, class_7 nodeType) {
        if (nodeType == class_7.field_23 && canOpenDoors && canEnterDoors) {
            nodeType = class_7.field_26446;
        }
        if (nodeType == class_7.field_15 && !canEnterDoors) {
            nodeType = class_7.field_22;
        }
        if (nodeType == class_7.field_21 && !(level.method_8320(pos).method_26204() instanceof class_2241) && !(level.method_8320(pos.method_10074()).method_26204() instanceof class_2241)) {
            nodeType = class_7.field_25418;
        }
        if (nodeType == class_7.field_6) {
            nodeType = class_7.field_22;
        }
        return nodeType;
    }

    private class_7 getBlockPathType(class_1657 entityliving, class_2338 pos) {
        return this.getCachedBlockType(entityliving, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    protected class_7 getCachedBlockType(class_1657 entity, int x, int y, int z) {
        return (class_7)this.pathTypesByPosCache.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), l -> this.getBlockPathType((class_1922)this.level, x, y, z, entity, this.entityWidth, this.entityHeight, this.entityDepth, this.canOpenDoors(), this.canPassDoors()));
    }

    public class_7 getBlockPathType(class_1922 level, int x, int y, int z) {
        return PlayerNodeEvaluator.getBlockPathTypeStatic(level, new class_2338.class_2339(x, y, z));
    }

    public static class_7 getBlockPathTypeStatic(class_1922 level, class_2338.class_2339 pos) {
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        class_7 blockPathTypes = PlayerNodeEvaluator.getBlockPathTypeRaw(level, (class_2338)pos);
        if (blockPathTypes == class_7.field_7 && j >= level.method_31607() + 1) {
            class_7 blockTypeBelow = PlayerNodeEvaluator.getBlockPathTypeRaw(level, (class_2338)pos.method_10103(i, j - 1, k));
            class_7 class_72 = blockPathTypes = blockTypeBelow == class_7.field_12 || blockTypeBelow == class_7.field_7 || blockTypeBelow == class_7.field_18 || blockTypeBelow == class_7.field_14 ? class_7.field_7 : class_7.field_12;
            if (blockTypeBelow == class_7.field_3) {
                blockPathTypes = class_7.field_3;
            }
            if (blockTypeBelow == class_7.field_11) {
                blockPathTypes = class_7.field_11;
            }
            if (blockTypeBelow == class_7.field_17) {
                blockPathTypes = class_7.field_17;
            }
            if (blockTypeBelow == class_7.field_21326) {
                blockPathTypes = class_7.field_21326;
            }
            if (blockTypeBelow == class_7.field_33534) {
                blockPathTypes = class_7.field_36432;
            }
        }
        if (blockPathTypes == class_7.field_12) {
            blockPathTypes = PlayerNodeEvaluator.checkNeighbourBlocks(level, pos.method_10103(i, j, k), blockPathTypes);
        }
        return blockPathTypes;
    }

    public static class_7 checkNeighbourBlocks(class_1922 level, class_2338.class_2339 centerPos, class_7 nodeType) {
        int i = centerPos.method_10263();
        int j = centerPos.method_10264();
        int k = centerPos.method_10260();
        for (int l = -1; l <= 1; ++l) {
            for (int m = -1; m <= 1; ++m) {
                for (int n = -1; n <= 1; ++n) {
                    if (l == 0 && n == 0) continue;
                    centerPos.method_10103(i + l, j + m, k + n);
                    class_2680 blockState = level.method_8320((class_2338)centerPos);
                    if (blockState.method_27852(class_2246.field_10029)) {
                        return class_7.field_20;
                    }
                    if (blockState.method_27852(class_2246.field_16999)) {
                        return class_7.field_5;
                    }
                    if (PlayerNodeEvaluator.isBurningBlock(blockState)) {
                        return class_7.field_9;
                    }
                    if (!level.method_8316((class_2338)centerPos).method_15767(class_3486.field_15517)) continue;
                    return class_7.field_4;
                }
            }
        }
        return nodeType;
    }

    protected static class_7 getBlockPathTypeRaw(class_1922 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        class_2248 block = blockState.method_26204();
        class_3614 material = blockState.method_26207();
        if (blockState.method_26215()) {
            return class_7.field_7;
        }
        if (blockState.method_26164(class_3481.field_15487) || blockState.method_27852(class_2246.field_10588) || blockState.method_27852(class_2246.field_28682)) {
            return class_7.field_19;
        }
        if (blockState.method_27852(class_2246.field_27879)) {
            return class_7.field_33534;
        }
        if (blockState.method_27852(class_2246.field_10029)) {
            return class_7.field_11;
        }
        if (blockState.method_27852(class_2246.field_16999)) {
            return class_7.field_17;
        }
        if (blockState.method_27852(class_2246.field_21211)) {
            return class_7.field_21326;
        }
        if (blockState.method_27852(class_2246.field_10302)) {
            return class_7.field_21516;
        }
        class_3610 fluidState = level.method_8316(pos);
        if (fluidState.method_15767(class_3486.field_15518)) {
            return class_7.field_14;
        }
        if (PlayerNodeEvaluator.isBurningBlock(blockState)) {
            return class_7.field_3;
        }
        if (class_2323.method_24796((class_2680)blockState) && !((Boolean)blockState.method_11654((class_2769)class_2323.field_10945)).booleanValue()) {
            return class_7.field_23;
        }
        if (block instanceof class_2323 && material == class_3614.field_15953 && !((Boolean)blockState.method_11654((class_2769)class_2323.field_10945)).booleanValue()) {
            return class_7.field_8;
        }
        if (block instanceof class_2323 && ((Boolean)blockState.method_11654((class_2769)class_2323.field_10945)).booleanValue()) {
            return class_7.field_15;
        }
        if (block instanceof class_2241) {
            return class_7.field_21;
        }
        if (block instanceof class_2397) {
            return class_7.field_6;
        }
        if (blockState.method_26164(class_3481.field_16584) || blockState.method_26164(class_3481.field_15504) || block instanceof class_2349 && !((Boolean)blockState.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
            return class_7.field_10;
        }
        if (!blockState.method_26171(level, pos, class_10.field_50)) {
            return class_7.field_22;
        }
        if (fluidState.method_15767(class_3486.field_15517)) {
            return class_7.field_18;
        }
        return class_7.field_7;
    }

    public static boolean isBurningBlock(class_2680 state) {
        return state.method_26164(class_3481.field_21952) || state.method_27852(class_2246.field_10164) || state.method_27852(class_2246.field_10092) || class_3922.method_23896((class_2680)state) || state.method_27852(class_2246.field_27098);
    }

    public void setCanFloat(boolean canSwim) {
        this.canFloat = canSwim;
    }

    public boolean canPassDoors() {
        return this.canPassDoors;
    }

    public boolean canOpenDoors() {
        return this.canOpenDoors;
    }

    public boolean canFloat() {
        return this.canFloat;
    }
}

