/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model.block;

import com.github.teamfossilsarcheology.fossil.client.model.block.PlantBlockModel;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_753;
import net.minecraft.class_777;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class PlantModelBakery {
    public static class_777 bakeFace(PlantBlockModel.PlantBlockElement part, PlantBlockModel.PlantBlockElementFace partFace, class_1058 sprite, class_2350 direction, class_3665 modelState) {
        return PlantModelBakery.bakeQuad(part.from(), part.to(), partFace, sprite, direction, part.rotations(), part.origin(), modelState);
    }

    private static class_777 bakeQuad(Vector3f posFrom, Vector3f posTo, PlantBlockModel.PlantBlockElementFace face, class_1058 sprite, class_2350 facing, Vector3f rotations, Vector3f origin, class_3665 modelState) {
        PlantBlockModel.PlantBlockFaceUV blockFaceUV = face.uv();
        float[] tempUvs = new float[blockFaceUV.uvs().length];
        System.arraycopy(blockFaceUV.uvs(), 0, tempUvs, 0, tempUvs.length);
        float f = sprite.method_23842();
        float g = (blockFaceUV.uvs()[0] + blockFaceUV.uvs()[0] + blockFaceUV.uvs()[2] + blockFaceUV.uvs()[2]) / 4.0f;
        float h = (blockFaceUV.uvs()[1] + blockFaceUV.uvs()[1] + blockFaceUV.uvs()[3] + blockFaceUV.uvs()[3]) / 4.0f;
        blockFaceUV.uvs()[0] = class_3532.method_16439((float)f, (float)blockFaceUV.uvs()[0], (float)g);
        blockFaceUV.uvs()[2] = class_3532.method_16439((float)f, (float)blockFaceUV.uvs()[2], (float)g);
        blockFaceUV.uvs()[1] = class_3532.method_16439((float)f, (float)blockFaceUV.uvs()[1], (float)h);
        blockFaceUV.uvs()[3] = class_3532.method_16439((float)f, (float)blockFaceUV.uvs()[3], (float)h);
        int[] vertices = PlantModelBakery.makeVertices(blockFaceUV, sprite, facing, PlantModelBakery.setupShape(posFrom, posTo), rotations, origin, modelState);
        class_2350 direction = PlantModelBakery.calculateFacing(vertices);
        System.arraycopy(tempUvs, 0, blockFaceUV.uvs(), 0, tempUvs.length);
        return new class_777(vertices, -1, direction, sprite, false);
    }

    private static int[] makeVertices(PlantBlockModel.PlantBlockFaceUV uvs, class_1058 sprite, class_2350 orientation, float[] posDiv16, Vector3f rotations, Vector3f origin, class_3665 modelState) {
        int[] is = new int[32];
        for (int i = 0; i < 4; ++i) {
            PlantModelBakery.bakeVertex(is, i, orientation, uvs, posDiv16, sprite, rotations, origin, modelState);
        }
        return is;
    }

    private static float[] setupShape(Vector3f pos1, Vector3f pos2) {
        float[] fs = new float[class_2350.values().length];
        fs[class_753.class_754.field_3967] = pos1.x() / 16.0f;
        fs[class_753.class_754.field_3968] = pos1.y() / 16.0f;
        fs[class_753.class_754.field_3969] = pos1.z() / 16.0f;
        fs[class_753.class_754.field_3970] = pos2.x() / 16.0f;
        fs[class_753.class_754.field_3971] = pos2.y() / 16.0f;
        fs[class_753.class_754.field_3972] = pos2.z() / 16.0f;
        return fs;
    }

    private static void bakeVertex(int[] vertexData, int vertexIndex, class_2350 facing, PlantBlockModel.PlantBlockFaceUV blockFaceUV, float[] posDiv16, class_1058 sprite, Vector3f rotations, Vector3f origin, class_3665 modelState) {
        class_753.class_755 vertexInfo = class_753.method_3163((class_2350)facing).method_3162(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[vertexInfo.field_3975], posDiv16[vertexInfo.field_3974], posDiv16[vertexInfo.field_3973]);
        PlantModelBakery.applyElementRotation(vector3f, rotations, origin);
        PlantModelBakery.applyModelRotation(vector3f, modelState.method_3509());
        PlantModelBakery.fillVertex(vertexData, vertexIndex, vector3f, sprite, blockFaceUV);
    }

    private static void fillVertex(int[] vertexData, int vertexIndex, Vector3f vector, class_1058 sprite, PlantBlockModel.PlantBlockFaceUV blockFaceUV) {
        int i = vertexIndex * 8;
        vertexData[i] = Float.floatToRawIntBits(vector.x());
        vertexData[i + 1] = Float.floatToRawIntBits(vector.y());
        vertexData[i + 2] = Float.floatToRawIntBits(vector.z());
        vertexData[i + 3] = -1;
        vertexData[i + 4] = Float.floatToRawIntBits(sprite.method_4580((double)blockFaceUV.getU(vertexIndex)));
        vertexData[i + 4 + 1] = Float.floatToRawIntBits(sprite.method_4570((double)blockFaceUV.getV(vertexIndex)));
    }

    private static void applyElementRotation(Vector3f pos, Vector3f rotations, Vector3f origin) {
        Vector4f temp = new Vector4f(pos.x() - origin.x(), pos.y() - origin.y(), pos.z() - origin.z(), 1.0f);
        if (rotations.x() != 0.0f) {
            temp.rotateX(rotations.x() * ((float)Math.PI / 180));
        }
        if (rotations.y() != 0.0f) {
            temp.rotateY(rotations.y() * ((float)Math.PI / 180));
        }
        if (rotations.z() != 0.0f) {
            temp.rotateZ(rotations.z() * ((float)Math.PI / 180));
        }
        pos.set(temp.x() + origin.x(), temp.y() + origin.y(), temp.z() + origin.z());
    }

    private static void applyModelRotation(Vector3f pos, class_4590 transform) {
        if (transform == class_4590.method_22931()) {
            return;
        }
        Vector3f origin = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector4f vector4f = new Vector4f(pos.x() - origin.x(), pos.y() - origin.y(), pos.z() - origin.z(), 1.0f);
        transform.method_22936().transform(vector4f);
        pos.set(vector4f.x() + origin.x(), vector4f.y() + origin.y(), vector4f.z() + origin.z());
    }

    private static class_2350 calculateFacing(int[] faceData) {
        Vector3f vector3f = new Vector3f(Float.intBitsToFloat(faceData[0]), Float.intBitsToFloat(faceData[1]), Float.intBitsToFloat(faceData[2]));
        Vector3f vector3f2 = new Vector3f(Float.intBitsToFloat(faceData[8]), Float.intBitsToFloat(faceData[9]), Float.intBitsToFloat(faceData[10]));
        Vector3f vector3f3 = new Vector3f(Float.intBitsToFloat(faceData[16]), Float.intBitsToFloat(faceData[17]), Float.intBitsToFloat(faceData[18]));
        Vector3f vector3f4 = new Vector3f((Vector3fc)vector3f);
        vector3f4.sub((Vector3fc)vector3f2);
        Vector3f vector3f5 = new Vector3f((Vector3fc)vector3f3);
        vector3f5.sub((Vector3fc)vector3f2);
        Vector3f vector3f6 = new Vector3f((Vector3fc)vector3f5);
        vector3f6.cross((Vector3fc)vector3f4);
        vector3f6.normalize();
        class_2350 direction = null;
        float f = 0.0f;
        for (class_2350 direction2 : class_2350.values()) {
            Vector3f vector3f7 = new Vector3f((float)direction2.method_10148(), (float)direction2.method_10164(), (float)direction2.method_10165());
            float g = vector3f6.dot((Vector3fc)vector3f7);
            if (!(g >= 0.0f) || !(g > f)) continue;
            f = g;
            direction = direction2;
        }
        if (direction == null) {
            return class_2350.field_11036;
        }
        return direction;
    }
}

