/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.model.DinosaurEggModel;
import com.github.teamfossilsarcheology.fossil.client.renderer.RendererFabricFix;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_922;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DinosaurEggRenderer
extends class_922<DinosaurEgg, DinosaurEggModel>
implements RendererFabricFix {
    private static final Map<String, class_2960> TEXTURES = new Object2ObjectOpenHashMap();
    private static final class_2960 GOLDEN_EGG = FossilMod.location("textures/entity/egg/golden.png");

    public DinosaurEggRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new DinosaurEggModel(), 0.25f);
    }

    protected void scale(DinosaurEgg egg, class_4587 poseStack, float partialTickTime) {
        float scale = EntityDataLoader.INSTANCE.getData(egg.getPrehistoricEntityInfo().resourceName).eggScale();
        if (egg.getScaleOverride() > 0.0f) {
            scale = egg.getScaleOverride();
        }
        this.field_4673 = 0.25f * scale;
        poseStack.method_22905(scale, scale, scale);
        super.method_4042((class_1309)egg, poseStack, partialTickTime);
    }

    @Nullable
    protected class_1921 getRenderType(DinosaurEgg egg, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (bodyVisible) {
            if (egg.isGoldenEgg()) {
                return ((DinosaurEggModel)this.field_4737).method_23500(GOLDEN_EGG);
            }
            class_2960 resourceLocation = this.getTextureLocation(egg);
            return ((DinosaurEggModel)this.field_4737).method_23500(resourceLocation);
        }
        return null;
    }

    protected boolean shouldShowName(DinosaurEgg entity) {
        return false;
    }

    @Override
    public class_2960 _getTextureLocation(class_1297 entity) {
        return this.getTextureLocation((DinosaurEgg)entity);
    }

    @NotNull
    public class_2960 getTextureLocation(DinosaurEgg entity) {
        return TEXTURES.computeIfAbsent(entity.getPrehistoricEntityInfo().resourceName, name -> {
            class_2960 rl = FossilMod.location("textures/entity/egg/egg_" + name + ".png");
            class_310.method_1551().method_1531().method_4619(rl);
            class_1044 tex = class_310.method_1551().method_1531().method_4619(rl);
            if (tex == class_1047.method_4540()) {
                return FossilMod.location("textures/entity/egg/fallback.png");
            }
            return rl;
        });
    }
}

