/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.darkpred.morehitboxes.api.HitboxData;
import com.github.darkpred.morehitboxes.internal.HitboxDataLoader;
import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.util.TimePeriod;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PrehistoricSkeleton
extends class_1297
implements GeoEntity {
    private static final class_2940<Integer> AGE = class_2945.method_12791(PrehistoricSkeleton.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> TYPE = class_2945.method_12791(PrehistoricSkeleton.class, (class_2941)class_2943.field_13326);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean droppedBiofossil;
    private float frustumWidthRadius;
    private float frustumHeight;
    private class_238 cullingBounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public class_2960 textureLocation;
    public class_2960 modelLocation;

    public PrehistoricSkeleton(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
        this.refreshTexturePath();
    }

    protected void method_5693() {
        this.field_6011.method_12784(AGE, (Object)0);
        this.field_6011.method_12784(TYPE, (Object)PrehistoricEntityInfo.TRICERATOPS.name());
    }

    protected void method_5749(class_2487 compound) {
        this.setAge(compound.method_10550("Age"));
        this.field_6011.method_12778(TYPE, (Object)compound.method_10558("Type"));
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10569("Age", this.getAge());
        compound.method_10582("Type", (String)this.field_6011.method_12789(TYPE));
    }

    public float method_5791() {
        return this.method_36454();
    }

    public void method_5847(float yHeadRot) {
        this.method_36456(yHeadRot);
    }

    @NotNull
    protected class_238 method_33332() {
        return this.info().entityType().method_18386().method_18383(this.getScale()).method_30757(this.method_19538());
    }

    @NotNull
    public class_4048 method_18377(class_4050 poseIn) {
        return this.info().entityType().method_18386().method_18383(this.getScale());
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960()) {
            if (player.method_5715()) {
                this.method_5859(this.method_23317() + (player.method_23317() - this.method_23317()) * 0.01, this.method_23318(), this.method_23321() + (player.method_23321() - this.method_23321()) * 0.01);
            } else {
                double d0 = player.method_23317() - this.method_23317();
                double d2 = player.method_23321() - this.method_23321();
                this.method_36456(Util.yawToYRot(class_3532.method_15349((double)d2, (double)d0) * 57.2957763671875));
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (stack.method_31574(class_1802.field_8606) && !this.isAdult()) {
            if (!this.field_6002.field_9236) {
                this.method_5783(class_3417.field_15200, 0.8f, 1.0f);
                this.setAge(this.getAge() + 1);
                stack.method_7934(1);
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5688(player, hand);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (amount > 0.0f) {
            this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15069, class_3419.field_15254, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.5f);
            if (!this.field_6002.field_9236) {
                if (!this.droppedBiofossil) {
                    if (this.info().timePeriod == TimePeriod.CENOZOIC) {
                        this.method_5870((class_1935)ModItems.TAR_FOSSIL.get(), 1);
                    } else if (this.info().timePeriod == TimePeriod.PALEOZOIC) {
                        this.method_5870((class_1935)ModItems.SHALE_FOSSIL.get(), 1);
                    } else {
                        this.method_5870((class_1935)ModItems.BIO_FOSSIL.get(), 1);
                    }
                    this.method_5699(new class_1799((class_1935)class_1802.field_8606, Math.min(this.getAge(), this.data().adultAgeDays())), 1.0f);
                    this.droppedBiofossil = true;
                }
                this.method_31472();
            }
            return true;
        }
        return super.method_5643(source, amount);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (AGE.equals(key) || TYPE.equals(key)) {
            this.method_18382();
            this.refreshTexturePath();
        }
        if (TYPE.equals(key) && this.field_6002.field_9236) {
            List hitboxesData = HitboxDataLoader.HITBOX_DATA.getHitboxes(FossilMod.location(this.info().resourceName));
            if (hitboxesData != null) {
                float maxFrustumWidthRadius = 0.0f;
                float maxFrustumHeight = 0.0f;
                for (HitboxData hitboxData : hitboxesData) {
                    float h;
                    float w = hitboxData.getFrustumWidthRadius();
                    if (w > maxFrustumWidthRadius) {
                        maxFrustumWidthRadius = w;
                    }
                    if (!((h = hitboxData.getFrustumHeight()) > maxFrustumHeight)) continue;
                    maxFrustumHeight = h;
                }
                this.frustumWidthRadius = maxFrustumWidthRadius;
                this.frustumHeight = maxFrustumHeight;
            } else {
                this.frustumWidthRadius = this.method_17681();
                this.frustumHeight = this.method_17682();
            }
            this.makeBoundingBoxForCulling(this.frustumWidthRadius, this.frustumHeight);
        }
    }

    public void refreshTexturePath() {
        if (!this.field_6002.field_9236) {
            return;
        }
        String name = this.info().resourceName;
        this.textureLocation = FossilMod.location("textures/entity/" + name + "/" + name + "_skeleton.png");
        this.modelLocation = this.info() == PrehistoricEntityInfo.DICRANURUS || this.info() == PrehistoricEntityInfo.LONCHODOMAS || this.info() == PrehistoricEntityInfo.SCOTOHARPES || this.info() == PrehistoricEntityInfo.WALLISEROPS ? FossilMod.location("geo/entity/trilobite.geo.json") : FossilMod.location("geo/entity/" + name + ".geo.json");
    }

    private void makeBoundingBoxForCulling(float frustumWidthRadius, float frustumHeight) {
        float x = frustumWidthRadius * this.getScale();
        float y = frustumHeight * this.getScale();
        class_243 pos = this.method_19538();
        this.cullingBounds = new class_238(pos.field_1352 - (double)x, pos.field_1351, pos.field_1350 - (double)x, pos.field_1352 + (double)x, pos.field_1351 + (double)y, pos.field_1350 + (double)x);
    }

    @NotNull
    public class_238 method_5830() {
        return this.cullingBounds;
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814(x, y, z);
        this.makeBoundingBoxForCulling(this.frustumWidthRadius, this.frustumHeight);
    }

    public boolean method_5863() {
        return true;
    }

    public float getScale() {
        if (this.isAdult()) {
            return this.data().maxScale();
        }
        float step = (this.data().maxScale() - this.data().minScale()) / (float)this.data().adultAgeDays();
        return this.data().minScale() + step * (float)this.getAge();
    }

    public boolean isAdult() {
        return this.getAge() >= this.data().adultAgeDays();
    }

    public int getAge() {
        return (Integer)this.field_6011.method_12789(AGE);
    }

    public void setAge(int age) {
        this.field_6011.method_12778(AGE, (Object)age);
    }

    public void setType(PrehistoricEntityInfo info) {
        this.field_6011.method_12778(TYPE, (Object)info.name());
    }

    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.valueOf((String)this.field_6011.method_12789(TYPE));
    }

    public EntityDataLoader.Data data() {
        return EntityDataLoader.INSTANCE.getData(this.info().resourceName);
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return NetworkManager.createAddEntityPacket((class_1297)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

