/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ai.MoveToFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_4538;
import net.minecraft.class_5575;

public class EatItemEntityGoal
extends MoveToFoodGoal {
    private class_1542 targetItem;
    private boolean recentlyAte;

    public EatItemEntityGoal(Prehistoric entity) {
        super(entity, 1.0, 16);
    }

    @Override
    protected int nextStartTick() {
        if (this.recentlyAte) {
            this.recentlyAte = false;
            return 20;
        }
        return super.nextStartTick();
    }

    @Override
    protected boolean checkReachedTarget() {
        if (Math.abs(this.entity.method_23318() - this.targetItem.method_23318()) > 3.0) {
            return false;
        }
        return Util.directionVecTo((class_1297)this.targetItem, (class_1297)this.entity).method_37267() <= this.acceptedDistance();
    }

    @Override
    public void method_6268() {
        super.method_6268();
        if (this.isReachedTarget()) {
            if (this.entity.getHunger() < this.entity.getMaxHunger()) {
                this.entity.feed(FoodMappings.getFoodAmount((class_1935)this.targetItem.method_6983().method_7909(), this.entity.data().diet()));
                this.targetItem.method_6983().method_7934(1);
            }
            this.recentlyAte = true;
            if (this.entity.field_6002.method_8510() > this.animEndTick) {
                AnimationInfo animationInfo = this.entity.nextEatingAnimation();
                this.entity.getAnimationLogic().triggerAnimation("Movement/Idle", animationInfo, AnimationCategory.EAT);
                this.animEndTick = (long)((double)this.entity.field_6002.method_8510() + animationInfo.animation.length());
            }
        }
    }

    @Override
    protected boolean isValidTarget(class_4538 level, class_2338 pos) {
        if (!super.isValidTarget(level, pos)) {
            return false;
        }
        return this.targetItem != null && this.targetItem.method_5805();
    }

    @Override
    protected boolean findNearestBlock() {
        List nearbyItems = this.entity.field_6002.method_18023(class_5575.method_31795(class_1542.class), this.entity.method_5829().method_1014((double)this.searchRange), itemEntity -> FoodMappings.getFoodAmount((class_1935)itemEntity.method_6983().method_7909(), this.entity.data().diet()) > 0 && !this.avoidCache.contains(itemEntity.method_24515().method_10063()));
        this.targetItem = nearbyItems.stream().min((o1, o2) -> Double.compare(this.entity.method_5858((class_1297)o1), this.entity.method_5858((class_1297)o2))).orElse(null);
        if (this.targetItem == null) {
            this.clearTicks = !this.avoidCache.isEmpty() ? 400 : 0;
            return false;
        }
        this.setTargetPos(this.targetItem.method_24515());
        return true;
    }
}

