/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_5134;

public class GrabMeleeAttackGoal
extends DelayedAttackGoal<PrehistoricSwimming> {
    private static final int ATTACK = 0;
    private static final int GRAB = 1;
    private static final int GRAB_DURATION = 55;
    private class_1309 attackTarget;
    private int attackType = -1;
    private long grabStartTick = -1L;

    public GrabMeleeAttackGoal(PrehistoricSwimming entity, double speed, boolean followTargetEvenIfNotSeen) {
        super(entity, speed, followTargetEvenIfNotSeen);
    }

    @Override
    public boolean method_6266() {
        if (this.attackType == 0) {
            return super.method_6266();
        }
        if (this.attackTarget == null || this.attackTarget.method_31481() || ((PrehistoricSwimming)this.mob).getCurrentOrder() == OrderType.STAY) {
            return false;
        }
        if (!(this.attackType != 1 || ((PrehistoricSwimming)this.mob).isDoingGrabAttack() && ((PrehistoricSwimming)this.mob).method_5626((class_1297)this.attackTarget))) {
            this.attackEndTick = ((PrehistoricSwimming)this.mob).field_6002.method_8510() + 20L;
            return false;
        }
        return CAN_ATTACK_TARGET.test(this.attackTarget);
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.attackTarget = ((PrehistoricSwimming)this.mob).method_5968();
        this.attackType = -1;
        this.grabStartTick = -1L;
    }

    @Override
    public void method_6270() {
        super.method_6270();
        ((PrehistoricSwimming)this.mob).setDoingGrabAttack(false);
    }

    @Override
    protected boolean canUpdateMovement() {
        return this.attackType != 1;
    }

    @Override
    protected void checkAndPerformAttack(class_1309 enemy, boolean inRange) {
        long currentTime = ((PrehistoricSwimming)this.mob).field_6002.method_8510();
        if (this.attackType == 1) {
            for (class_1297 passenger : ((PrehistoricSwimming)this.mob).method_5685()) {
                boolean hurt;
                if (!(passenger instanceof class_1309) || passenger == ((PrehistoricSwimming)this.mob).getRidingPlayer() || ((PrehistoricSwimming)this.mob).field_6012 % 20 != 0 || (hurt = passenger.method_5643(class_1282.method_5511((class_1309)this.mob), (float)((PrehistoricSwimming)this.mob).method_26825(class_5134.field_23721))) && (currentTime < this.grabStartTick + 55L || ((PrehistoricSwimming)this.mob).method_6051().method_43048(5) != 0)) continue;
                this.attackEndTick = currentTime + 20L;
                ((PrehistoricSwimming)this.mob).stopGrabAttack(passenger);
            }
        } else if (this.attackType == 0) {
            if (inRange && this.attackDamageTick > 0L && currentTime >= this.attackDamageTick) {
                ((PrehistoricSwimming)this.mob).attackTarget(enemy);
                ((PrehistoricSwimming)this.mob).destroyBoat((class_1297)enemy);
                this.attackDamageTick = -1L;
                this.attackType = -1;
            }
        } else if (currentTime > this.attackEndTick + 20L && inRange) {
            boolean tooBig = Util.isEntityLargerThan((class_1297)enemy, ((PrehistoricSwimming)this.mob).grabTargetSize());
            if (tooBig || ((PrehistoricSwimming)this.mob).method_6051().method_43048(5) > 0 || ((PrehistoricSwimming)this.mob).method_5854() == enemy) {
                this.attackType = 0;
                ServerAnimationInfo animationInfo = ((PrehistoricSwimming)this.mob).startAttack();
                this.attackEndTick = (long)((double)currentTime + animationInfo.animation.length());
                this.attackDamageTick = Math.min((long)((double)currentTime + animationInfo.actionDelay), this.attackEndTick);
            } else {
                this.attackType = 1;
                ((PrehistoricSwimming)this.mob).destroyBoat((class_1297)enemy);
                ((PrehistoricSwimming)this.mob).startGrabAttack((class_1297)enemy);
                this.attackEndTick = 1L;
                this.grabStartTick = currentTime;
            }
        }
    }
}

