/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.monster;

import com.github.teamfossilsarcheology.fossil.block.entity.AnuBarrierBlockEntity;
import com.github.teamfossilsarcheology.fossil.entity.AnuDead;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhase;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhaseSystem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.sounds.MusicHandler;
import com.github.teamfossilsarcheology.fossil.world.dimension.ModDimensions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1829;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnuBoss
extends class_1314
implements class_1603 {
    public static final int ARENA_RADIUS = 25;
    public static final class_2940<Integer> DATA_PHASE = class_2945.method_12791(AnuBoss.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> WEAK = class_2945.method_12791(AnuBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2561 SPAWN_1 = class_2561.method_43471((String)"entity.fossil.anu.hello");
    private static final class_2561 SPAWN_2 = class_2561.method_43471((String)"entity.fossil.anu.fewBeaten");
    private static final class_2561 ANU_COMBAT_SWORD = class_2561.method_43471((String)"entity.fossil.anu.draw");
    private static final class_2561 ANU_COMBAT_BOW = class_2561.method_43471((String)"entity.fossil.anu.coward");
    private static final class_2561 ANU_COMBAT_FIST = class_2561.method_43471((String)"entity.fossil.anu.fist");
    private static final class_2561 ANU_COMBAT_ANCIENT = class_2561.method_43471((String)"entity.fossil.anu.ancient");
    private static final class_2561 ANU_DEATH = class_2561.method_43471((String)"entity.fossil.anu.death");
    private static final int SONG_LENGTH = 4041;
    private final class_3213 bossEvent = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795).method_5406(true);
    private class_243 spawnPosition = class_243.field_1353;
    public final AnuPhaseSystem phaseSystem = new AnuPhaseSystem(this);
    private int songTick;

    public AnuBoss(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new AnuMoveControl(this);
        this.field_6194 = 50;
        this.method_5941(class_7.field_9, 4.0f);
        this.method_5941(class_7.field_3, 0.0f);
        this.method_5941(class_7.field_14, 4.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return AnuBoss.method_26828().method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23716, 600.0).method_26868(class_5134.field_23719, 0.35).method_26867(class_5134.field_23721);
    }

    public static class_2561 getRandomGreeting(class_5819 random) {
        return random.method_43048(2) == 0 ? SPAWN_1 : SPAWN_2;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_PHASE, (Object)AnuPhase.MELEE.ordinal());
        this.field_6011.method_12784(WEAK, (Object)false);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (DATA_PHASE.equals(key) && this.field_6002.field_9236) {
            this.phaseSystem.setPhase(AnuPhase.values()[(Integer)this.field_6011.method_12789(DATA_PHASE)]);
        }
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1309.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public boolean method_5822() {
        return false;
    }

    public class_243 getSpawnPos() {
        return this.spawnPosition;
    }

    public void method_5670() {
        super.method_5670();
        if (this.field_6002.field_9236) {
            if (this.songTick < 4041) {
                ++this.songTick;
            }
            if (this.songTick == 4040) {
                this.songTick = 0;
            }
            if (this.songTick == 1) {
                MusicHandler.startMusic((class_3414)ModSounds.MUSIC_ANU.get());
            }
            if (!this.method_5805()) {
                MusicHandler.stopMusic((class_3414)ModSounds.MUSIC_ANU.get());
            }
            if (this.field_6258 != null && !this.field_6258.method_5805()) {
                MusicHandler.stopMusic((class_3414)ModSounds.MUSIC_ANU.get());
            }
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.field_6002.field_9236) {
            this.phaseSystem.getCurrentPhase().doClientTick();
        }
    }

    protected void method_5958() {
        super.method_5958();
        this.phaseSystem.getCurrentPhase().doServerTick();
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    public boolean isWeak() {
        return (Boolean)this.field_6011.method_12789(WEAK);
    }

    public void setWeak(boolean weak) {
        this.field_6011.method_12778(WEAK, (Object)weak);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 trueSource = source.method_5529();
        if (source == class_1282.field_5855 || source.method_5535() && trueSource == null) {
            return false;
        }
        this.phaseSystem.getCurrentPhase().onHurt(source, amount);
        if (source.method_5526() instanceof class_1674 && source.method_5529() instanceof class_1657) {
            super.method_5643(source, 20.0f);
            return true;
        }
        if (source == class_1282.field_5849 && this.method_23318() < (double)this.field_6002.method_31607()) {
            this.method_29495(this.spawnPosition);
            return false;
        }
        if (this.field_6002.field_9236 && trueSource instanceof class_1657) {
            class_1657 player = (class_1657)trueSource;
            if (this.field_5974.method_43048(10) == 0) {
                class_1799 itemStack = player.method_31548().method_7391();
                if (itemStack.method_31574((class_1792)ModItems.ANCIENT_SWORD.get())) {
                    player.method_7353(ANU_COMBAT_ANCIENT, false);
                } else if (itemStack.method_7909() instanceof class_1829) {
                    player.method_7353(ANU_COMBAT_SWORD, false);
                } else if (source.method_5533()) {
                    player.method_7353(ANU_COMBAT_BOW, false);
                } else if (itemStack.method_7960()) {
                    player.method_7353(ANU_COMBAT_FIST, false);
                }
            }
        }
        return super.method_5643(source, this.isWeak() ? amount * 1.25f : amount);
    }

    private void removeBarriers() {
        if (!this.field_6002.field_9236 && this.field_6002.method_27983() == ModDimensions.ANU_LAIR) {
            AnuLair anuLair = (AnuLair)((class_3218)this.field_6002).method_17983().method_20786(AnuLair::load, "anu_lair");
            if (anuLair != null) {
                for (class_2338 barrierPosition : anuLair.barrierPositions) {
                    class_2586 class_25862 = this.field_6002.method_8321(barrierPosition);
                    if (!(class_25862 instanceof AnuBarrierBlockEntity)) continue;
                    AnuBarrierBlockEntity blockEntity = (AnuBarrierBlockEntity)class_25862;
                    blockEntity.disable();
                }
            }
            ((class_3218)this.field_6002).method_17983().method_123("anu_lair", (class_18)AnuLair.killed());
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.removeBarriers();
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.field_6002.field_9236) {
            AnuDead anuDead = (AnuDead)((class_1299)ModEntities.ANU_DEAD.get()).method_5883(this.field_6002);
            anuDead.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            this.field_6002.method_8649((class_1297)anuDead);
            this.removeBarriers();
        } else {
            MusicHandler.stopMusic((class_3414)ModSounds.MUSIC_ANU.get());
            List players = this.field_6002.method_18464(class_4051.method_36625(), (class_1309)this, this.method_5829().method_1009(30.0, 15.0, 30.0));
            for (class_1657 player : players) {
                player.method_7353(ANU_DEATH, false);
            }
        }
        super.method_6078(damageSource);
    }

    protected void method_6099(class_1282 damageSource, int looting, boolean hitByPlayer) {
        super.method_6099(damageSource, looting, hitByPlayer);
        class_1542 itemEntity = this.method_5706((class_1935)ModItems.ANCIENT_KEY.get());
        if (itemEntity != null) {
            itemEntity.method_6976();
        }
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_6121(class_1297 target) {
        if (this.field_5974.method_43048(4) == 0) {
            class_1538 lightningBolt = (class_1538)((class_1299)ModEntities.ANCIENT_LIGHTNING_BOLT.get()).method_5883(this.field_6002);
            lightningBolt.method_29495(target.method_19538());
            this.field_6002.method_8649((class_1297)lightningBolt);
        }
        return super.method_6121(target);
    }

    public void method_7105(class_1309 target, float velocity) {
        double x = target.method_23317() - this.method_23317();
        double y = target.method_5829().field_1322 - (this.method_23318() + (double)(this.method_17682() / 2.0f));
        double z = target.method_23321() - this.method_23321();
        this.method_5783(class_3417.field_15231, 1.0f, 1.0f);
        class_1674 largeFireball = new class_1674(this.field_6002, (class_1309)this, x, y, z, 2);
        largeFireball.method_5814(this.method_23317() + x * 0.1, this.method_23318() + (double)(this.method_17682() / 2.0f) + 0.5, this.method_23321() + z * 0.1);
        this.field_6002.method_8649((class_1297)largeFireball);
    }

    public void method_5982() {
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.phaseSystem.getCurrentPhase().getAmbientSound();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15075;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15055;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.method_5964(level.method_8409(), difficulty);
        this.spawnPosition = this.method_19538();
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)ModItems.ANCIENT_SWORD.get()));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10549("SpawnPosX", this.spawnPosition.field_1352);
        compound.method_10549("SpawnPosY", this.spawnPosition.field_1351);
        compound.method_10549("SpawnPosZ", this.spawnPosition.field_1350);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.spawnPosition = new class_243(compound.method_10574("SpawnPosX"), compound.method_10574("SpawnPosY"), compound.method_10574("SpawnPosZ"));
        if (this.method_16914()) {
            this.bossEvent.method_5413(this.method_5476());
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossEvent.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    public static class AnuLair
    extends class_18 {
        private boolean anuKilled;
        private final Set<class_2338> barrierPositions = new HashSet<class_2338>();

        public static AnuLair killed() {
            AnuLair anuLair = new AnuLair();
            anuLair.anuKilled = true;
            anuLair.method_80();
            return anuLair;
        }

        public static AnuLair spawned(Set<class_2338> barriers) {
            AnuLair anuLair = new AnuLair();
            anuLair.barrierPositions.addAll(barriers);
            anuLair.method_80();
            return anuLair;
        }

        public static AnuLair load(class_2487 compoundTag) {
            AnuLair anuLair = new AnuLair();
            anuLair.anuKilled = compoundTag.method_10577("AnuKilled");
            class_2499 barriers = compoundTag.method_10554("Barriers", 10);
            anuLair.barrierPositions.clear();
            for (int i = 0; i < barriers.size(); ++i) {
                class_2487 tag = barriers.method_10602(i);
                anuLair.barrierPositions.add(new class_2338(tag.method_10550("X"), tag.method_10550("Y"), tag.method_10550("Z")));
            }
            return anuLair;
        }

        @NotNull
        public class_2487 method_75(class_2487 compoundTag) {
            compoundTag.method_10556("AnuKilled", this.anuKilled);
            class_2499 barriers = new class_2499();
            for (class_2338 blockPos : this.barrierPositions) {
                class_2487 tag = new class_2487();
                tag.method_10569("X", blockPos.method_10263());
                tag.method_10569("Y", blockPos.method_10264());
                tag.method_10569("Z", blockPos.method_10260());
                barriers.add((Object)tag);
            }
            compoundTag.method_10566("Barriers", (class_2520)barriers);
            return compoundTag;
        }

        public boolean isAnuKilled() {
            return this.anuKilled;
        }
    }
}

