/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.advancements.ModTriggers;
import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CMusicMessage;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.mojang.logging.LogUtils;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2371;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DinosaurEgg
extends class_1309
implements EntitySpawnExtension {
    public static final int TOTAL_HATCHING_TIME = 3000;
    public static final class_2960 GOLDEN_EGG_ADV = FossilMod.location("fossil/all_eggs");
    private static final class_2940<Integer> HATCHING_TIME = class_2945.method_12791(DinosaurEgg.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> GOLDEN_EGG = class_2945.method_12791(DinosaurEgg.class, (class_2941)class_2943.field_13323);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2561 EGG_HATCHED = class_2561.method_43471((String)"entity.fossil.dinosaur_egg.hatched");
    private static final List<class_1799> ARMOR = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private float scaleOverride = -1.0f;
    private PrehistoricEntityInfo prehistoricEntityInfo = PrehistoricEntityInfo.TRICERATOPS;

    public DinosaurEgg(class_1299<DinosaurEgg> type, class_1937 level) {
        super(type, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 2.0);
    }

    public static class_1297 hatchEgg(class_1937 level, double x, double y, double z, @Nullable class_3222 player, PrehistoricEntityInfo info, boolean hatchMessage) {
        class_1297 entity = info.entityType().method_5883(level);
        if (entity instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)entity;
            if (player != null) {
                ModTriggers.INCUBATE_EGG_TRIGGER.trigger(player, entity);
                if (prehistoric.aiTameType() == PrehistoricEntityInfoAI.Taming.IMPRINTING) {
                    prehistoric.method_6170((class_1657)player);
                    if (!ModCapabilities.hasHatchedDinosaur((class_1657)player)) {
                        MessageHandler.SYNC_CHANNEL.sendToPlayer(player, (Object)new S2CMusicMessage((class_3414)ModSounds.MUSIC_FIRST_DINOSAUR.get()));
                        ModCapabilities.setHatchedDinosaur((class_1657)player, true);
                    }
                    if (hatchMessage) {
                        player.method_7353(EGG_HATCHED, false);
                    }
                }
            }
            prehistoric.method_5943((class_5425)level, level.method_8404(entity.method_24515()), class_3730.field_16466, new Prehistoric.PrehistoricGroupData(0), null);
            prehistoric.grow(0);
        }
        entity.method_5808(x, y, z, level.field_9229.method_43057() * 360.0f, 0.0f);
        level.method_8649(entity);
        return entity;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HATCHING_TIME, (Object)0);
        this.field_6011.method_12784(GOLDEN_EGG, (Object)false);
    }

    @NotNull
    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    public void method_5773() {
        super.method_5773();
        int currentHatchingTime = this.getHatchingTime();
        if (!this.isGoldenEgg() && this.isTooCold() || this.method_5799()) {
            if (currentHatchingTime > 0) {
                this.setHatchingTime(currentHatchingTime - 1);
            }
        } else {
            this.setHatchingTime(currentHatchingTime + 1);
        }
        if (this.getHatchingTime() >= this.getTotalHatchingTime() && !this.field_6002.field_9236) {
            class_1657 player = this.field_6002.method_18460((class_1297)this, 16.0);
            DinosaurEgg.hatchEgg(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), (class_3222)player, this.prehistoricEntityInfo, true);
            for (int i = 0; i < 4; ++i) {
                double x = this.method_23317() + ((double)this.field_5974.method_43057() - 0.5) * (double)this.method_17681();
                double y = this.method_5829().field_1322 + 0.1;
                double z = this.method_23321() + ((double)this.field_5974.method_43057() - 0.5) * (double)this.method_17681();
                double motionX = (double)this.field_5974.method_43057() - 0.5;
                double motionZ = (double)this.field_5974.method_43057() - 0.5;
                this.field_6002.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)this.prehistoricEntityInfo.eggItem)), x, y, z, motionX, 0.5, motionZ);
            }
            this.method_31472();
        }
    }

    public boolean isTooCold() {
        class_6880 biome = this.field_6002.method_23753(this.method_24515());
        this.field_6002.method_8533();
        if (((class_1959)biome.comp_349()).method_39927(this.method_24515())) {
            return this.method_5718() < 0.5f;
        }
        return this.method_5718() < 0.75f;
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.field_6002.field_9236 && amount > 0.0f && this.method_5805()) {
            class_1542 itemEntity = new class_1542(this.field_6002, this.method_23317() + 0.5, this.method_23318() + 1.0, this.method_23321() + 0.5, new class_1799((class_1935)this.getPrehistoricEntityInfo().eggItem), 0.0, 0.1, 0.0);
            this.field_6002.method_8649((class_1297)itemEntity);
            this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15197, class_3419.field_15254, 0.2f, ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.7f + 1.0f) * 2.0f);
            this.method_5768();
        }
        return super.method_5643(source, amount);
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_31548().method_7391().method_7960() && !player.method_31549().field_7477 && player.method_31548().method_7394(new class_1799((class_1935)this.getPrehistoricEntityInfo().eggItem))) {
            this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15197, class_3419.field_15254, 0.2f, ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.7f + 1.0f) * 2.0f);
            this.method_5768();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)this.prehistoricEntityInfo.eggItem);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("HatchingTime", this.getHatchingTime());
        compound.method_10582("PrehistoricEntityInfo", this.getPrehistoricEntityInfo().name());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setHatchingTime(compound.method_10550("HatchingTime"));
        this.setPrehistoricEntityInfo(PrehistoricEntityInfo.valueOf(compound.method_10558("PrehistoricEntityInfo")));
    }

    public int getHatchingTime() {
        return (Integer)this.field_6011.method_12789(HATCHING_TIME);
    }

    public void setHatchingTime(int time) {
        this.field_6011.method_12778(HATCHING_TIME, (Object)time);
    }

    public boolean isGoldenEgg() {
        return (Boolean)this.field_6011.method_12789(GOLDEN_EGG);
    }

    public void setGoldenEgg(boolean goldenEgg) {
        this.field_6011.method_12778(GOLDEN_EGG, (Object)goldenEgg);
    }

    public int getTotalHatchingTime() {
        return this.isGoldenEgg() ? 2700 : 3000;
    }

    public PrehistoricEntityInfo getPrehistoricEntityInfo() {
        return this.prehistoricEntityInfo;
    }

    public void setPrehistoricEntityInfo(PrehistoricEntityInfo prehistoricEntityInfo) {
        this.prehistoricEntityInfo = prehistoricEntityInfo;
    }

    public void setScaleOverride(float scaleOverride) {
        this.scaleOverride = scaleOverride;
    }

    public float getScaleOverride() {
        return this.scaleOverride;
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return NetworkManager.createAddEntityPacket((class_1297)this);
    }

    public void saveAdditionalSpawnData(class_2540 buf) {
        buf.method_10817((Enum)this.getPrehistoricEntityInfo());
    }

    public void loadAdditionalSpawnData(class_2540 buf) {
        try {
            this.setPrehistoricEntityInfo((PrehistoricEntityInfo)buf.method_10818(PrehistoricEntityInfo.class));
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("Dinosaur egg {} has invalid dinosaur specified: {}", (Object)this.field_5981, (Object)e);
            this.setPrehistoricEntityInfo(PrehistoricEntityInfo.DODO);
        }
    }

    @NotNull
    public Iterable<class_1799> method_5661() {
        return ARMOR;
    }

    @NotNull
    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    @NotNull
    public class_1306 method_6068() {
        return class_1306.field_6183;
    }
}

