/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.darkpred.morehitboxes.api.EntityHitboxData;
import com.github.darkpred.morehitboxes.api.EntityHitboxDataFactory;
import com.github.darkpred.morehitboxes.api.GeckoLibMultiPartEntity;
import com.github.darkpred.morehitboxes.api.MultiPart;
import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.advancements.ModTriggers;
import com.github.teamfossilsarcheology.fossil.client.OptionalTextureLoader;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.LaserPointEntity;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoFollowOwnerGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoMatingGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoPanicGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoStayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatBlockGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatFromFeederGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatItemEntityGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.HuntingTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.PassiveFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.PlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.WhipSteering;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.PrehistoricLookControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.PrehistoricPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.PrehistoricWallClimberNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategoryLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationHolder;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.ClientAnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.data.AI;
import com.github.teamfossilsarcheology.fossil.entity.data.Attribute;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricDebug;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMoodType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.MoodSystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SitSystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SleepSystem;
import com.github.teamfossilsarcheology.fossil.entity.util.InstructionSystem;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.entity.variant.ConfigCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.DateCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.EntityVariantLoader;
import com.github.teamfossilsarcheology.fossil.entity.variant.NameTagCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.NbtCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.Variant;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantRegistry;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.network.C2SHitPlayerMessage;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.SyncedEntityDataHelper;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SDisableAIMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import it.unimi.dsi.fastutil.Pair;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1315;
import net.minecraft.class_1316;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1496;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_265;
import net.minecraft.class_2767;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class Prehistoric
extends class_1321
implements GeckoLibMultiPartEntity<Prehistoric>,
class_1316,
EntitySpawnExtension,
PrehistoricAnimatable<Prehistoric>,
PrehistoricDebug {
    private static final class_2940<class_2487> DEBUG = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13318);
    private static final class_2940<Boolean> EATING = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> MOOD = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> AGE_TICK = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> HUNGER = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FLEEING = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SITTING = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CLIMBING = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2350> CLIMBING_DIR = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13321);
    private static final class_2940<Boolean> AGING_DISABLED = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_2487> DIMENSION_VER = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13318);
    private static final class_2940<String> DATA_VARIANT = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Byte> GENDER = class_2945.method_12791(Prehistoric.class, (class_2941)class_2943.field_13319);
    private static final int GROW_UP_INTERVAL = 120;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final List<AISystem> aiSystems = new ArrayList<AISystem>();
    public final MoodSystem moodSystem = this.registerSystem(new MoodSystem(this));
    public final SleepSystem sleepSystem = this.registerSystem(this.createSleepSystem());
    public final SitSystem sitSystem = this.registerSystem(new SitSystem(this));
    protected final WhipSteering steering = new WhipSteering(this);
    private final AnimationLogic<Prehistoric> animationLogic = new AnimationLogic<Prehistoric>(this);
    private final InstructionSystem instructionSystem = this.registerSystem(new InstructionSystem(this));
    public final class_2960 animationLocation;
    private OrderType currentOrder = OrderType.WANDER;
    public class_2960 textureLocation;
    public int climbTick;
    public int prevClimbTick;
    public class_2350 prevClimbDirection = class_2350.field_11036;
    protected DinoMatingGoal matingGoal;
    protected float playerJumpPendingScale;
    private int fleeTicks = 0;
    private int matingCooldown = this.field_5974.method_43048(6000) + 6000;
    private int ticksClimbing = 0;
    private int climbingCooldown = 0;
    private class_243 eatPos;
    private final EntityHitboxData<Prehistoric> hitboxData = EntityHitboxDataFactory.create((class_1308)this);
    protected double swimSpeed;
    private boolean useLowerFluidJumpThreshold;
    private final Map<VariantRegistry.RegistryObject<?>, VariantCondition.WithVariant<?>> allVariants = new HashMap();
    private long synTime = -1L;
    private float scaleOverride = -1.0f;
    public static final byte TOTEM_PARTICLES = 35;
    public static final byte WHEAT_SEEDS_PARTICLES = 62;
    public static final byte BREAD_PARTICLES = 63;
    public static final byte BEEF_PARTICLES = 64;
    public static final byte HAPPY_VILLAGER_PARTICLES = 65;
    public static final byte GROW_UP_PARTICLES = 66;

    protected Prehistoric(class_1299<? extends Prehistoric> entityType, class_1937 level, class_2960 animationLocation) {
        super(entityType, level);
        this.animationLocation = animationLocation;
        this.field_6207 = new SmoothTurningMoveControl(this);
        this.field_6206 = new PrehistoricLookControl(this);
        this.method_18382();
        if (this.method_6046() == class_1310.field_6292) {
            this.method_5941(class_7.field_18, -1.0f);
            this.method_5942().method_6342().method_14(true);
        }
        this.method_5971();
    }

    protected Prehistoric(class_1299<? extends Prehistoric> entityType, class_1937 level) {
        this(entityType, level, FossilMod.location("animations/entity/" + class_1299.method_5890(entityType).method_12832() + ".animation.json"));
    }

    public EntityHitboxData<Prehistoric> getEntityHitboxData() {
        return this.hitboxData;
    }

    public boolean partHurt(MultiPart<Prehistoric> multiPart, @NotNull class_1282 damageSource, float v) {
        return this.method_5643(damageSource, v);
    }

    public void setAnchorPos(String boneName, class_243 localPos) {
        if ("eat_pos".equals(boneName)) {
            this.eatPos = this.method_19538().method_1019(localPos);
        }
    }

    public boolean canSetAnchorPos(String boneName) {
        return "eat_pos".equals(boneName);
    }

    public boolean attackBoxHit(class_1657 player) {
        MessageHandler.SYNC_CHANNEL.sendToServer((Object)new C2SHitPlayerMessage((class_1297)this, (class_1297)player));
        return true;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 0.0).method_26868(class_5134.field_23720, (double)0.4f);
    }

    protected void method_5959() {
        this.matingGoal = new DinoMatingGoal(this, 1.0);
        this.field_6201.method_6277(0, (class_1352)new DinoStayGoal(this));
        this.field_6201.method_6277(1, (class_1352)new DinoPanicGoal(this, this.attributes().sprintMod()));
        this.field_6201.method_6277(2, (class_1352)new class_1347((class_1308)this));
        if (this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.NONE && this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.JUMP) {
            this.field_6201.method_6277(6, new DelayedAttackGoal<Prehistoric>(this, this.attributes().sprintMod(), false));
        }
        this.field_6201.method_6277(12, (class_1352)this.matingGoal);
        if (this.data().diet() != Diet.PASSIVE) {
            this.field_6201.method_6277(15, (class_1352)new EatFromFeederGoal(this));
            this.field_6201.method_6277(16, (class_1352)new EatItemEntityGoal(this));
            this.field_6201.method_6277(17, (class_1352)new EatBlockGoal(this));
        } else {
            this.field_6201.method_6277(15, (class_1352)new PassiveFoodGoal(this));
        }
        this.field_6201.method_6277(18, (class_1352)new PlayGoal(this, this.attributes().sprintMod() - 0.15));
        this.field_6201.method_6277(20, (class_1352)new DinoFollowOwnerGoal(this, this.attributes().sprintMod(), 7.0f, 2.0f, false));
        this.field_6201.method_6277(21, (class_1352)new DinoWanderGoal(this, 1.0));
        this.field_6201.method_6277(25, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(26, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new DinoOwnerHurtByTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new DinoOwnerHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new DinoHurtByTargetGoal(this));
        this.field_6185.method_6277(5, (class_1352)new HuntingTargetGoal(this));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, LaserPointEntity.class, true));
    }

    protected void method_20417() {
        boolean enabled = !this.method_6113() && !this.isWeak();
        this.field_6201.method_6276(class_1352.class_4134.field_18405, enabled && !this.sitSystem.isSitting());
        this.field_6201.method_6276(class_1352.class_4134.field_18407, enabled && !this.sitSystem.isSitting());
        this.field_6201.method_6276(class_1352.class_4134.field_18406, enabled);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(EATING, (Object)false);
        this.field_6011.method_12784(MOOD, (Object)0);
        this.field_6011.method_12784(AGE_TICK, (Object)(this.data().adultAgeInTicks() - 1));
        this.field_6011.method_12784(HUNGER, (Object)0);
        this.field_6011.method_12784(FLEEING, (Object)false);
        this.field_6011.method_12784(SITTING, (Object)false);
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(CLIMBING, (Object)false);
        this.field_6011.method_12784(CLIMBING_DIR, (Object)class_2350.field_11036);
        this.field_6011.method_12784(AGING_DISABLED, (Object)false);
        this.field_6011.method_12784(DIMENSION_VER, (Object)new class_2487());
        this.field_6011.method_12784(DATA_VARIANT, (Object)"");
        this.field_6011.method_12784(GENDER, (Object)(this.field_5974.method_43056() ? (byte)1 : 0));
        class_2487 tag = new class_2487();
        tag.method_10556("disableGoalAI", false);
        tag.method_10556("disableMoveAI", false);
        tag.method_10556("disableLookAI", false);
        this.field_6011.method_12784(DEBUG, (Object)tag);
    }

    public void method_5674(class_2940<?> key) {
        block9: {
            block7: {
                class_2487 tag;
                block10: {
                    block8: {
                        if (!this.field_6002.field_9236) break block7;
                        if (!DATA_VARIANT.equals(key) && !SLEEPING.equals(key) && !AGE_TICK.equals(key) && !GENDER.equals(key)) break block8;
                        this.refreshTexturePath();
                        break block9;
                    }
                    if (!CLIMBING_DIR.equals(key)) break block10;
                    if (this.field_6011.method_12789(CLIMBING_DIR) != class_2350.field_11036) {
                        this.prevClimbDirection = (class_2350)this.field_6011.method_12789(CLIMBING_DIR);
                    }
                    break block9;
                }
                if (!DIMENSION_VER.equals(key) || !(tag = (class_2487)this.field_6011.method_12789(DIMENSION_VER)).method_10573("Width", 5) || !tag.method_10573("Height", 5)) break block9;
                this.field_18065 = class_4048.method_18385((float)tag.method_10583("Width"), (float)tag.method_10583("Height"));
                this.field_18066 = this.method_18378(this.method_18376(), this.field_18065);
                break block9;
            }
            if (AGE_TICK.equals(key)) {
                this.updateAbilities();
            } else if (field_6027.equals(key)) {
                for (VariantCondition.WithVariant<NameTagCondition> pair : this.variantsByCondition(NameTagCondition.class)) {
                    if (pair.condition().test((class_1297)this)) {
                        this.setVariant(VariantRegistry.NAME_TAG, pair);
                        break;
                    }
                    if (!this.allVariants.containsKey(VariantRegistry.NAME_TAG) || !Objects.equals(this.allVariants.get(VariantRegistry.NAME_TAG).condition(), pair.condition())) continue;
                    this.clearVariant(VariantRegistry.NAME_TAG);
                }
            }
        }
        if (AGE_TICK.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    public void saveAdditionalSpawnData(class_2540 buf) {
        buf.writeBoolean(this.getGender() == Gender.MALE);
        buf.writeInt(this.method_5618());
        buf.writeFloat(this.method_36455());
        buf.method_10814(this.getVariantId());
        this.instructionSystem.saveAdditionalSpawnData(buf);
    }

    public void loadAdditionalSpawnData(class_2540 buf) {
        if (buf.readBoolean()) {
            this.setGender(Gender.MALE);
        } else {
            this.setGender(Gender.FEMALE);
        }
        this.setAgeInTicks(buf.readInt());
        this.method_36457(buf.readFloat());
        this.setVariantId(buf.method_19772());
        this.refreshTexturePath();
        this.instructionSystem.loadAdditionalSpawnData(buf);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.aiSystems.forEach(system -> system.saveAdditional(compound));
        compound.method_10569("MatingCooldown", this.getMatingCooldown());
        compound.method_10569("Hunger", this.getHunger());
        compound.method_10556("Fleeing", this.isFleeing());
        compound.method_10556("Climbing", this.isClimbing());
        compound.method_10569("TicksClimbing", this.ticksClimbing);
        compound.method_10569("ClimbingCooldown", this.climbingCooldown);
        compound.method_10567("CurrentOrder", (byte)this.currentOrder.ordinal());
        compound.method_10548("YBodyRot", this.field_6283);
        compound.method_10548("YHeadRot", this.field_6241);
        compound.method_10556("AgingDisabled", this.isAgingDisabled());
        compound.method_10567("Gender", (byte)this.getGender().ordinal());
        compound.method_10582("VariantId", this.getVariantId());
        class_2499 saved = new class_2499();
        for (Map.Entry<VariantRegistry.RegistryObject<?>, VariantCondition.WithVariant<?>> entry : this.allVariants.entrySet()) {
            saved.add((Object)entry.getKey().save(new class_2487(), entry.getValue()));
        }
        compound.method_10566("Variants", (class_2520)saved);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.aiSystems.forEach(system -> system.load(compound));
        int savedAge = compound.method_10550("Age");
        this.setAgeInTicks(savedAge - savedAge % 120);
        this.setMatingCooldown(compound.method_10550("MatingCooldown"));
        this.setHunger(compound.method_10550("Hunger"));
        this.setFleeing(compound.method_10577("Fleeing"));
        this.setClimbing(compound.method_10577("Climbing"));
        this.ticksClimbing = compound.method_10550("TicksClimbing");
        this.climbingCooldown = compound.method_10550("ClimbingCooldown");
        if (compound.method_10573("CurrentOrder", 1)) {
            this.setCurrentOrder(OrderType.values()[compound.method_10571("CurrentOrder")]);
        }
        this.field_6283 = compound.method_10550("YBodyRot");
        this.field_6241 = compound.method_10550("YHeadRot");
        this.setAgingDisabled(compound.method_10577("AgingDisabled"));
        if (compound.method_10573("Gender", 8)) {
            if ("female".equalsIgnoreCase(compound.method_10558("Gender"))) {
                this.setGender(Gender.FEMALE);
            } else {
                this.setGender(Gender.MALE);
            }
        } else {
            this.setGender(Gender.values()[compound.method_10571("Gender")]);
        }
        if (compound.method_10573("VariantId", 8)) {
            this.setVariantId(compound.method_10558("VariantId"));
        }
        class_2499 saved = compound.method_10554("Variants", 10);
        this.allVariants.clear();
        for (class_2520 savedTag : saved) {
            VariantRegistry.RegistryObject<VariantCondition> type = VariantRegistry.RegistryObject.parse((class_2487)savedTag);
            this.allVariants.put(type, VariantCondition.WithVariant.of(type.serializer().load((class_2487)savedTag), this.variants().get(compound.method_10558("VariantId"))));
        }
    }

    public void method_5651(class_2487 compound) {
        super.method_5651(compound);
        for (VariantCondition.WithVariant<ConfigCondition> pair : this.variantsByCondition(ConfigCondition.class)) {
            if (pair.condition().test()) {
                this.setVariant(VariantRegistry.CONFIG, pair);
                break;
            }
            if (!this.allVariants.containsKey(VariantRegistry.CONFIG) || !Objects.equals(this.allVariants.get(VariantRegistry.CONFIG).condition(), pair.condition())) continue;
            this.clearVariant(VariantRegistry.CONFIG);
        }
    }

    public void method_18382() {
        class_4048 newDimensions;
        class_4048 oldDimensions = this.field_18065;
        class_4050 pose = this.method_18376();
        this.field_18065 = newDimensions = this.method_18377(pose);
        this.field_18066 = this.method_18378(pose, newDimensions);
        this.method_23311();
        if (!(this.field_6002.field_9236 || this.field_5953 || this.field_5960 || !(newDimensions.field_18067 > oldDimensions.field_18067) && !(newDimensions.field_18068 > oldDimensions.field_18068))) {
            double hDiff;
            double wDiff;
            class_243 vec3 = this.method_19538().method_1031(0.0, (double)oldDimensions.field_18068 / 2.0, 0.0);
            class_265 voxelShape = class_259.method_1078((class_238)class_238.method_30048((class_243)vec3, (double)(wDiff = Math.max(0.0, (double)(newDimensions.field_18067 - oldDimensions.field_18067)) + 1.0E-6), (double)(hDiff = Math.max(0.0, (double)(newDimensions.field_18068 - oldDimensions.field_18068)) + 1.0E-6), (double)wDiff));
            Optional opt = this.field_6002.method_33594((class_1297)this, voxelShape, vec3, (double)newDimensions.field_18067, (double)newDimensions.field_18068, (double)newDimensions.field_18067);
            if (opt.isPresent()) {
                this.method_33574(((class_243)opt.get()).method_1031(0.0, (double)(-newDimensions.field_18068) / 2.0, 0.0));
            } else {
                this.field_18065 = oldDimensions;
                this.field_18066 = this.method_18378(pose, oldDimensions);
                class_2487 tag = new class_2487();
                tag.method_10548("Width", this.field_18065.field_18067);
                tag.method_10548("Height", this.field_18065.field_18068);
                this.field_6011.method_12778(DIMENSION_VER, (Object)tag);
                this.method_23311();
            }
        }
        for (MultiPart part : this.getEntityHitboxData().getCustomParts()) {
            part.getEntity().method_18382();
        }
    }

    @NotNull
    public class_4048 method_18377(class_4050 poseIn) {
        return this.method_5864().method_18386().method_18383(this.method_17825());
    }

    protected class_4050 getTargetPose() {
        return this.method_6113() ? class_4050.field_18078 : class_4050.field_18076;
    }

    public void updatePose() {
        this.method_18380(this.getTargetPose());
    }

    public class_1315 method_5943(class_5425 levelIn, class_1266 difficultyIn, class_3730 reason, @Nullable class_1315 spawnDataIn, @Nullable class_2487 dataTag) {
        this.method_5996(class_5134.field_23717).method_26837(new class_1322("Random spawn bonus", this.field_5974.method_43059() * 0.05, class_1322.class_1323.field_6330));
        if (spawnDataIn instanceof PrehistoricGroupData) {
            PrehistoricGroupData prehistoricGroupData = (PrehistoricGroupData)spawnDataIn;
            this.setAgeInDays(prehistoricGroupData.ageInDays());
        } else if (spawnDataIn == null) {
            spawnDataIn = new PrehistoricGroupData(this.data().adultAgeDays());
            this.setAgeInDays(((PrehistoricGroupData)spawnDataIn).ageInDays);
        }
        this.updateAbilities();
        this.setHunger(this.getMaxHunger() / 2);
        this.method_18382();
        this.moodSystem.setPlayingCooldown(0);
        this.setMatingCooldown(24000);
        this.method_6025(this.method_6063());
        this.setCurrentOrder(OrderType.WANDER);
        this.method_5977(false);
        for (VariantCondition.WithVariant<ConfigCondition> withVariant : this.variantsByCondition(ConfigCondition.class)) {
            if (withVariant.condition().test()) {
                this.setVariant(VariantRegistry.CONFIG, withVariant);
                break;
            }
            if (!this.allVariants.containsKey(VariantRegistry.CONFIG) || !Objects.equals(this.allVariants.get(VariantRegistry.CONFIG).condition(), withVariant.condition())) continue;
            this.clearVariant(VariantRegistry.CONFIG);
        }
        for (VariantCondition.WithVariant<VariantCondition> withVariant : this.variantsByCondition(DateCondition.class)) {
            if (!((DateCondition)withVariant.condition()).test(this.field_5974, ZonedDateTime.now())) continue;
            this.setVariant(VariantRegistry.DATE, withVariant);
            break;
        }
        if (dataTag != null) {
            for (VariantCondition.WithVariant<VariantCondition> withVariant : this.variantsByCondition(NbtCondition.class)) {
                if (!((NbtCondition)withVariant.condition()).test(dataTag)) continue;
                this.setVariant(VariantRegistry.NBT, withVariant);
                break;
            }
        }
        return spawnDataIn;
    }

    public OrderType getCurrentOrder() {
        return this.currentOrder;
    }

    public void setCurrentOrder(OrderType newOrder) {
        this.currentOrder = newOrder;
    }

    public boolean method_6062() {
        return super.method_6062() || this.isWeak() || this.method_6113() || this.sitSystem.isSitting();
    }

    public void method_5762(double x, double y, double z) {
        class_4048 dimensions = this.method_18377(class_4050.field_18076);
        float max = Math.max(dimensions.field_18067, dimensions.field_18068);
        if (max < 3.0f) {
            float mult = class_3532.method_16439((float)((Math.max(max, 1.0f) - 1.0f) / 2.0f), (float)1.0f, (float)0.0f);
            super.method_5762(x * (double)mult, y, z * (double)mult);
        }
    }

    public boolean method_5810() {
        return super.method_5810() && !this.method_5782();
    }

    public boolean hasTarget() {
        return this.method_5968() != null || this.moodSystem.getToyTarget() != null;
    }

    public float method_6144(class_2338 pos, class_4538 level) {
        return 0.0f;
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean method_5931(class_1657 player) {
        return super.method_5931(player) && this.method_6171((class_1309)player);
    }

    @Nullable
    public class_1657 getRidingPlayer() {
        class_1657 player;
        class_1297 class_12972 = this.method_5642();
        return class_12972 instanceof class_1657 ? (player = (class_1657)class_12972) : null;
    }

    public double method_5621() {
        return (double)this.method_17682() * 0.85;
    }

    public void method_5865(class_1297 passenger) {
        super.method_5865(passenger);
        if (this.canBeControlledByRider() && passenger instanceof class_1309) {
            class_1309 livingEntity = (class_1309)passenger;
            this.field_6283 = livingEntity.field_6241;
        }
        this.getEntityHitboxData().getAnchorData().getAnchorPos("rider_pos").ifPresentOrElse(pos -> {
            if (passenger instanceof class_1657) {
                passenger.method_5814(pos.field_1352, pos.field_1351 + passenger.method_5678() - 0.2, pos.field_1350);
            } else {
                passenger.method_5814(pos.field_1352, pos.field_1351 + passenger.method_5678(), pos.field_1350);
            }
        }, () -> passenger.method_5814(this.method_23317(), this.method_23318() + this.method_5621() + passenger.method_5678(), this.method_23321()));
    }

    public double getJumpStrength() {
        return 0.3;
    }

    private void doJump(double upwardMovement, double forwardMovement) {
        this.field_6007 = true;
        if (forwardMovement > 0.0) {
            float h = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
            float i = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
            this.method_18799(this.method_18798().method_1031((double)(-0.4f * h * this.playerJumpPendingScale), upwardMovement, (double)(0.4f * i * this.playerJumpPendingScale)));
        } else {
            this.method_18800(this.method_18798().field_1352, upwardMovement, this.method_18798().field_1350);
        }
    }

    public boolean method_6153(class_1657 player) {
        return this.method_5782();
    }

    public void method_6155(int i) {
        this.method_5783(class_3417.field_14831, 0.4f, 1.0f);
    }

    public void method_6156() {
    }

    public void method_6154(int jumpPower) {
        this.playerJumpPendingScale = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
    }

    public boolean canBeControlledByRider() {
        class_1309 rider;
        class_1297 class_12972;
        return this.data().canBeRidden() && (class_12972 = this.method_5642()) instanceof class_1309 && this.method_6171(rider = (class_1309)class_12972);
    }

    public void method_6091(class_243 travelVector) {
        boolean fastInWater;
        if (this.method_6062() && !this.method_5782()) {
            super.method_6091(class_243.field_1353);
            return;
        }
        class_1309 rider = (class_1309)this.method_5642();
        if (rider == null || !this.canBeControlledByRider() || !this.steering.trySteering(rider)) {
            super.method_6091(travelVector);
            return;
        }
        this.method_36456(rider.method_36454());
        this.field_5982 = this.method_36454();
        this.method_36457(rider.method_36455() * 0.5f);
        this.method_5710(this.method_36454(), this.method_36455());
        this.field_6283 = this.method_36454();
        this.field_6241 = this.method_36454();
        float newStrafeMovement = rider.field_6212 * 0.5f;
        float newForwardMovement = rider.field_6250;
        boolean bl = fastInWater = this.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC || this.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC;
        if (this.playerJumpPendingScale > 0.0f) {
            double newYMovement = this.getJumpStrength() * (double)this.playerJumpPendingScale * (double)this.method_23313() + this.method_37416();
            if (this.method_5799()) {
                if (fastInWater) {
                    this.doJump(newYMovement, newForwardMovement);
                } else {
                    this.doJump(newYMovement / 2.0, newForwardMovement / 2.0f);
                }
            } else if (this.method_24828()) {
                this.doJump(newYMovement, newForwardMovement);
            }
            this.playerJumpPendingScale = 0.0f;
        }
        if (this.method_5787()) {
            this.method_6125((float)this.method_26825(class_5134.field_23719));
            class_243 newMovement = new class_243((double)newStrafeMovement, travelVector.field_1351, (double)newForwardMovement).method_1021(0.5);
            if (this.method_5799()) {
                this.steering.slowWaterTravel(newMovement);
            } else {
                super.method_6091(newMovement);
            }
        } else {
            this.method_18799(class_243.field_1353);
            this.method_29242((class_1309)this, this instanceof class_1432);
        }
        if (this.method_24828()) {
            this.playerJumpPendingScale = 0.0f;
        }
    }

    @Nullable
    public class_1297 method_5642() {
        for (class_1297 passenger : this.method_5685()) {
            class_1657 player;
            if (!(passenger instanceof class_1657) || !this.method_6171((class_1309)(player = (class_1657)passenger)) || this.method_5968() == passenger) continue;
            return player;
        }
        return null;
    }

    public boolean method_5788() {
        return true;
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        if (this.aiClimbType() == PrehistoricEntityInfoAI.Climbing.ARTHROPOD || this.aiMovingType() == PrehistoricEntityInfoAI.Moving.WALK_AND_GLIDE || this.aiMovingType() == PrehistoricEntityInfoAI.Moving.FLIGHT) {
            return false;
        }
        return super.method_5747(distance, damageMultiplier, source);
    }

    public double method_29241() {
        if (this.useLowerFluidJumpThreshold) {
            return super.method_29241();
        }
        return 0.7 * (double)this.method_17682();
    }

    private void setUseLowerFluidJumpThreshold(boolean b) {
        this.useLowerFluidJumpThreshold = b;
    }

    public void method_5728(boolean sprinting) {
        super.method_5728(sprinting);
        class_1324 attributeInstance = this.method_5996(class_5134.field_23719);
        if (attributeInstance.method_6199(UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D")) != null) {
            attributeInstance.method_6200(UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D"));
        }
    }

    protected void method_5958() {
        super.method_5958();
        if (this.method_5799() && this.field_5976) {
            this.setUseLowerFluidJumpThreshold(true);
        }
    }

    public void method_6007() {
        this.method_6119();
        super.method_6007();
        this.field_6013 = this.getRidingPlayer() != null ? 1.0f : 0.6f;
        if (!this.field_6002.field_9236) {
            if (this.synTime > 0L && this.synTime >= this.field_6002.method_8510()) {
                this.synTime = -1L;
                ((SyncedEntityDataHelper)this.method_5841()).fossilsArcheologyRevival$markNonDefaultAsDirty();
            }
            this.method_5728(this.method_18798().method_37267() > 0.1 && this.method_5962().method_6242() >= this.attributes().sprintMod());
            if (this.getHunger() > this.getMaxHunger()) {
                this.setHunger(this.getMaxHunger());
            }
            if (this.getMatingCooldown() > 0) {
                this.setMatingCooldown(this.getMatingCooldown() - 1);
            }
            if (FossilConfig.isEnabled("healingDinos") && this.field_5974.method_43048(500) == 0 && this.field_6213 == 0) {
                this.method_6025(1.0f);
            }
            if (Version.debugEnabled()) {
                MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)((class_3218)this.field_6002).method_18766(serverPlayer -> serverPlayer.method_5739((class_1297)this) < 16.0f), (Object)new SyncDebugInfoMessage(this.method_5628(), this.getGender().name(), this.method_5618(), this.matingCooldown, this.moodSystem.getPlayingCooldown(), this.climbingCooldown, this.getHunger(), this.moodSystem.getMood()));
            }
            this.aiSystems.forEach(AISystem::serverTick);
            if (this.field_5976 && this.data().breaksBlocks() && this.moodSystem.getMood() < 0) {
                this.breakBlock((float)FossilConfig.getDouble("blockBreakHardness"));
            }
            if (this.isFleeing()) {
                ++this.fleeTicks;
                if (this.fleeTicks > this.getFleeingCooldown()) {
                    this.setFleeing(false);
                    this.fleeTicks = 0;
                }
            }
        } else {
            this.aiSystems.forEach(AISystem::clientTick);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            this.prevClimbTick = this.climbTick;
            this.climbTick = this.isClimbing() ? Math.min(5, this.climbTick + 1) : Math.max(0, this.climbTick - 1);
        } else {
            if (!this.isAgingDisabled() && this.canAgeUpNaturally()) {
                this.setAgeInTicks(this.method_5618() + 1);
            }
            if (this.field_6012 % 1200 == 0 && this.getHunger() > 0 && FossilConfig.isEnabled("enableHunger")) {
                if (!this.method_5987()) {
                    this.setHunger(this.getHunger() - 1);
                } else {
                    this.setHunger(this.getMaxHunger());
                    this.method_6033(this.method_6063());
                }
            }
            if (this.field_6012 % 40 == 0 && this.getHunger() == 0) {
                float f = this.method_6032();
                float f2 = FossilConfig.isEnabled("enableStarvation") ? 0.0f : this.method_6063() / 2.0f;
                if (f > f2) {
                    this.method_5643(class_1282.field_5852, 1.0f);
                }
            }
            if (this.aiClimbType() == PrehistoricEntityInfoAI.Climbing.ARTHROPOD) {
                if (this.isClimbing()) {
                    boolean onCooldown;
                    ++this.ticksClimbing;
                    boolean bl = onCooldown = this.ticksClimbing >= 100 || this.field_6002.method_8320(this.method_24515().method_10084()).method_26207().method_15799();
                    if (!this.field_5976 || onCooldown) {
                        this.stopClimbing();
                        this.ticksClimbing = 0;
                        if (onCooldown) {
                            this.climbingCooldown = 900;
                        }
                    } else {
                        Pair<class_2350, Double> dir = Util.getClosestSide(this.method_5829(), this.method_24515());
                        this.field_6011.method_12778(CLIMBING_DIR, (Object)((class_2350)dir.key()));
                        if (this.method_18798().method_37267() < (double)1.0E-5f) {
                            this.method_36456(((class_2350)dir.key()).method_10144());
                        }
                    }
                } else {
                    --this.climbingCooldown;
                    if (this.canClimb()) {
                        this.ticksClimbing = 0;
                        this.setClimbing(true);
                    }
                }
            }
        }
    }

    protected boolean canClimb() {
        return this.climbingCooldown <= 0 && this.field_5976 && !this.sleepSystem.wantsToSleep() && !this.method_6113();
    }

    public void setScaleOverride(float scaleOverride) {
        this.scaleOverride = scaleOverride;
    }

    public float method_17825() {
        if (this.scaleOverride > 0.0f) {
            return this.scaleOverride;
        }
        if (this.isAdult()) {
            return this.data().maxScale() * this.getGenderedScale();
        }
        float step = (this.data().maxScale() - this.data().minScale()) / (float)(this.data().adultAgeInTicks() + 1);
        return (this.data().minScale() + step * (float)this.method_5618()) * this.getGenderedScale();
    }

    public float getGenderedScale() {
        return 1.0f;
    }

    public int method_6110() {
        float base = 6.0f * this.method_17681() * (float)(this.data().diet() == Diet.HERBIVORE ? 1 : 2) * (float)(this.aiTameType() == PrehistoricEntityInfoAI.Taming.GEM ? 2 : 1) * (this.aiAttackType() == PrehistoricEntityInfoAI.Attacking.BASIC ? 1.0f : 1.25f);
        return class_3532.method_15375((float)((float)Math.min(this.data().adultAgeDays(), this.getAgeInDays()) * base));
    }

    public void updateAbilities() {
        float scale = this.data().minScale() + (this.data().maxScale() - this.data().minScale()) / (float)this.data().adultAgeInTicks() * (float)this.method_5618();
        scale = Math.min(scale, this.data().maxScale());
        double percent = Math.min((double)this.method_5618() / (double)this.data().adultAgeInTicks(), 1.0);
        this.method_5996(class_5134.field_23718).method_6192(class_3532.method_16436((double)percent, (double)this.attributes().baseKnockBackResistance(), (double)this.attributes().maxKnockBackResistance()));
        double speed = Util.calculateSpeed(this.data(), scale, false);
        double healthDifference = this.method_26825(class_5134.field_23716);
        this.method_5996(class_5134.field_23716).method_6192((double)Math.round(class_3532.method_16436((double)percent, (double)this.attributes().baseHealth(), (double)this.attributes().maxHealth())));
        healthDifference = this.method_26825(class_5134.field_23716) - healthDifference;
        if (healthDifference > 0.0) {
            this.method_6025((float)healthDifference);
        }
        this.method_5996(class_5134.field_23721).method_6192((double)Math.round(class_3532.method_16436((double)percent, (double)this.attributes().baseDamage(), (double)this.attributes().maxDamage())));
        this.method_5996(class_5134.field_23719).method_6192(speed);
        this.swimSpeed = Util.calculateSpeed(this.data(), scale, true);
        this.method_5996(class_5134.field_23724).method_6192(class_3532.method_16436((double)percent, (double)this.attributes().baseArmor(), (double)this.attributes().maxArmor()));
    }

    public void breakBlock(float maxHardness) {
        if (!FossilConfig.isEnabled("dinosBreakBlocks") || !this.field_6002.method_8450().method_8355(class_1928.field_19388)) {
            return;
        }
        if (!this.isAdult() || !this.isHungry()) {
            return;
        }
        class_238 aabb = this.method_5829().method_1009(0.1, 0.0, 0.1);
        boolean waterMob = this instanceof PrehistoricSwimming;
        int lowest = class_3532.method_15357((double)aabb.field_1322) + (waterMob ? 0 : 1);
        for (class_2338 targetPos : class_2338.method_10094((int)class_3532.method_15357((double)aabb.field_1323), (int)lowest, (int)class_3532.method_15357((double)aabb.field_1321), (int)class_3532.method_15357((double)aabb.field_1320), (int)class_3532.method_15384((double)aabb.field_1325), (int)class_3532.method_15357((double)aabb.field_1324))) {
            if (!Util.canBreak(this.field_6002, targetPos, maxHardness)) continue;
            this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            this.field_6002.method_8651(targetPos, this.field_5974.method_43048(10) == 0, (class_1297)this);
            if (!waterMob || targetPos.method_10264() != lowest || !this.method_5799()) continue;
            this.field_6002.method_8652(targetPos, class_2246.field_10382.method_9564(), 3);
        }
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void method_18403(class_2338 pos) {
    }

    public void method_18400() {
    }

    public boolean method_6101() {
        return this.aiClimbType() == PrehistoricEntityInfoAI.Climbing.ARTHROPOD && this.isClimbing();
    }

    public boolean isClimbing() {
        return (Boolean)this.field_6011.method_12789(CLIMBING);
    }

    public void setClimbing(boolean climbing) {
        this.field_6011.method_12778(CLIMBING, (Object)climbing);
    }

    public void stopClimbing() {
        this.setClimbing(false);
        this.field_6011.method_12778(CLIMBING_DIR, (Object)class_2350.field_11036);
    }

    public class_2350 getClimbingDirection() {
        return (class_2350)this.field_6011.method_12789(CLIMBING_DIR);
    }

    public boolean isFleeing() {
        return (Boolean)this.field_6011.method_12789(FLEEING);
    }

    public void setFleeing(boolean fleeing) {
        this.field_6011.method_12778(FLEEING, (Object)fleeing);
    }

    protected int getFleeingCooldown() {
        if (this.method_6065() != null) {
            int i = (int)(Math.max(this.method_6065().method_17681() / 2.0f, 1.0f) * 95.0f);
            int j = (int)(Math.min((double)(this.method_17681() / 2.0f), 0.5) * 50.0);
            return i - j;
        }
        return 100;
    }

    public boolean isAdult() {
        return this.getAgeInDays() >= this.data().adultAgeDays();
    }

    public boolean isTeen() {
        return this.getAgeInDays() >= this.data().teenAgeDays() && this.getAgeInDays() < this.data().adultAgeDays();
    }

    public boolean method_6109() {
        return this.getAgeInDays() < this.data().teenAgeDays();
    }

    public int getAgeInDays() {
        return this.method_5618() / 24000;
    }

    public void setAgeInDays(int days) {
        this.setAgeInTicks(days * 24000);
    }

    public int method_5618() {
        return this.field_6002.field_9236 ? (Integer)this.field_6011.method_12789(AGE_TICK) : this.field_5950;
    }

    public void method_5614(int age) {
    }

    public void setAgeInTicks(int age) {
        if (this.isAgingDisabled()) {
            return;
        }
        if (this.field_6012 % 120 == 0 || age > this.field_5950 + 120 || age < this.field_5950 - 120) {
            this.field_5950 = age;
            this.field_6011.method_12778(AGE_TICK, (Object)age);
        } else {
            this.field_5950 = age;
        }
    }

    public void grow(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.updateAbilities();
        this.field_6002.method_8421((class_1297)this, (byte)66);
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.field_6011.method_12789(AGING_DISABLED);
    }

    protected boolean canAgeUpNaturally() {
        return true;
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.field_6011.method_12778(AGING_DISABLED, (Object)isAgingDisabled);
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (otherAnimal == this || otherAnimal.getClass() != this.getClass() || this.moodSystem.getMood() <= 50 || !this.isAdult() || this.getMatingCooldown() > 0) {
            return false;
        }
        Prehistoric other = (Prehistoric)otherAnimal;
        return other.getGender() != this.getGender() && other.isAdult() && other.getMatingCooldown() <= 0 && other.moodSystem.getMood() > 50 && (this.matingGoal.getPartner() == null || this.matingGoal.getPartner() == otherAnimal);
    }

    public class_1296 method_5613(class_3218 serverLevel, class_1296 otherParent) {
        class_1297 baby;
        if (otherParent instanceof Prehistoric && (baby = this.info().entityType().method_5883(this.field_6002)) instanceof Prehistoric) {
            Prehistoric prehistoricBaby = (Prehistoric)baby;
            prehistoricBaby.method_5943((class_5425)this.field_6002, this.field_6002.method_8404(this.method_24515()), class_3730.field_16466, new PrehistoricGroupData(0), null);
            prehistoricBaby.grow(0);
            return prehistoricBaby;
        }
        return null;
    }

    public void procreate(Prehistoric other) {
        if (this.getGender() == Gender.MALE) {
            this.method_5980(null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (this.field_5974.method_43048(100) == 0 || calendar.get(2) + 1 == 4 && calendar.get(5) == 1) {
            this.method_5783((class_3414)ModSounds.MUSIC_MATING.get(), 1.0f, 1.0f);
        }
        if (!this.field_6002.field_9236) {
            class_1297 hatchling;
            if (this.info().mobType == PrehistoricMobType.MAMMAL) {
                hatchling = this.method_5864().method_5883(this.field_6002);
            } else if (this.info().birdEggItem != null) {
                hatchling = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)this.info().birdEggItem));
            } else if (FossilConfig.isEnabled("eggsLikeChickens") || this.info().isViviparousAquatic()) {
                hatchling = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)this.info().eggItem));
            } else {
                hatchling = ((class_1299)ModEntities.DINOSAUR_EGG.get()).method_5883(this.field_6002);
                ((DinosaurEgg)hatchling).setPrehistoricEntityInfo(this.info());
                class_1309 class_13092 = this.method_6177();
                if (class_13092 instanceof class_3222) {
                    class_3222 player = (class_3222)class_13092;
                    class_161 adv = ((class_3218)this.field_6002).method_8503().method_3851().method_12896(DinosaurEgg.GOLDEN_EGG_ADV);
                    if (adv != null && player.method_14236().method_12882(adv).method_740()) {
                        ((DinosaurEgg)hatchling).setGoldenEgg((double)this.field_5974.method_43057() < 0.05);
                    }
                }
            }
            this.method_5980(null);
            hatchling.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.field_6283, 0.0f);
            if (hatchling instanceof Prehistoric) {
                Prehistoric prehistoricHatchling = (Prehistoric)hatchling;
                prehistoricHatchling.method_5943((class_5425)this.field_6002, this.field_6002.method_8404(this.method_24515()), class_3730.field_16466, new PrehistoricGroupData(0), null);
                prehistoricHatchling.grow(0);
            }
            this.field_6002.method_8649(hatchling);
        }
    }

    public int getMatingCooldown() {
        return this.matingCooldown;
    }

    public void setMatingCooldown(int cooldown) {
        this.matingCooldown = cooldown;
    }

    public Gender getGender() {
        return Gender.values()[(Byte)this.field_6011.method_12789(GENDER)];
    }

    public void setGender(@NotNull Gender gender) {
        this.field_6011.method_12778(GENDER, (Object)((byte)gender.ordinal()));
    }

    public String getVariantId() {
        return (String)this.field_6011.method_12789(DATA_VARIANT);
    }

    private void setVariantId(@NotNull String variant) {
        this.field_6011.method_12778(DATA_VARIANT, (Object)variant);
    }

    private void clearVariant(VariantRegistry.RegistryObject<?> type) {
        if (this.allVariants.containsKey(type)) {
            String removedVariant = this.allVariants.get(type).variant().getVariantId();
            if (((String)this.field_6011.method_12789(DATA_VARIANT)).equals(removedVariant)) {
                this.field_6011.method_12778(DATA_VARIANT, (Object)"");
            }
        }
        this.allVariants.remove(type);
        VariantRegistry.getHighestPriority(this.allVariants).ifPresent(variant -> this.field_6011.method_12778(DATA_VARIANT, (Object)variant.getVariantId()));
    }

    private <T extends VariantCondition> void setVariant(VariantRegistry.RegistryObject<?> type, @NotNull VariantCondition.WithVariant<T> pair) {
        this.allVariants.put(type, pair);
        VariantRegistry.getHighestPriority(this.allVariants).ifPresent(variant -> this.field_6011.method_12778(DATA_VARIANT, (Object)variant.getVariantId()));
    }

    public int getClimbingCooldown() {
        return this.climbingCooldown;
    }

    public void setClimbingCooldown(int cooldown) {
        this.climbingCooldown = cooldown;
    }

    public boolean isWeak() {
        return (this.aiTameType() == PrehistoricEntityInfoAI.Taming.AQUATIC_GEM || this.aiTameType() == PrehistoricEntityInfoAI.Taming.GEM) && this.method_6032() < 8.0f && this.isAdult() && !this.method_6181();
    }

    public int getMaxHunger() {
        return this.data().maxHunger();
    }

    public boolean isHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * 0.75f;
    }

    public boolean isDeadlyHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * 0.25f;
    }

    public int getHunger() {
        return (Integer)this.field_6011.method_12789(HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_6011.method_12778(HUNGER, (Object)Math.min(hunger, this.getMaxHunger()));
    }

    public boolean eatItem(class_1799 stack) {
        if (stack != null && FoodMappings.getFoodAmount((class_1935)stack.method_7909(), this.data().diet()) != 0) {
            this.moodSystem.increaseMood(5);
            this.feed(FoodMappings.getFoodAmount((class_1935)stack.method_7909(), this.data().diet()));
            stack.method_7934(1);
            this.animationLogic.triggerAnimation("Movement/Idle", this.getAnimation(AnimationCategory.EAT), AnimationCategory.EAT);
            return true;
        }
        return false;
    }

    public void feed(int foodAmount) {
        this.setHunger(this.getHunger() + foodAmount);
    }

    public boolean method_5874(class_3218 level, class_1309 killedEntity) {
        if (super.method_5874(level, killedEntity)) {
            if (this.data().diet() != Diet.HERBIVORE) {
                this.feed(FoodMappings.getMobFoodPoints(killedEntity, this.data().diet()));
                this.method_6025((float)FoodMappings.getMobFoodPoints(killedEntity, this.data().diet()) / 10.0f);
                this.moodSystem.increaseMood(25);
            }
            return true;
        }
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == class_1282.field_5855) {
            return false;
        }
        boolean hurt = super.method_5643(source, amount);
        if (hurt) {
            class_1309 class_13092 = this.method_6065();
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                if (this.method_6177() == player && this.moodSystem.getMoodFace() == PrehistoricMoodType.SAD) {
                    this.method_6174(null);
                    this.method_6173(false);
                    this.moodSystem.increaseMood(-15);
                    player.method_7353((class_2561)class_2561.method_43469((String)"entity.fossil.situation.betrayed", (Object[])new Object[]{this.method_5477()}), true);
                }
            }
            if (amount > 0.0f) {
                this.sleepSystem.setSleeping(false);
            }
            if (source.method_5529() != null) {
                this.moodSystem.increaseMood(-5);
            }
        }
        return hurt;
    }

    protected void method_6175() {
        if (!this.method_6181()) {
            this.setCurrentOrder(OrderType.WANDER);
        }
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960()) {
            return class_1269.field_5811;
        }
        if (this.isWeak() && (this.aiTameType() == PrehistoricEntityInfoAI.Taming.GEM && stack.method_31574((class_1792)ModItems.SCARAB_GEM.get()) || this.aiTameType() == PrehistoricEntityInfoAI.Taming.AQUATIC_GEM && stack.method_31574((class_1792)ModItems.AQUATIC_SCARAB_GEM.get()))) {
            if (!this.field_6002.field_9236) {
                ModTriggers.SCARAB_TAME_TRIGGER.trigger((class_3222)player);
                this.method_6025(200.0f);
                this.moodSystem.setMood(100);
                this.feed(500);
                this.method_5942().method_6340();
                this.method_5980(null);
                this.method_6015(null);
                this.method_6170(player);
                this.field_6002.method_8421((class_1297)this, (byte)35);
                stack.method_7934(1);
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (stack.method_31574((class_1792)ModItems.CHICKEN_ESSENCE.get()) && this.aiTameType() != PrehistoricEntityInfoAI.Taming.GEM && this.aiTameType() != PrehistoricEntityInfoAI.Taming.AQUATIC_GEM) {
            if (!this.field_6002.field_9236) {
                if (this.isAdult()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"prehistoric.essence_fail_adult"), true);
                    return class_1269.field_5811;
                }
                if (this.isDeadlyHungry()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"prehistoric.essence_fail_hungry"), true);
                    return class_1269.field_5811;
                }
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                    player.method_7270(new class_1799((class_1935)class_1802.field_8469, 1));
                }
                this.grow(1);
                this.setHunger(1 + this.field_5974.method_43048(this.getHunger()));
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (stack.method_31574((class_1792)ModItems.STUNTED_ESSENCE.get()) && !this.isAgingDisabled()) {
            if (!this.field_6002.field_9236) {
                this.setHunger(this.getHunger() + 20);
                this.method_6025(this.method_6063());
                this.setAgingDisabled(true);
                stack.method_7934(1);
                this.method_5783(class_3417.field_14905, this.method_6107(), this.method_6017());
            } else {
                class_238 aabb = this.eatPos == null ? this.method_5830() : new class_238(this.eatPos, this.eatPos);
                Util.spawnItemParticles(this.field_6002, stack.method_7909(), 15, aabb);
                Util.spawnItemParticles(this.field_6002, stack.method_7909(), 15, aabb);
                Util.spawnItemParticles(this.field_6002, class_1802.field_8635, 15, aabb);
                Util.spawnItemParticles(this.field_6002, class_1802.field_8635, 15, aabb);
                Util.spawnItemParticles(this.field_6002, class_1802.field_8803, 15, aabb);
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (FoodMappings.getFoodAmount((class_1935)stack.method_7909(), this.data().diet()) > 0) {
            if (this.getHunger() < this.getMaxHunger() || this.method_6032() < this.method_6063() && FossilConfig.isEnabled("healingDinos") || !this.method_6181() && this.aiTameType() == PrehistoricEntityInfoAI.Taming.FEEDING) {
                if (!this.field_6002.field_9236 && this.eatItem(stack)) {
                    if (FossilConfig.isEnabled("healingDinos")) {
                        this.method_6025(3.0f);
                    }
                    if (this.getHunger() >= this.getMaxHunger() && this.method_6181()) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"entity.fossil.situation.full", (Object[])new Object[]{this.method_5477()}), true);
                    }
                    if (this.aiTameType() == PrehistoricEntityInfoAI.Taming.FEEDING && !this.method_6181() && this.field_5974.method_43048(10) == 1) {
                        this.method_6170(player);
                        this.field_6002.method_8421((class_1297)this, (byte)35);
                    }
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
        } else {
            if (stack.method_31574((class_1792)ModItems.WHIP.get()) && this.aiTameType() != PrehistoricEntityInfoAI.Taming.NONE && this.isAdult()) {
                if (this.method_6171((class_1309)player) && this.data().canBeRidden()) {
                    if (!this.field_6002.field_9236 && this.getRidingPlayer() == null) {
                        player.field_6283 = this.field_6283;
                        player.method_36457(this.method_36455());
                        player.method_5804((class_1297)this);
                        this.sitSystem.setSitting(false);
                        this.sleepSystem.setSleeping(false);
                        this.setCurrentOrder(OrderType.WANDER);
                    } else if (this.getRidingPlayer() == player) {
                        this.method_5728(true);
                        this.moodSystem.increaseMood(-5);
                    }
                } else if (FossilConfig.isEnabled("whipToTameDino") && !this.method_6181() && this.aiTameType() != PrehistoricEntityInfoAI.Taming.AQUATIC_GEM && this.aiTameType() != PrehistoricEntityInfoAI.Taming.GEM && !this.field_6002.field_9236) {
                    this.moodSystem.increaseMood(-5);
                    if (this.field_5974.method_43048(5) == 0) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"entity.fossil.prehistoric.tamed", (Object[])new Object[]{this.info().displayName.get()}), true);
                        this.moodSystem.increaseMood(-25);
                        this.method_6170(player);
                    }
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (stack.method_31574(this.getOrderItem()) && this.method_6171((class_1309)player) && !player.method_5765()) {
                if (!this.field_6002.field_9236) {
                    this.field_6282 = false;
                    this.method_5942().method_6340();
                    this.setCurrentOrder(OrderType.values()[(this.currentOrder.ordinal() + 1) % 3]);
                    this.sendOrderMessage(this.currentOrder);
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    private void sendOrderMessage(OrderType orderType) {
        class_1309 class_13092 = this.method_6177();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            player.method_7353((class_2561)class_2561.method_43469((String)("entity.fossil.order." + orderType.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{this.method_5477()}), true);
        }
    }

    protected boolean hasTeenTexture() {
        return OptionalTextureLoader.INSTANCE.hasTeenTexture(this.info().resourceName);
    }

    public void refreshTexturePath() {
        if (!this.field_6002.field_9236) {
            return;
        }
        String name = this.method_5864().arch$registryName().method_12832();
        StringBuilder builder = new StringBuilder();
        builder.append("textures/entity/");
        builder.append(name);
        builder.append("/");
        builder.append(name);
        String variantId = this.getVariantId();
        if (!variantId.isBlank() && this.variants().containsKey(variantId)) {
            this.variants().get(variantId).appendTextureString(builder, this);
        } else {
            if (this.method_6109()) {
                builder.append("_baby");
            }
            if (this.hasTeenTexture() && this.isTeen()) {
                builder.append("_teen");
            }
            if (!this.hasTeenTexture() && this.isTeen() || this.isAdult()) {
                if (this.getGender() == Gender.MALE) {
                    builder.append("_male");
                } else {
                    builder.append("_female");
                }
            }
        }
        if (this.method_6113() || this.isWeak()) {
            builder.append("_sleeping");
        }
        builder.append(".png");
        this.textureLocation = FossilMod.location(builder.toString());
    }

    public boolean method_18395(class_1309 target) {
        class_1321 tamableAnimal;
        if (this.method_6171(target) && this.moodSystem.getMoodFace() != PrehistoricMoodType.ANGRY) {
            return false;
        }
        if (target instanceof class_1657 && this.field_6002.method_8407() == class_1267.field_5801) {
            return false;
        }
        if (this.method_6181() && target instanceof class_1321 && (tamableAnimal = (class_1321)target).method_6177() == this.method_6177()) {
            return false;
        }
        return target.method_33190();
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        if (target instanceof class_1548 || target instanceof class_1571) {
            return false;
        }
        if (target instanceof class_1657 && owner instanceof class_1657 && !((class_1657)owner).method_7256((class_1657)target)) {
            return false;
        }
        return !(target instanceof class_1496) || !((class_1496)target).method_6727();
    }

    public float getTargetScale() {
        return 1.0f;
    }

    @NotNull
    protected class_1408 method_5965(class_1937 levelIn) {
        return this.aiClimbType() == PrehistoricEntityInfoAI.Climbing.ARTHROPOD ? new PrehistoricWallClimberNavigation(this, levelIn) : new PrehistoricPathNavigation(this, levelIn);
    }

    @NotNull
    protected SleepSystem createSleepSystem() {
        return new SleepSystem(this);
    }

    protected <T extends AISystem> T registerSystem(T system) {
        this.aiSystems.add(system);
        return system;
    }

    public List<? extends Prehistoric> getNearbySpeciesMembers(int range) {
        return this.field_6002.method_8390(this.getClass(), this.method_5829().method_1009((double)range, 4.0, (double)range), prehistoric -> prehistoric != this);
    }

    public void method_5966() {
        if (this.method_6113() || this.field_6002.field_9236) {
            return;
        }
        if (this.method_5869()) {
            class_3414 soundEvent = this.method_5994();
            if (soundEvent != null) {
                float volume = this.method_6107();
                double radius = volume > 1.0f ? (double)(16.0f * volume) : 16.0;
                class_2767 packet = new class_2767(class_7923.field_41172.method_47983((Object)soundEvent), this.method_5634(), this.method_23317(), this.method_23318(), this.method_23321(), volume, this.method_6017(), this.field_6002.field_38861.method_43055());
                for (class_3222 player : ((class_3218)this.field_6002).method_8503().method_3760().method_14571()) {
                    double f;
                    double e;
                    double d;
                    if (!player.method_5869() || player.field_6002.method_27983() != this.field_6002.method_27983() || !((d = this.method_23317() - player.method_23317()) * d + (e = this.method_23318() - player.method_23318()) * e + (f = this.method_23321() - player.method_23321()) * f < radius * radius)) continue;
                    player.field_13987.method_14364((class_2596)packet);
                }
            }
        } else {
            super.method_5966();
        }
    }

    public int method_5970() {
        return 200;
    }

    protected float method_6107() {
        return this.method_6109() ? super.method_6107() * 0.375f : 0.5f;
    }

    public ServerAnimationInfo startAttack() {
        ServerAnimationInfo attackAnim = (ServerAnimationInfo)this.nextAttackAnimation();
        this.getAnimationLogic().triggerAnimation("Attack", attackAnim, AnimationCategory.ATTACK);
        return attackAnim;
    }

    public boolean attackTarget(class_1309 target) {
        if (this.method_17681() > target.method_17681()) {
            double resistance = 1.0 - target.method_26825(class_5134.field_23718);
            target.method_18799(target.method_18798().method_1031(0.0, 0.4 * resistance + 0.1, 0.0));
        }
        return this.method_6121((class_1297)target);
    }

    public boolean method_6121(class_1297 target) {
        boolean wasEffective = super.method_6121(target);
        if (wasEffective && target instanceof Prehistoric) {
            Prehistoric other = (Prehistoric)target;
            if (other.method_6032() <= other.method_6063() / 2.0f) {
                other.setFleeing(other.method_26825(class_5134.field_23721) < this.method_26825(class_5134.field_23721) * 0.8);
            } else if (other.method_26825(class_5134.field_23721) < this.method_26825(class_5134.field_23721) * 0.5) {
                other.setFleeing(true);
            }
        }
        return wasEffective;
    }

    public void method_5711(byte id) {
        float prev = this.field_6225;
        if (id == 62) {
            Util.spawnItemParticles((class_1297)this, class_1802.field_8317, 3);
        } else if (id == 63) {
            Util.spawnItemParticles((class_1297)this, class_1802.field_8229, 3);
        } else if (id == 64) {
            Util.spawnItemParticles((class_1297)this, class_1802.field_8229, 3);
            Util.spawnItemParticles((class_1297)this, class_1802.field_8046, 3);
        } else if (id == 65) {
            Util.spawnParticles((class_1297)this, (class_2394)class_2398.field_11211, 6);
        } else if (id == 66) {
            Util.spawnParticles((class_1297)this, (class_2394)class_2398.field_11211, this.getAgeInDays());
        } else {
            super.method_5711(id);
        }
        if (prev != this.field_6225 && this.method_26825(class_5134.field_23718) >= 1.0) {
            this.field_6225 = 0.0f;
        }
    }

    private void makeEatingSounds() {
        this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_20614, this.method_5634(), this.method_6107(), this.method_6017(), false);
    }

    public float getMaxTurnDistancePerTick() {
        return class_3532.method_15363((float)(90.0f - this.method_17681() * 35.0f), (float)5.0f, (float)90.0f);
    }

    public float getProximityToNextPathSkip() {
        return this.method_17681() > 0.75f ? this.method_17681() / 2.0f : 0.75f - this.method_17681() / 2.0f;
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        if (Platform.isFabric()) {
            this.synTime = this.field_6002.method_8510() + 20L;
        }
        return NetworkManager.createAddEntityPacket((class_1297)this);
    }

    public abstract PrehistoricEntityInfo info();

    public abstract class_1792 getOrderItem();

    public Map<String, Variant> variants() {
        return EntityVariantLoader.INSTANCE.getVariants(this.info().resourceName);
    }

    public <T extends VariantCondition> List<VariantCondition.WithVariant<T>> variantsByCondition(Class<T> clazz) {
        return EntityVariantLoader.INSTANCE.getVariantsByCondition(clazz, this.info().resourceName);
    }

    public EntityDataLoader.Data data() {
        return this.info().data();
    }

    public Attribute attributes() {
        return this.data().attributes();
    }

    private AI ai() {
        return this.data().ai();
    }

    public PrehistoricEntityInfoAI.Activity aiActivityType() {
        return this.ai().activity();
    }

    public PrehistoricEntityInfoAI.Attacking aiAttackType() {
        return this.ai().attacking();
    }

    public PrehistoricEntityInfoAI.Climbing aiClimbType() {
        return this.ai().climbing();
    }

    public PrehistoricEntityInfoAI.Response aiResponseType() {
        if (this.method_6109() || this.isFleeing()) {
            return PrehistoricEntityInfoAI.Response.SCARED;
        }
        return this.ai().response();
    }

    public PrehistoricEntityInfoAI.Taming aiTameType() {
        return this.ai().taming();
    }

    public PrehistoricEntityInfoAI.Moving aiMovingType() {
        return this.ai().moving();
    }

    @Override
    public Map<AnimationCategory, AnimationHolder> getAnimations() {
        if (this.field_6002.field_9236) {
            return AnimationCategoryLoader.CLIENT.getAnimations(this.animationLocation);
        }
        return AnimationCategoryLoader.SERVER.getAnimations(this.animationLocation);
    }

    @Override
    public Map<String, ? extends AnimationInfo> getAllAnimations() {
        if (this.field_6002.field_9236) {
            return ClientAnimationInfoLoader.INSTANCE.getAnimations(this.animationLocation).animations();
        }
        return this.getServerAnimationInfos();
    }

    @Override
    public AnimationInfo getAnimation(AnimationCategory category) {
        return this.getRandomAnimation(category);
    }

    @Override
    public Map<String, ServerAnimationInfo> getServerAnimationInfos() {
        return ServerAnimationInfoLoader.INSTANCE.getAnimations(this.animationLocation).animations();
    }

    @NotNull
    public AnimationInfo nextAttackAnimation() {
        return this.getAnimation(AnimationCategory.ATTACK);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        PausableAnimationController<Prehistoric> controller = new PausableAnimationController<Prehistoric>(this, "Movement/Idle", 5, this.animationLogic::landPredicate);
        this.registerEatingListeners(controller);
        this.registerControllerWithTriggers(controllerRegistrar, controller);
        PausableAnimationController<Prehistoric> attackController = new PausableAnimationController<Prehistoric>(this, "Attack", 5, this.animationLogic::attackPredicate);
        this.registerControllerWithTriggers(controllerRegistrar, attackController);
    }

    protected void registerControllerWithTriggers(AnimatableManager.ControllerRegistrar controllerRegistrar, AnimationController<? extends Prehistoric> controller) {
        AnimationCategory.CATEGORIES.forEach(category -> this.getAnimations().get(category).addTriggers(controller));
        controllerRegistrar.add(new AnimationController[]{controller});
    }

    protected void registerEatingListeners(AnimationController<? extends Prehistoric> controller, Consumer<String> additional) {
        controller.setParticleKeyframeHandler(event -> {
            if ("eat".equals(event.getKeyframeData().getEffect())) {
                class_238 aabb = this.eatPos == null ? this.method_5830() : new class_238(this.eatPos, this.eatPos);
                switch (this.data().diet()) {
                    case HERBIVORE: {
                        Util.spawnItemParticles(this.field_6002, class_1802.field_8317, 4, aabb);
                        break;
                    }
                    case OMNIVORE: {
                        Util.spawnItemParticles(this.field_6002, class_1802.field_16998, 4, aabb);
                        break;
                    }
                    case PISCIVORE: {
                        Util.spawnItemParticles(this.field_6002, class_1802.field_8429, 4, aabb);
                        break;
                    }
                    case PASSIVE: {
                        Util.spawnItemParticles(this.field_6002, class_1802.field_8054, 4, aabb);
                        break;
                    }
                    default: {
                        Util.spawnItemParticles(this.field_6002, class_1802.field_8046, 4, aabb);
                    }
                }
            }
            additional.accept(event.getKeyframeData().getEffect());
        });
        controller.setSoundKeyframeHandler(event -> {
            if ("eat".equals(event.getKeyframeData().getSound())) {
                this.makeEatingSounds();
            }
            if ("call".equals(event.getKeyframeData().getSound())) {
                this.method_5966();
            }
        });
    }

    protected void registerEatingListeners(AnimationController<? extends Prehistoric> controller) {
        this.registerEatingListeners(controller, effect -> {});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public AnimationLogic<Prehistoric> getAnimationLogic() {
        return this.animationLogic;
    }

    public InstructionSystem getInstructionSystem() {
        return this.instructionSystem;
    }

    @Override
    public class_2487 getDebugTag() {
        return (class_2487)this.field_6011.method_12789(DEBUG);
    }

    @Override
    public void disableCustomAI(byte type, boolean disableAI) {
        if (!Version.debugEnabled()) {
            return;
        }
        class_2487 tag = ((class_2487)this.field_6011.method_12789(DEBUG)).method_10553();
        switch (type) {
            case 0: {
                this.method_5977(disableAI);
                break;
            }
            case 1: {
                tag.method_10556("disableGoalAI", disableAI);
                break;
            }
            case 2: {
                tag.method_10556("disableMoveAI", disableAI);
                break;
            }
            case 3: {
                tag.method_10556("disableLookAI", disableAI);
            }
        }
        this.field_6011.method_12778(DEBUG, (Object)tag);
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.field_6012 > 5) {
                MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)serverLevel.method_18766(serverPlayer -> serverPlayer.method_5739((class_1297)this) < 32.0f), (Object)new C2SDisableAIMessage(this.method_5628(), disableAI, type));
            }
        }
    }

    public record PrehistoricGroupData(int ageInDays) implements class_1315
    {
    }
}

