/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.item.BirdEggItem;
import com.github.teamfossilsarcheology.fossil.item.DNAItem;
import com.github.teamfossilsarcheology.fossil.item.FishEggItem;
import com.github.teamfossilsarcheology.fossil.item.MammalEmbryoItem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public enum VanillaEntityInfo implements EntityInfo
{
    AXOLOTL((class_1299<? extends class_1308>)class_1299.field_28315, PrehistoricMobType.FISH, Diet.INSECTIVORE),
    BAT((class_1299<? extends class_1308>)class_1299.field_6108, PrehistoricMobType.MAMMAL, Diet.INSECTIVORE),
    BEE((class_1299<? extends class_1308>)class_1299.field_6108, PrehistoricMobType.OTHER, Diet.HERBIVORE),
    CAT((class_1299<? extends class_1308>)class_1299.field_16281, PrehistoricMobType.MAMMAL, Diet.CARNIVORE),
    CHICKEN((class_1299<? extends class_1308>)class_1299.field_6132, PrehistoricMobType.VANILLA_BIRD, Diet.HERBIVORE),
    CAMEL((class_1299<? extends class_1308>)class_1299.field_40116, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    COD((class_1299<? extends class_1308>)class_1299.field_6070, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    COW((class_1299<? extends class_1308>)class_1299.field_6085, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    DOLPHIN((class_1299<? extends class_1308>)class_1299.field_6087, PrehistoricMobType.MAMMAL, Diet.PISCI_CARNIVORE),
    DONKEY((class_1299<? extends class_1308>)class_1299.field_6067, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    FOX((class_1299<? extends class_1308>)class_1299.field_17943, PrehistoricMobType.MAMMAL, Diet.OMNIVORE),
    FROG((class_1299<? extends class_1308>)class_1299.field_37419, PrehistoricMobType.OTHER, Diet.HERBIVORE),
    GOAT((class_1299<? extends class_1308>)class_1299.field_30052, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    GLOW_SQUID((class_1299<? extends class_1308>)class_1299.field_28402, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    HOGLIN((class_1299<? extends class_1308>)class_1299.field_21973, PrehistoricMobType.MAMMAL, Diet.OMNIVORE),
    HORSE((class_1299<? extends class_1308>)class_1299.field_6139, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    LLAMA((class_1299<? extends class_1308>)class_1299.field_6074, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    MOOSHROOM((class_1299<? extends class_1308>)class_1299.field_6143, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    OCELOT((class_1299<? extends class_1308>)class_1299.field_6081, PrehistoricMobType.MAMMAL, Diet.CARNIVORE),
    PANDA((class_1299<? extends class_1308>)class_1299.field_6146, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    PARROT((class_1299<? extends class_1308>)class_1299.field_6104, PrehistoricMobType.VANILLA_BIRD, Diet.HERBIVORE),
    PIG((class_1299<? extends class_1308>)class_1299.field_6093, PrehistoricMobType.MAMMAL, Diet.OMNIVORE),
    POLAR_BEAR((class_1299<? extends class_1308>)class_1299.field_6042, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    PUFFERFISH((class_1299<? extends class_1308>)class_1299.field_6062, PrehistoricMobType.FISH, Diet.OMNIVORE),
    RABBIT((class_1299<? extends class_1308>)class_1299.field_6140, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    SALMON((class_1299<? extends class_1308>)class_1299.field_6073, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    SHEEP((class_1299<? extends class_1308>)class_1299.field_6115, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    SQUID((class_1299<? extends class_1308>)class_1299.field_6114, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    STRIDER((class_1299<? extends class_1308>)class_1299.field_23214, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    TROPICAL_FISH((class_1299<? extends class_1308>)class_1299.field_6111, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    TURTLE((class_1299<? extends class_1308>)class_1299.field_6113, PrehistoricMobType.OTHER, Diet.HERBIVORE),
    WOLF((class_1299<? extends class_1308>)class_1299.field_6055, PrehistoricMobType.MAMMAL, Diet.CARNIVORE);

    private final class_1299<? extends class_1297> entityType;
    public final PrehistoricMobType mobType;
    public final Diet diet;
    public final String resourceName;
    public final Supplier<class_2561> displayName;
    public class_1792 dnaItem;
    public class_1792 eggItem;
    public class_1792 embryoItem;
    public class_1792 cultivatedBirdEggItem;

    private VanillaEntityInfo(class_1299<? extends class_1308> entityType, PrehistoricMobType mobType, Diet diet) {
        this.entityType = entityType;
        this.mobType = mobType;
        this.diet = diet;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
        this.displayName = () -> class_2561.method_43471((String)("entity.minecraft." + this.resourceName));
    }

    public static void register() {
        for (VanillaEntityInfo info : VanillaEntityInfo.values()) {
            ModItems.ITEMS.register(info.resourceName + "_dna", () -> new DNAItem(info)).listen(item -> {
                info.dnaItem = item;
            });
            if (info.mobType == PrehistoricMobType.FISH) {
                VanillaEntityInfo.registerItem("egg_item", info, properties -> new FishEggItem(info), item -> {
                    info.eggItem = item;
                });
                continue;
            }
            if (info.mobType == PrehistoricMobType.MAMMAL) {
                VanillaEntityInfo.registerItem("syringe", info, properties -> new MammalEmbryoItem(info), item -> {
                    info.embryoItem = item;
                });
                continue;
            }
            if (info.mobType != PrehistoricMobType.VANILLA_BIRD) continue;
            VanillaEntityInfo.registerItem("egg_item", info, properties -> new BirdEggItem((EntityInfo)info, true), item -> {
                info.cultivatedBirdEggItem = item;
            });
        }
    }

    private static void registerItem(String name, VanillaEntityInfo info, Function<class_1792.class_1793, class_1792> item, Consumer<class_1792> listener) {
        ModItems.ITEMS.register(name + "_" + info.resourceName, () -> (class_1792)item.apply(new class_1792.class_1793().arch$tab(ModTabs.FA_MOB_ITEM_TAB))).listen(listener);
    }

    @Override
    public class_1299<? extends class_1297> entityType() {
        return this.entityType;
    }

    @Override
    public PrehistoricMobType mobType() {
        return this.mobType;
    }

    @Override
    @Nullable
    public class_1792 getDNAResult() {
        if (this.eggItem != null) {
            return this.eggItem;
        }
        if (this.embryoItem != null) {
            return this.embryoItem;
        }
        if (this.cultivatedBirdEggItem != null) {
            return this.cultivatedBirdEggItem;
        }
        return null;
    }

    @Override
    public Supplier<class_2561> displayName() {
        return this.displayName;
    }

    @Override
    public class_1792 dnaItem() {
        return this.dnaItem;
    }
}

