/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.fish;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFish;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Nautilus
extends PrehistoricFish {
    private static final String SWIM_BACKWARDS = "animation.nautilus.swim_backwards";
    private static final String SWIM_FORWARDS = "animation.nautilus.swim_forwards";
    private static final String SHELL_RETRACT = "animation.nautilus.shell_retract";
    private static final String SHELL_EMERGE = "animation.nautilus.shell_emerge";
    private static final RawAnimation SHELL_CLOSE = RawAnimation.begin().thenPlay("animation.nautilus.shell_retract");
    private static final RawAnimation SHELL_OPEN = RawAnimation.begin().thenPlay("animation.nautilus.shell_emerge");
    private static final class_2940<Boolean> IS_IN_SHELL = class_2945.method_12791(Nautilus.class, (class_2941)class_2943.field_13323);
    private static final class_4048 SHELL_DIMENSIONS = class_4048.method_18385((float)1.0f, (float)0.5f);
    private float ticksUntilShellUpdate = 0.0f;
    private float ticksInShell = -1.0f;

    public Nautilus(class_1299<Nautilus> entityType, class_1937 level) {
        super(entityType, level);
    }

    private static boolean getsScaredBy(class_1297 entity) {
        class_1657 player;
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_7337() && !player.method_7325()) {
            return true;
        }
        if (entity instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)entity;
            return prehistoric.data().diet().canEat(FoodType.FISH);
        }
        if (entity instanceof Nautilus) {
            return false;
        }
        return (double)entity.method_17681() >= 1.2;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_IN_SHELL, (Object)false);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("InShell", this.isInShell());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.hideInShell(compound.method_10577("InShell"));
    }

    @Override
    @NotNull
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.NAUTILUS;
    }

    @Override
    public void method_6091(class_243 travelVector) {
        if (this.isInShell() && this.method_5799()) {
            if (!this.field_6002.field_9236) {
                this.method_18800(0.0, -0.05, 0.0);
                this.method_5784(class_1313.field_6308, this.method_18798());
            }
        } else {
            super.method_6091(travelVector);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (!this.field_6002.field_9236) {
            if (this.ticksUntilShellUpdate > 0.0f) {
                this.ticksUntilShellUpdate -= 1.0f;
            }
            if (this.ticksInShell > -1.0f) {
                this.ticksInShell += 1.0f;
            }
            if (this.isInShell() && this.ticksInShell > 20.0f) {
                this.method_38785();
            }
            if (this.ticksUntilShellUpdate == 0.0f) {
                List nearbyMobs = this.field_6002.method_8390(class_1309.class, this.method_5829().method_1009(2.0, 2.0, 2.0), Nautilus::getsScaredBy);
                if (!nearbyMobs.isEmpty()) {
                    this.closeShell();
                }
                if (this.shouldBeBeached()) {
                    this.closeShell();
                }
                if (this.ticksInShell > 20.0f && this.ticksUntilShellUpdate == 0.0f && this.isInShell() && nearbyMobs.isEmpty()) {
                    this.openShell();
                }
            }
        }
        if (this.field_6012 % 20 == 0) {
            class_243 oldPos = this.method_19538();
            this.method_18382();
            this.method_5814(this.method_23317(), oldPos.field_1351, this.method_23321());
        }
    }

    @NotNull
    public class_4048 method_18377(class_4050 pose) {
        return this.shouldBeBeached() ? SHELL_DIMENSIONS : super.method_18377(pose);
    }

    @NotNull
    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8145)) {
            if (!this.field_6002.field_9236) {
                this.openShell();
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5992(player, hand);
    }

    protected void method_6673(int airSupply) {
        if (!this.isInShell()) {
            super.method_6673(airSupply);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (amount > 0.0f && this.isInShell() && this.ticksInShell > 20.0f && source.method_5529() != null) {
            this.method_5783(class_3417.field_15075, 1.0f, this.field_5974.method_43057() + 0.8f);
            if (this.method_5854() != null) {
                return super.method_5643(source, amount);
            }
            return false;
        }
        this.closeShell();
        return super.method_5643(source, amount);
    }

    public boolean method_5675() {
        return this.isInShell();
    }

    private boolean shouldBeBeached() {
        if (this.method_5799() || this.field_6002.method_8316(this.method_24515()).method_15767(class_3486.field_15517)) {
            return false;
        }
        return this.method_24828() || !this.field_6002.method_8316(this.method_24515().method_10074()).method_15767(class_3486.field_15517);
    }

    public boolean isInShell() {
        return (Boolean)this.field_6011.method_12789(IS_IN_SHELL);
    }

    public void hideInShell(boolean close) {
        if (close) {
            this.closeShell();
        } else {
            this.openShell();
        }
    }

    public void closeShell() {
        if (!((Boolean)this.field_6011.method_12789(IS_IN_SHELL)).booleanValue()) {
            this.ticksInShell = 0.0f;
        }
        this.field_6011.method_12778(IS_IN_SHELL, (Object)true);
        this.ticksUntilShellUpdate = 60.0f;
    }

    public void openShell() {
        this.field_6011.method_12778(IS_IN_SHELL, (Object)false);
        this.ticksUntilShellUpdate = 60.0f;
        this.ticksInShell = -1.0f;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new PausableAnimationController<Nautilus>(this, "Movement/Idle", 20, event -> {
            AnimationController ctrl = event.getController();
            if (this.shouldBeBeached()) {
                ctrl.setAnimation(RawAnimation.begin().thenPlay(this.nextBeachedAnimation().animation.name()));
            } else {
                if (this.isInShell() && this.method_5799()) {
                    return PlayState.STOP;
                }
                if (event.isMoving()) {
                    ctrl.setAnimation(RawAnimation.begin().thenPlay(this.nextWalkingAnimation().animation.name()));
                } else {
                    ctrl.setAnimation(RawAnimation.begin().thenPlay(this.nextIdleAnimation().animation.name()));
                }
            }
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new PausableAnimationController<Nautilus>(this, "Shell", 4, this::shellPredicate)});
    }

    private PlayState shellPredicate(AnimationState<Nautilus> state) {
        if (((Nautilus)state.getAnimatable()).isInShell()) {
            state.setAnimation(SHELL_CLOSE);
        } else if (state.isCurrentAnimation(SHELL_CLOSE)) {
            state.setAnimation(SHELL_OPEN);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public AnimationInfo getAnimation(AnimationCategory category) {
        if (category == AnimationCategory.SWIM) {
            return this.getAllAnimations().get(SWIM_BACKWARDS);
        }
        if (category == AnimationCategory.SWIM_FAST) {
            return this.getAllAnimations().get(SWIM_FORWARDS);
        }
        return super.getAnimation(category);
    }
}

