/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming;

import com.github.teamfossilsarcheology.fossil.entity.ai.DinoFollowOwnerGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoMatingGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoPanicGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoRandomSwimGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatFromFeederGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatItemEntityGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EnterWaterGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.HuntingTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.WaterPlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomSwimMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.MeganeuraFlyingMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.AmphibiousPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.MeganeuraAttachSystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SleepSystem;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1332;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5530;
import net.minecraft.class_5533;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Meganeura
extends Prehistoric
implements class_1432,
SwimmingAnimal {
    public static final String ATTACK = "animation.meganeura.attack";
    public static final String IDLE = "animation.meganeura.idle";
    public static final String WALK = "animation.meganeura.walk";
    public static final class_2940<Float> ATTACHED_X = class_2945.method_12791(Meganeura.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> ATTACHED_Y = class_2945.method_12791(Meganeura.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> ATTACHED_Z = class_2945.method_12791(Meganeura.class, (class_2941)class_2943.field_13320);
    public static final class_2940<class_2350> ATTACHED_FACE = class_2945.method_12791(Meganeura.class, (class_2941)class_2943.field_13321);
    public static final class_2940<Boolean> ATTACHED = class_2945.method_12791(Meganeura.class, (class_2941)class_2943.field_13323);
    private final MeganeuraAttachSystem attachSystem = this.registerSystem(new MeganeuraAttachSystem(this));
    private final class_1408 flightNav = new class_1407((class_1308)this, this.field_6002);
    private final class_1408 amphibiousNav = new AmphibiousPathNavigation<Meganeura>(this, this.field_6002);
    private final class_1335 flightMoveControl = new MeganeuraFlyingMoveControl(this);
    private final class_1335 aquaticMoveControl = new CustomSwimMoveControl<Meganeura>(this);
    private final class_1335 landMoveControl = new SmoothTurningMoveControl(this);
    protected boolean isLandNavigator;
    protected boolean isAirNavigator;
    private int timeInWater = 0;
    private int timeOnLand = 0;
    private int dimensionSwitchCooldown = -1;

    public Meganeura(class_1299<Meganeura> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5959() {
        this.matingGoal = new DinoMatingGoal(this, 1.0);
        this.field_6201.method_6277(0, (class_1352)new DinoPanicGoal(this, 1.5));
        this.field_6201.method_6277(12, (class_1352)this.matingGoal);
        this.field_6201.method_6277(15, (class_1352)new EatFromFeederGoal(this));
        this.field_6201.method_6277(16, (class_1352)new EatItemEntityGoal(this));
        this.field_6201.method_6277(17, new WaterPlayGoal<Meganeura>(this, 1.0));
        this.field_6201.method_6277(20, (class_1352)new DinoFollowOwnerGoal(this, this.attributes().sprintMod(), 5.0f, 2.0f, false));
        this.field_6201.method_6277(21, new EnterWaterGoal<Meganeura>(this, 1.0f));
        this.field_6201.method_6277(22, (class_1352)new MeganeuraWanderAndAttachGoal(this));
        this.field_6201.method_6277(23, new DinoRandomSwimGoal<Meganeura>(this, 1.0));
        this.field_6201.method_6277(25, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new DinoOwnerHurtByTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new DinoOwnerHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new DinoHurtByTargetGoal(this));
        this.field_6185.method_6277(5, (class_1352)new HuntingTargetGoal(this));
    }

    @Override
    protected void method_20417() {
        boolean bl = !this.method_6113() && !this.attachSystem.isAttached();
        this.field_6201.method_6276(class_1352.class_4134.field_18405, bl && !this.sitSystem.isSitting());
        this.field_6201.method_6276(class_1352.class_4134.field_18407, bl && !this.sitSystem.isSitting());
        this.field_6201.method_6276(class_1352.class_4134.field_18406, bl);
    }

    @Override
    public void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACHED_X, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(ATTACHED_Y, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(ATTACHED_Z, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(ATTACHED_FACE, (Object)class_2350.field_11036);
        this.field_6011.method_12784(ATTACHED, (Object)false);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        if (ATTACHED_FACE.equals(key)) {
            if (this.attachSystem.getAttachmentFace() == class_2350.field_11036) {
                this.dimensionSwitchCooldown = 20;
            } else {
                this.method_18382();
            }
        }
        super.method_5674(key);
    }

    @Override
    @NotNull
    protected SleepSystem createSleepSystem() {
        return new MeganeuraSleepSystem(this);
    }

    @Override
    protected boolean canAgeUpNaturally() {
        if (this.method_5799() && this.method_6109() && (this.method_5618() + 1) / 24000 >= this.data().teenAgeDays()) {
            return false;
        }
        return super.canAgeUpNaturally();
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source == class_1282.field_5855) {
            return false;
        }
        boolean hurt = super.method_5643(source, amount);
        if (hurt) {
            this.attachSystem.stopAttaching(1000 + this.field_5974.method_43048(1500));
        }
        return hurt;
    }

    @Override
    @NotNull
    public class_4048 method_18377(class_4050 poseIn) {
        if (this.usesAttachHitBox()) {
            return super.method_18377(poseIn).method_19539(1.0f, 2.0f);
        }
        return super.method_18377(poseIn);
    }

    public boolean method_5640(double distance) {
        double d = this.method_17681();
        if (Double.isNaN(d)) {
            d = 1.0;
        }
        return distance < (d *= 64.0 * Meganeura.method_5824()) * d;
    }

    @Override
    protected void method_5958() {
        this.switchNavigator();
        super.method_5958();
        if (this.method_5799()) {
            ++this.timeInWater;
            this.timeOnLand = 0;
        } else if (this.field_5952) {
            this.timeInWater = 0;
            ++this.timeOnLand;
        }
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.dimensionSwitchCooldown > 0) {
            --this.dimensionSwitchCooldown;
            if (this.dimensionSwitchCooldown == 0) {
                this.method_18382();
                this.dimensionSwitchCooldown = -1;
            }
        }
    }

    protected void method_5623(double y, boolean onGround, class_2680 state, class_2338 pos) {
    }

    @Override
    public boolean method_5810() {
        return super.method_5810() && !this.attachSystem.isAttached();
    }

    public boolean method_6581() {
        return !this.method_24828() && !this.attachSystem.isAttached();
    }

    private void switchNavigator() {
        if (this.isLandNavigator) {
            if (this.method_6109()) {
                if (this.method_5799()) {
                    this.field_6207 = this.aquaticMoveControl;
                    this.field_6206 = new class_1332((class_1308)this, 20);
                    this.field_6189 = this.amphibiousNav;
                    this.isLandNavigator = false;
                }
            } else {
                this.field_6207 = this.flightMoveControl;
                this.field_6206 = new class_1333((class_1308)this);
                this.field_6189 = this.flightNav;
                this.isLandNavigator = false;
                this.isAirNavigator = true;
            }
        } else if (this.isAirNavigator) {
            if (this.method_6109()) {
                this.field_6207 = this.landMoveControl;
                this.field_6206 = new class_1333((class_1308)this);
                this.field_6189 = this.amphibiousNav;
                this.isLandNavigator = true;
                this.isAirNavigator = false;
            }
        } else if (this.method_6109()) {
            if (!this.method_5799() && this.method_24828()) {
                this.field_6207 = this.landMoveControl;
                this.field_6206 = new class_1333((class_1308)this);
                this.field_6189 = this.amphibiousNav;
                this.isLandNavigator = true;
            }
        } else {
            this.field_6207 = this.flightMoveControl;
            this.field_6206 = new class_1333((class_1308)this);
            this.field_6189 = this.flightNav;
            this.isLandNavigator = false;
            this.isAirNavigator = true;
        }
    }

    public MeganeuraAttachSystem getAttachSystem() {
        return this.attachSystem;
    }

    public boolean usesAttachHitBox() {
        return this.attachSystem == null || this.attachSystem.getAttachmentFace().method_10166().method_10179();
    }

    @Override
    public int timeInWater() {
        return this.timeInWater;
    }

    @Override
    public int timeOnLand() {
        return this.timeOnLand;
    }

    public boolean method_5675() {
        return !this.method_6109();
    }

    public boolean method_6094() {
        return this.method_6109();
    }

    @Override
    public boolean isAmphibious() {
        return this.method_6109();
    }

    @Override
    public boolean canSwim() {
        return this.method_6109();
    }

    @Override
    public double swimSpeed() {
        return 1.0;
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.MEGANEURA;
    }

    @Override
    public class_1792 getOrderItem() {
        return class_1802.field_8107;
    }

    @Override
    public PrehistoricEntityInfoAI.Moving aiMovingType() {
        return this.method_6109() ? PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC : PrehistoricEntityInfoAI.Moving.FLIGHT;
    }

    @NotNull
    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)ModSounds.MEGANEURA_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)ModSounds.MEGANEURA_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)ModSounds.MEGANEURA_DEATH.get();
    }

    @Override
    protected float method_6107() {
        return super.method_6107() * 0.5f;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationLogic<Prehistoric> animationLogic = this.getAnimationLogic();
        PausableAnimationController<Meganeura> ctrl = new PausableAnimationController<Meganeura>(this, "Movement/Idle", 5, state -> {
            AnimationController controller = state.getController();
            if (animationLogic.tryNextAnimation(state, controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = animationLogic.getActiveAnimation(controller.getName());
            Animation.LoopType loopType = null;
            if (activeAnimation.isPresent() && activeAnimation.get().forced() && !animationLogic.isAnimationDone(controller.getName())) {
                loopType = activeAnimation.get().loop() ? Animation.LoopType.LOOP : Animation.LoopType.PLAY_ONCE;
            } else if (this.method_6113()) {
                animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (this.sitSystem.isSitting()) {
                animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
            } else if (state.isMoving()) {
                if (this.method_6109()) {
                    if (this.method_5799()) {
                        animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.SWIM);
                    }
                } else if (this.method_5799()) {
                    animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
                } else if (this.method_6581()) {
                    animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.FLY);
                }
            } else if (this.method_6581()) {
                animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.FLY);
            } else {
                animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
            }
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = animationLogic.getActiveAnimation(controller.getName());
            if (newAnimation.isPresent()) {
                if (loopType == null) {
                    loopType = newAnimation.get().loop() ? Animation.LoopType.LOOP : Animation.LoopType.PLAY_ONCE;
                }
                controller.setAnimation(RawAnimation.begin().then(newAnimation.get().animationName(), loopType));
            }
            return PlayState.CONTINUE;
        });
        this.registerEatingListeners(ctrl);
        controllerRegistrar.add(new AnimationController[]{ctrl});
        AnimationController[] animationControllerArray = new AnimationController[1];
        animationControllerArray[0] = new PausableAnimationController<Meganeura>(this, "Attack", 0, this.getAnimationLogic()::attackPredicate);
        controllerRegistrar.add(animationControllerArray);
    }

    static class MeganeuraWanderAndAttachGoal
    extends DinoWanderGoal {
        private final Meganeura meganeura;

        public MeganeuraWanderAndAttachGoal(Meganeura meganeura) {
            super(meganeura, 1.0, 10);
            this.meganeura = meganeura;
        }

        @Override
        public boolean method_6264() {
            if (this.meganeura.method_6109() || this.meganeura.attachSystem.attachStarted()) {
                return false;
            }
            return super.method_6264();
        }

        @Override
        @Nullable
        protected class_243 method_6302() {
            if (this.meganeura.attachSystem.getAttachCooldown() == 0) {
                class_5819 random = this.meganeura.field_5974;
                class_1937 level = this.field_6566.field_6002;
                for (int i = 0; i < 5; ++i) {
                    class_2338 blockPos = this.field_6566.method_24515().method_10069(random.method_43048(16) - 8, random.method_43048(10) - 2, random.method_43048(16) - 8);
                    class_3965 hitResult = level.method_17742(new class_3959(this.field_6566.method_33571(), class_243.method_24953((class_2382)blockPos), class_3959.class_3960.field_17558, class_3959.class_242.field_36338, (class_1297)this.field_6566));
                    if (hitResult.method_17783() == class_239.class_240.field_1333 || hitResult.method_17780().method_10166().method_10178() || !level.method_8320(hitResult.method_17777()).method_26206((class_1922)level, hitResult.method_17777(), hitResult.method_17780())) continue;
                    this.meganeura.attachSystem.setAttachTarget(hitResult.method_17777().method_10062(), hitResult.method_17780());
                    return class_243.method_24953((class_2382)hitResult.method_17777());
                }
            }
            class_243 view = this.field_6566.method_5828(0.0f);
            class_243 pos = class_5533.method_31524((class_1314)this.field_6566, (int)8, (int)7, (double)view.field_1352, (double)view.field_1350, (float)1.5707964f, (int)3, (int)1);
            if (pos != null) {
                return pos;
            }
            return class_5530.method_31504((class_1314)this.field_6566, (int)8, (int)4, (int)-2, (double)view.field_1352, (double)view.field_1350, (double)1.5707963705062866);
        }
    }

    class MeganeuraSleepSystem
    extends SleepSystem {
        public MeganeuraSleepSystem(Meganeura mob) {
            super(mob);
        }

        @Override
        protected boolean canSleep() {
            if (!super.canSleep()) {
                return false;
            }
            if (!Meganeura.this.method_6109() && !Meganeura.this.attachSystem.isAttached()) {
                if (!Meganeura.this.attachSystem.attachStarted()) {
                    Meganeura.this.attachSystem.setAttachCooldown(0);
                }
                return false;
            }
            return true;
        }
    }
}

