/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import net.minecraft.class_2487;

public class SleepSystem
extends AISystem {
    private static final int MAX_SLEEP_DURATION = 6000;
    private boolean sleepForced;
    private int ticksSlept;
    private int cathermalSleepCooldown;

    public SleepSystem(Prehistoric mob) {
        super(mob);
        this.cathermalSleepCooldown = 5000 + this.mob.method_6051().method_43048(3000);
    }

    @Override
    public void serverTick() {
        if (this.cathermalSleepCooldown > 0) {
            --this.cathermalSleepCooldown;
        }
        this.trySleeping();
        if (this.mob.method_6113() && !this.sleepForced) {
            ++this.ticksSlept;
            if (this.ticksSlept > 100 && this.mob.method_6051().method_43048(100) == 0 && !this.wantsToSleep()) {
                this.setSleeping(false);
            }
            if (this.ticksSlept > 6000) {
                this.setSleeping(false);
            }
            if (this.mob.field_6012 % 10 == 0 && !this.canSleep()) {
                this.setSleeping(false);
            }
        }
    }

    protected void trySleeping() {
        if (this.mob.method_6113()) {
            return;
        }
        if (this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.BOTH) {
            if (this.mob.method_6051().method_43048(1200) == 0 && this.wantsToSleep() && this.canSleep()) {
                this.setSleeping(true);
                this.ticksSlept = 0;
            }
        } else if (this.mob.aiActivityType() != PrehistoricEntityInfoAI.Activity.NO_SLEEP && this.mob.method_6051().method_43048(200) == 0 && this.wantsToSleep() && this.canSleep()) {
            this.setSleeping(true);
            this.ticksSlept = 0;
        }
    }

    protected boolean canSleep() {
        if (this.isDisabled() || this.mob.hasTarget() || this.mob.method_6065() != null || this.mob.getCurrentOrder() == OrderType.FOLLOW || this.mob.method_5782()) {
            return false;
        }
        if (this.mob.isDeadlyHungry()) {
            return false;
        }
        if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC) {
            return this.mob.method_5799();
        }
        if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC) {
            return this.mob.method_5799() || this.mob.method_24828();
        }
        return this.mob.method_24828() && !this.mob.method_5799();
    }

    public boolean wantsToSleep() {
        if (this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.DIURNAL) {
            return !this.mob.field_6002.method_8530();
        }
        if (this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.NOCTURNAL) {
            if (!this.mob.field_6002.method_8530()) {
                return false;
            }
            if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC || this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC) {
                return this.mob.method_5799() || !this.mob.field_6002.method_8311(this.mob.method_24515().method_10084());
            }
            return !this.mob.field_6002.method_8311(this.mob.method_24515().method_10084());
        }
        return this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.BOTH && this.ticksSlept <= 4000 && this.cathermalSleepCooldown == 0;
    }

    public void setSleepForced(boolean sleepForced) {
        this.sleepForced = sleepForced;
    }

    public void setSleeping(boolean sleeping) {
        this.mob.method_5841().method_12778(Prehistoric.SLEEPING, (Object)sleeping);
        if (!sleeping) {
            this.cathermalSleepCooldown = 10000 + this.mob.method_6051().method_43048(6000);
            this.mob.updatePose();
        } else {
            this.ticksSlept = 0;
            this.mob.updatePose();
            this.mob.method_5942().method_6340();
            this.mob.method_18800(0.0, this.mob.method_18798().field_1351, 0.0);
            this.mob.field_6007 = true;
        }
    }

    @Override
    public void saveAdditional(class_2487 tag) {
        tag.method_10556("Sleeping", this.mob.method_6113());
        tag.method_10569("TicksSlept", this.ticksSlept);
        tag.method_10569("CathermalTimer", this.cathermalSleepCooldown);
    }

    @Override
    public void load(class_2487 tag) {
        this.setSleeping(tag.method_10577("Sleeping"));
        this.ticksSlept = tag.method_10550("TicksSlept");
        this.cathermalSleepCooldown = tag.method_10550("CathermalTimer");
    }
}

