/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.util;

import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.BrewinAndChewinCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.CasualnessDelightCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.CoffeeDelightCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.CulturalDelightCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.EndDelightCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.ExpandedDelightCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.FarmerRespiteCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.FestiveDelightCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.NetherDelightCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.OceanDelightCompat;
import com.github.teamfossilsarcheology.fossil.fabric.compat.farmers.addon.PineappleDelightCompat;
import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;

public class AddonConstants {
    private static final Map<String, Consumer<FoodMappingsManager>> SUPPORTED_ADDONS = new HashMap<String, Consumer<FoodMappingsManager>>();

    public static void registerAddonFoodMappings(FoodMappingsManager manager) {
        for (Map.Entry<String, Consumer<FoodMappingsManager>> entry : SUPPORTED_ADDONS.entrySet()) {
            if (!FabricLoader.getInstance().isModLoaded(entry.getKey())) continue;
            entry.getValue().accept(manager);
        }
    }

    private static void register(String modId, Consumer<FoodMappingsManager> function) {
        SUPPORTED_ADDONS.put(modId, function);
    }

    static {
        AddonConstants.register("brewinandchewin", BrewinAndChewinCompat::registerFoodMappings);
        AddonConstants.register("casualness_delight", CasualnessDelightCompat::registerFoodMappings);
        AddonConstants.register("culturaldelights", CulturalDelightCompat::registerFoodMappings);
        AddonConstants.register("coffee_delight", CoffeeDelightCompat::registerFoodMappings);
        AddonConstants.register("ends_delight", EndDelightCompat::registerFoodMappings);
        AddonConstants.register("expandeddelight", ExpandedDelightCompat::registerFoodMappings);
        AddonConstants.register("farmersrespite", FarmerRespiteCompat::registerFoodMappings);
        AddonConstants.register("festive_delight", FestiveDelightCompat::registerFoodMappings);
        AddonConstants.register("nethersdelight", NetherDelightCompat::registerFoodMappings);
        AddonConstants.register("oceansdelight", OceanDelightCompat::registerFoodMappings);
        AddonConstants.register("pineapple_delight", PineappleDelightCompat::registerFoodMappings);
    }
}

