/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1412;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public abstract class FoodMappings {
    public static int getFoodAmount(class_1935 itemLike, FoodType diet) {
        return FoodMappingsManager.INSTANCE.getItemValues(diet).getOrDefault(itemLike.method_8389(), 0);
    }

    public static int getFoodAmount(class_1935 itemLike, Diet diet) {
        Set<FoodType> valid = diet.flags();
        for (FoodType type : valid) {
            if (!FoodMappingsManager.INSTANCE.getItemValues(type).containsKey(itemLike.method_8389())) continue;
            return FoodMappingsManager.INSTANCE.getItemValues(type).get(itemLike.method_8389());
        }
        return 0;
    }

    public static int getMobFoodPoints(class_1309 entity, Diet diet) {
        String namespace;
        if (entity == null) {
            return 0;
        }
        class_1299 entityType = entity.method_5864();
        if (!(FossilConfig.isEnabled("dinosEatModdedMobs") || (namespace = class_7923.field_41177.method_10221((Object)entityType).method_12836()).equals("fossil") || namespace.equals("minecraft"))) {
            return 0;
        }
        Set<FoodType> valid = diet.flags();
        if (FoodMappingsManager.INSTANCE.hasEntityEntry(entityType)) {
            for (FoodType type1 : valid) {
                if (!FoodMappingsManager.INSTANCE.getEntityValues(type1).containsKey(entityType)) continue;
                int mappingPoints = FoodMappingsManager.INSTANCE.getEntityValues(type1).get(entityType);
                if (mappingPoints > 0) {
                    float scale = entity.method_17681() / entityType.method_18386().field_18067 * entity.method_17682() / entityType.method_18386().field_18068;
                    return Math.round((float)mappingPoints * scale);
                }
                return Math.round(entity.method_17681() * entity.method_17682() * 10.0f);
            }
        } else {
            if (valid.contains((Object)FoodType.MEAT) && entity instanceof class_1429 && !FoodMappings.isAquaticMob(entity)) {
                return Math.round(entity.method_17681() * entity.method_17682() * 10.0f);
            }
            if (valid.contains((Object)FoodType.FISH) && FoodMappings.isAquaticMob(entity)) {
                return Math.round(entity.method_17681() * entity.method_17682() * 10.0f);
            }
            return 0;
        }
        return 0;
    }

    private static boolean isAquaticMob(class_1309 entity) {
        class_1308 mob;
        return entity.method_6094() || entity instanceof class_1480 || entity instanceof class_1308 && (mob = (class_1308)entity).method_5942() instanceof class_1412;
    }

    public static void addMeat(class_1299<?> entity, int food) {
        FoodMappingsManager.INSTANCE.addEntity(FoodType.MEAT, entity, food);
    }

    public static void addMeat(class_1935 itemLike) {
        int food = itemLike.method_8389().method_19264() != null ? itemLike.method_8389().method_19264().method_19230() * 7 : 20;
        FoodMappings.addMeat(itemLike, food);
    }

    public static void addMeat(class_1935 itemLike, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.MEAT, itemLike.method_8389(), food);
    }

    public static void addFish(class_1299<?> entity, int food) {
        FoodMappingsManager.INSTANCE.addEntity(FoodType.FISH, entity, food);
    }

    public static void addFish(class_1792 item) {
        int food = item.method_19264() != null ? item.method_19264().method_19230() * 7 : 10;
        FoodMappings.addFish(item, food);
    }

    public static void addFish(class_1792 item, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.FISH, item, food);
    }

    public static void addEgg(class_1792 item) {
        int food = item.method_19264() != null ? item.method_19264().method_19230() * 7 : 15;
        FoodMappings.addEgg(item, food);
    }

    public static void addEgg(class_1792 item, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.EGG, item, food);
    }

    public static void addPlant(class_2248 block, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.PLANT, block.method_8389(), food);
    }

    public static void addPlant(class_1792 item) {
        int food = item.method_19264() != null ? item.method_19264().method_19230() * 5 : 17;
        FoodMappings.addPlant(item, food);
    }

    public static void addPlant(class_1792 item, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.PLANT, item, food);
    }
}

